/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.internal.SpecificationMigrator;
import com.ibm.etools.j2ee.migration.internal.WebservicesMigrationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.common.jdt.internal.integration.JavaArtifactEditModel;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.J2EEStatus;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSCDDArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesResource;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddFactory;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class WebServicesClientSpecificationMigrator
extends SpecificationMigrator {
    private static final J2EEStatus WEBSERVICES_OK_STATUS = new J2EEStatus(0, J2EEMigrationUIResourceHandler.WebServicesClientSpecificationMigrator_UI_0);

    public WebServicesClientSpecificationMigrator(String aVersion, boolean complex) {
        super(aVersion, complex);
    }

    public WebServicesClientSpecificationMigrator(XMLResource anXmlResource, String aVersion, boolean complex) {
        super(anXmlResource, aVersion, complex);
    }

    @Override
    protected J2EEStatus migrateTo14(EJBResource ejbResource) {
        WebServicesClient client = null;
        try {
            client = this.getWebservicesClient((XMLResource)ejbResource);
        }
        catch (WebservicesMigrationException e) {
            return e.status;
        }
        ComponentScopedRefs scopedRefs = null;
        EnterpriseBean enterpriseBean = null;
        EList componentScopedRefs = client.getComponentScopedRefs();
        EJBJar ejbJar = ejbResource.getEJBJar();
        int i = 0;
        while (i < componentScopedRefs.size()) {
            scopedRefs = (ComponentScopedRefs)componentScopedRefs.get(i);
            enterpriseBean = ejbJar.getEnterpriseBeanNamed(scopedRefs.getComponentName());
            if (enterpriseBean != null) {
                enterpriseBean.getServiceRefs().addAll((Collection)this.copy((List)scopedRefs.getServiceRefs()));
                this.migrateQNames((List)enterpriseBean.getServiceRefs());
            }
            ++i;
        }
        this.deleteResource(client);
        return WEBSERVICES_OK_STATUS;
    }

    @Override
    protected J2EEStatus migrateTo14(ApplicationClientResource resource) {
        WebServicesClient client = null;
        try {
            client = this.getWebservicesClient((XMLResource)resource);
        }
        catch (WebservicesMigrationException e) {
            return e.status;
        }
        ApplicationClient appclient = resource.getApplicationClient();
        appclient.getServiceRefs().addAll((Collection)this.copy((List)client.getServiceRefs()));
        this.deleteResource(client);
        this.migrateQNames((List)appclient.getServiceRefs());
        return WEBSERVICES_OK_STATUS;
    }

    @Override
    protected J2EEStatus migrateTo14(WebAppResource resource) {
        WebServicesClient client = null;
        try {
            client = this.getWebservicesClient((XMLResource)resource);
        }
        catch (WebservicesMigrationException e) {
            return e.status;
        }
        WebApp webapp = resource.getWebApp();
        EList serviceRefs = webapp.getServiceRefs();
        serviceRefs.addAll(this.copy((List)client.getServiceRefs()));
        this.deleteResource(client);
        this.migrateQNames((List)serviceRefs);
        return WEBSERVICES_OK_STATUS;
    }

    protected void deleteResource(WebServicesClient client) {
        IVirtualComponent component = ComponentUtilities.findComponent((EObject)client);
        WSCDDArtifactEdit edit = null;
        try {
            edit = WSCDDArtifactEdit.getWSCDDArtifactEditForWrite((IVirtualComponent)component);
            Resource webservicesClientResource = null;
            if (edit != null) {
                webservicesClientResource = edit.getWebServicesClient().eResource();
                JavaArtifactEditModel editModel = (JavaArtifactEditModel)edit.getAdapter(ArtifactEditModel.ADAPTER_TYPE);
                editModel.deleteResource(webservicesClientResource);
                edit.saveIfNecessary(null);
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    protected WebServicesClient getWebservicesClient(XMLResource resource) throws WebservicesMigrationException {
        IVirtualComponent component = ComponentUtilities.findComponent((Resource)resource);
        if (component == null) {
            throw new WebservicesMigrationException(new J2EEStatus(4, J2EEMigrationUIResourceHandler.WebServicesClientSpecificationMigrator_UI_1));
        }
        WSCDDArtifactEdit edit = null;
        try {
            edit = WSCDDArtifactEdit.getWSCDDArtifactEditForRead((IVirtualComponent)component);
            WebServicesResource wResource = edit.getWscddXmiResource();
            WebServicesClient client = null;
            if (wResource != null && wResource.isLoaded()) {
                client = wResource.getWebServicesClient();
            }
            if (client == null) {
                throw new WebservicesMigrationException(new J2EEStatus(1, J2EEMigrationUIResourceHandler.WebServicesClientSpecificationMigrator_UI_3));
            }
            WebServicesClient webServicesClient = client;
            return webServicesClient;
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private List copy(List serviceRefs) {
        ArrayList<EObject> copy = new ArrayList<EObject>();
        for (Object serviceRef : serviceRefs) {
            EObject copiedRef = EtoolsCopyUtility.createCopy((EObject)((EObject)serviceRef));
            copy.add(copiedRef);
        }
        return copy;
    }

    private void migrateQNames(List serviceRefs) {
        int i = 0;
        while (i < serviceRefs.size()) {
            ServiceRef serviceRef = (ServiceRef)serviceRefs.get(i);
            QName qname = serviceRef.getServiceQname();
            if (qname == null) {
                qname = WsddFactory.eINSTANCE.createWSDLService();
                serviceRef.setServiceQname(qname);
            }
            String prefix = "prefix";
            String namespaceURI = qname.getNamespaceURI();
            String localPart = qname.getLocalPart();
            qname.setValues(prefix, namespaceURI, localPart);
            ++i;
        }
    }
}

