/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.ILibModule;
import com.ibm.etools.j2ee.LibModule;
import com.ibm.etools.j2ee.migration.internal.OldJ2EESettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OldWebSettings
extends OldJ2EESettings {
    public static final String WEB_SETTINGS_FILE_NAME = ".websettings";
    static final String ELEMENT_WEBSETTINGS = "websettings";
    static final String ELEMENT_PROJECTTYPE = "project-type";
    static final String ELEMENT_CONTEXTROOT = "context-root";
    static final String ELEMENT_WEBCONTENT = "webcontent";
    static final String ELEMENT_JSPLEVEL = "jsp-level";
    static final String ELEMENT_LIBMODULES = "lib-modules";
    static final String ELEMENT_LIBMODULE = "lib-module";
    static final String ELEMENT_LIBMODULE_JAR = "jar";
    static final String ELEMENT_LIBMODULE_PROJECT = "project";
    static final String ELEMENT_FEATURES = "features";
    static final String ELEMENT_FEATURE = "feature";
    static final String ELEMENT_FEATUREID = "feature-id";
    static final ILibModule[] EMPTY_LIBMODULES = new ILibModule[0];
    static final String[] EMPTY_FEATURES = new String[0];
    static boolean validWebSettings = true;

    public OldWebSettings(IProject project) {
        super(project);
        if (this.getDOMDocument(this.fSettingsFile) == null) {
            validWebSettings = false;
        }
    }

    public OldWebSettings(IProject project, IFile webSettings) {
        super(project, null, webSettings);
        if (this.getDOMDocument(webSettings) == null) {
            validWebSettings = false;
        }
    }

    @Override
    protected IFile getSettingsFile() {
        if (this.fSettingsFile == null) {
            this.fSettingsFile = this.fProject.getFile(WEB_SETTINGS_FILE_NAME);
        }
        return this.fSettingsFile;
    }

    public String getContextRoot() {
        return this.getValue(ELEMENT_CONTEXTROOT);
    }

    public String getJSPLevel() {
        return this.getValue(ELEMENT_JSPLEVEL);
    }

    public String getWebContentName() {
        return this.getValue(ELEMENT_WEBCONTENT);
    }

    public ILibModule[] getLibModules() {
        Element root = this.getRootElement();
        if (root == null) {
            return EMPTY_LIBMODULES;
        }
        Element libModuleNode = this.findChildNode(root, ELEMENT_LIBMODULES);
        if (libModuleNode == null) {
            return EMPTY_LIBMODULES;
        }
        NodeList children = libModuleNode.getChildNodes();
        ArrayList<ILibModule> results = new ArrayList<ILibModule>();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            ILibModule libModule = this.getLibModule(node);
            if (libModule != null) {
                results.add(libModule);
            }
            ++i;
        }
        return results.toArray(new ILibModule[results.size()]);
    }

    protected ILibModule getLibModule(Node node) {
        if (!node.getNodeName().equalsIgnoreCase(ELEMENT_LIBMODULE)) {
            return null;
        }
        String jarName = this.getNodeValue((Element)node, ELEMENT_LIBMODULE_JAR);
        String projectName = this.getNodeValue((Element)node, ELEMENT_LIBMODULE_PROJECT);
        LibModule libModule = new LibModule(jarName, projectName);
        return libModule;
    }

    public String[] getFeatureIds() {
        Element root = this.getRootElement();
        if (root == null) {
            return EMPTY_FEATURES;
        }
        Element featuresNode = this.findChildNode(root, ELEMENT_FEATURES);
        if (featuresNode == null) {
            return EMPTY_FEATURES;
        }
        NodeList children = featuresNode.getChildNodes();
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            String featureId = this.getFeatureId(node);
            if (featureId != null) {
                results.add(featureId);
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    protected String getFeatureId(Node node) {
        if (!node.getNodeName().equalsIgnoreCase(ELEMENT_FEATURE)) {
            return null;
        }
        String id = this.getNodeValue((Element)node, ELEMENT_FEATUREID);
        return id;
    }

    public String getProjectType() {
        return this.getValue(ELEMENT_PROJECTTYPE);
    }

    @Override
    public String getCurrentVersion() {
        IFolder webcontetntFolder = this.fProject.getFolder("WebContent");
        IFolder webinfFolder = webcontetntFolder.getFolder("WEB-INF");
        if (webinfFolder.exists()) {
            return CURRENT_VERSION;
        }
        return CURRENT_VERSION;
    }

    @Override
    protected void createNewDocument() throws CoreException, IOException {
        StringWriter writer = new StringWriter();
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write("\n");
        writer.write("<websettings version=\"");
        writer.write(this.getCurrentVersion());
        writer.write("\">");
        writer.write("\n");
        writer.write("</websettings>");
        writer.write("\n");
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(writer.toString().getBytes("UTF8"));
        IFile webSettingsFile = this.getSettingsFile();
        if (webSettingsFile.exists()) {
            webSettingsFile.setContents((InputStream)sourceStream, true, true, null);
        } else {
            webSettingsFile.create((InputStream)sourceStream, true, null);
        }
        this.read();
    }

    public void setContextRoot(String contextRoot) {
        this.setValue(ELEMENT_CONTEXTROOT, contextRoot);
    }

    public void setJSPLevel(String jspLevel) {
        this.setValue(ELEMENT_JSPLEVEL, jspLevel);
    }

    public void setWebContentName(String name) {
        String defaultName = this.getWebContentName();
        if (defaultName == null || defaultName.length() == 0 || !name.equals(defaultName)) {
            this.setValue(ELEMENT_WEBCONTENT, name);
        }
    }

    public void setProjectType(String projectType) {
        this.setValue(ELEMENT_PROJECTTYPE, projectType);
    }

    public void setLibModules(ILibModule[] libModules) {
        Document doc = this.getOrCreateDocument();
        Node libModulesNode = this.findOrCreateChildNode(doc.getDocumentElement(), ELEMENT_LIBMODULES);
        Node firstChild = null;
        while ((firstChild = libModulesNode.getFirstChild()) != null) {
            libModulesNode.removeChild(firstChild);
        }
        int i = 0;
        while (i < libModules.length) {
            ILibModule iLibModule = libModules[i];
            if (iLibModule != null) {
                this.addLibModule(libModulesNode, iLibModule);
            }
            ++i;
        }
    }

    protected void addLibModule(Node libModulesNode, ILibModule libModule) {
        Document doc = this.getDOMDocument();
        Element libModuleNode = doc.createElement(ELEMENT_LIBMODULE);
        libModulesNode.appendChild(libModuleNode);
        this.setValue(libModuleNode, ELEMENT_LIBMODULE_JAR, libModule.getJarName());
        this.setValue(libModuleNode, ELEMENT_LIBMODULE_PROJECT, libModule.getProjectName());
    }

    public void setFeatureIds(String[] featureIds) {
        Document doc = this.getOrCreateDocument();
        Node featuresNode = this.findOrCreateChildNode(doc.getDocumentElement(), ELEMENT_FEATURES);
        int i = 0;
        while (i < featureIds.length) {
            String sFeatureId = featureIds[i];
            if (sFeatureId != null) {
                this.addFeatureId(featuresNode, sFeatureId);
            }
            ++i;
        }
    }

    protected void addFeatureId(Node featuresNode, String featureId) {
        Document doc = this.getDOMDocument();
        Element featureNode = doc.createElement(ELEMENT_FEATURE);
        featuresNode.appendChild(featureNode);
        this.setValue(featureNode, ELEMENT_FEATUREID, featureId);
    }

    public boolean isValidWebSettings() {
        return validWebSettings;
    }

    public void removeFeatureId(String removeId) {
        Element featuresNode;
        Element root = this.getRootElement();
        if (root != null && (featuresNode = this.findChildNode(root, ELEMENT_FEATURES)) != null) {
            NodeList children = featuresNode.getChildNodes();
            ArrayList<String> results = new ArrayList<String>();
            int i = 0;
            while (i < children.getLength()) {
                Node node = children.item(i);
                String featureId = this.getFeatureId(node);
                if (featureId != null && !featureId.equals(removeId)) {
                    results.add(featureId);
                }
                ++i;
            }
            Node firstChild = null;
            while ((firstChild = featuresNode.getFirstChild()) != null) {
                featuresNode.removeChild(firstChild);
            }
            if (results.size() > 0) {
                String[] updateFeatureIds = results.toArray(new String[results.size()]);
                int i2 = 0;
                while (i2 < results.size()) {
                    String sFeatureId = updateFeatureIds[i2];
                    if (sFeatureId != null) {
                        this.addFeatureId(featuresNode, sFeatureId);
                    }
                    ++i2;
                }
            }
        }
    }

    @Override
    public String getRootNodeName() {
        return ELEMENT_WEBSETTINGS;
    }

    /*
     * Exception decompiling
     */
    public static String getWebContentDirectory(InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 37[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

