/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.internal.SpecificationMigrator;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.J2EEStatus;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.ExceptionMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.InterfaceMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JavaWSDLMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JavaXMLTypeMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapResource;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.JaxrpcmapResourceFactory;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.MethodParamPartsMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.RootTypeQname;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.ServiceEndpointInterfaceMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.ServiceEndpointMethodMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.ServiceInterfaceMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.WSDLBinding;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.WSDLMessage;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.WSDLMessageMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.WSDLPortType;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.WSDLReturnValueMapping;
import org.eclipse.jst.j2ee.webservice.jaxrpcmap.WSDLServiceName;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class JaxrpcmapSpecificationMigrator
extends SpecificationMigrator {
    private String DEFAULT_NAMESPACE_PREFIX = "pfx";
    private String JAXRPC_SUCCESSFUL = J2EEMigrationUIResourceHandler.JaxrpcmapSpecificationMigrator_UI_1;
    private String NO_MODULE_ROOT_FOUND = J2EEMigrationUIResourceHandler.JaxrpcmapSpecificationMigrator_UI_2;
    private J2EEStatus JAXRPCMAP_OK_STATUS = new J2EEStatus(0, this.JAXRPC_SUCCESSFUL);
    protected IVirtualComponent component = null;

    public JaxrpcmapSpecificationMigrator(String aVersion, boolean complex) {
        super(aVersion, complex);
    }

    public JaxrpcmapSpecificationMigrator(XMLResource anXmlResource, String aVersion, boolean complex) {
        super(anXmlResource, aVersion, complex);
    }

    @Override
    protected J2EEStatus migrateTo14(EJBResource ejbResource) {
        ArrayList<String> mappingFileList = new ArrayList<String>();
        IProject project = ProjectUtilities.getProject((Resource)ejbResource);
        ResourceSet resSet = ejbResource.getResourceSet();
        EJBJar ejbJar = ejbResource.getEJBJar();
        for (EnterpriseBean ejb : ejbJar.getEnterpriseBeans()) {
            for (ServiceRef sref : ejb.getServiceRefs()) {
                String mappingFile = sref.getJaxrpcMappingFile();
                if (mappingFile == null || mappingFile.length() <= 0 || mappingFileList.contains(mappingFile)) continue;
                mappingFileList.add(mappingFile);
            }
        }
        this.appendServiceSideMappingFiles((XMLResource)ejbResource, mappingFileList);
        String[] mappingFiles = this.convertToStringArray(mappingFileList.toArray());
        return this.migrateJaxrpcmapTo14(resSet, project, mappingFiles);
    }

    @Override
    protected J2EEStatus migrateTo14(ApplicationClientResource resource) {
        ArrayList<String> mappingFileList = new ArrayList<String>();
        IProject project = ProjectUtilities.getProject((Resource)resource);
        ResourceSet resSet = resource.getResourceSet();
        ApplicationClient appClient = resource.getApplicationClient();
        for (ServiceRef sref : appClient.getServiceRefs()) {
            String mappingFile = sref.getJaxrpcMappingFile();
            if (mappingFile == null || mappingFile.length() <= 0 || mappingFileList.contains(mappingFile)) continue;
            mappingFileList.add(mappingFile);
        }
        String[] mappingFiles = this.convertToStringArray(mappingFileList.toArray());
        return this.migrateJaxrpcmapTo14(resSet, project, mappingFiles);
    }

    @Override
    protected J2EEStatus migrateTo14(WebAppResource resource) {
        ArrayList<String> mappingFileList = new ArrayList<String>();
        IProject project = ProjectUtilities.getProject((Resource)resource);
        ResourceSet resSet = resource.getResourceSet();
        WebApp webApp = resource.getWebApp();
        for (ServiceRef sref : webApp.getServiceRefs()) {
            String mappingFile = sref.getJaxrpcMappingFile();
            if (mappingFile == null || mappingFile.length() <= 0 || mappingFileList.contains(mappingFile)) continue;
            mappingFileList.add(mappingFile);
        }
        this.appendServiceSideMappingFiles((XMLResource)resource, mappingFileList);
        String[] mappingFiles = this.convertToStringArray(mappingFileList.toArray());
        return this.migrateJaxrpcmapTo14(resSet, project, mappingFiles);
    }

    private void appendServiceSideMappingFiles(XMLResource resource, ArrayList mappingFileList) {
        IVirtualComponent component = ComponentUtilities.findComponent((Resource)resource);
        if (component == null) {
            return;
        }
        WSDDArtifactEdit edit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IVirtualComponent)component);
        if (edit == null) {
            return;
        }
        WsddResource wsddResource = edit.getWsddXmiResource();
        if (wsddResource == null) {
            return;
        }
        WebServices ws = wsddResource.getWebServices();
        if (ws == null) {
            return;
        }
        for (WebServiceDescription wsdesc : ws.getWebServiceDescriptions()) {
            String mappingFile = wsdesc.getJaxrpcMappingFile();
            if (mappingFile == null || mappingFile.length() <= 0 || mappingFileList.contains(mappingFile)) continue;
            mappingFileList.add(mappingFile);
        }
    }

    private J2EEStatus migrateJaxrpcmapTo14(ResourceSet resSet, IProject project, String[] moduleRootRelativePathNames) {
        WTPResourceFactoryRegistry registry = (WTPResourceFactoryRegistry)resSet.getResourceFactoryRegistry();
        IContainer moduleRoot = this.getComponent().getRootFolder().getUnderlyingFolder();
        IFolder moduleRootFolder = null;
        if (!(moduleRoot instanceof IFolder)) {
            return new J2EEStatus(2, this.NO_MODULE_ROOT_FOUND);
        }
        moduleRootFolder = (IFolder)moduleRoot;
        int i = 0;
        while (i < moduleRootRelativePathNames.length) {
            String moduleRootRelativePathName = moduleRootRelativePathNames[i];
            String mappingFileName = null;
            int lastSlashIdx = moduleRootRelativePathName.lastIndexOf(47);
            mappingFileName = lastSlashIdx == -1 ? moduleRootRelativePathName : moduleRootRelativePathName.substring(lastSlashIdx + 1);
            registry.registerLastFileSegment(mappingFileName, (Resource.Factory)new JaxrpcmapResourceFactory(RendererFactory.getDefaultRendererFactory()));
            IFile mappingFile = moduleRootFolder.getFile(moduleRootRelativePathName);
            if (mappingFile != null && mappingFile.exists()) {
                URI uri = URI.createPlatformResourceURI((String)mappingFile.getFullPath().toString());
                try {
                    JaxrpcmapResource jaxrpcmapRes = (JaxrpcmapResource)resSet.getResource(uri, true);
                    jaxrpcmapRes.setModuleVersionID(11);
                    EObject rootObject = jaxrpcmapRes.getRootObject();
                    jaxrpcmapRes.getContents().remove((Object)rootObject);
                    jaxrpcmapRes.getContents().add((Object)rootObject);
                    JavaWSDLMapping jwm = jaxrpcmapRes.getJavaWSDLMapping();
                    JavaWSDLMappingMigrator jwmMigrator = new JavaWSDLMappingMigrator();
                    jwmMigrator.migrateTo14(jwm);
                    HashMap options = new HashMap();
                    jaxrpcmapRes.save(options);
                }
                catch (Exception e) {
                    J2EEMigrationPlugin.logError(e);
                }
            }
            ++i;
        }
        return this.JAXRPCMAP_OK_STATUS;
    }

    private String[] convertToStringArray(Object[] a) {
        if (a == null) {
            return new String[0];
        }
        int length = a.length;
        String[] sa = new String[length];
        int i = 0;
        while (i < length) {
            Object obj = a[i];
            if (obj instanceof String) {
                sa[i] = (String)obj;
            }
            ++i;
        }
        return sa;
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    public void setComponent(IVirtualComponent component) {
        this.component = component;
    }

    private class JavaWSDLMappingMigrator {
        private JavaWSDLMappingMigrator() {
        }

        public void migrateTo14(JavaWSDLMapping javaWsdlMapping) {
            Iterator jxtms = javaWsdlMapping.getJavaXMLTypeMappings().iterator();
            Iterator ems = javaWsdlMapping.getExceptionMappings().iterator();
            Iterator ims = javaWsdlMapping.getInterfaceMappings().iterator();
            while (jxtms.hasNext()) {
                JavaXMLTypeMapping jxtm = (JavaXMLTypeMapping)jxtms.next();
                RootTypeQname rtqn = jxtm.getRootTypeQname();
                if (this.qnameIsAnonymous((QName)rtqn)) {
                    jxtm.setRootTypeQname(null);
                    StringBuffer atqnsb = new StringBuffer();
                    atqnsb.append(rtqn.getNamespaceURI());
                    atqnsb.append(":");
                    atqnsb.append(rtqn.getLocalPart());
                    String atqn = atqnsb.toString();
                    jxtm.setAnonymousTypeQname(atqn);
                    continue;
                }
                this.migrateQNameTo14((QName)rtqn);
            }
            while (ems.hasNext()) {
                ExceptionMapping em = (ExceptionMapping)ems.next();
                WSDLMessage wm = em.getWsdlMessage();
                this.migrateQNameTo14((QName)wm);
            }
            while (ims.hasNext()) {
                InterfaceMapping im = (InterfaceMapping)ims.next();
                if (im instanceof ServiceInterfaceMapping) {
                    ServiceInterfaceMapping sim = (ServiceInterfaceMapping)im;
                    WSDLServiceName wsn = sim.getWsdlServiceName();
                    this.migrateQNameTo14((QName)wsn);
                    continue;
                }
                if (!(im instanceof ServiceEndpointInterfaceMapping)) continue;
                ServiceEndpointInterfaceMapping seim = (ServiceEndpointInterfaceMapping)im;
                WSDLPortType wpt = seim.getWsdlPortType();
                this.migrateQNameTo14((QName)wpt);
                WSDLBinding wb = seim.getWsdlBinding();
                this.migrateQNameTo14((QName)wb);
                for (ServiceEndpointMethodMapping semm : seim.getServiceEndpointMethodMappings()) {
                    for (MethodParamPartsMapping mppm : semm.getMethodParamPartsMappings()) {
                        WSDLMessageMapping wmm = mppm.getWsdlMessageMapping();
                        WSDLMessage wm = wmm.getWsdlMessage();
                        this.migrateQNameTo14((QName)wm);
                    }
                    WSDLReturnValueMapping wrvm = semm.getWsdlReturnValueMapping();
                    if (wrvm == null) continue;
                    WSDLMessage wm = wrvm.getWsdlMessage();
                    this.migrateQNameTo14((QName)wm);
                }
            }
        }

        private void migrateQNameTo14(QName qname) {
            String namespaceURI = qname.getNamespaceURI();
            String localPart = qname.getLocalPart();
            qname.setValues(JaxrpcmapSpecificationMigrator.this.DEFAULT_NAMESPACE_PREFIX, namespaceURI, localPart);
        }

        private boolean qnameIsAnonymous(QName qname) {
            String localPart = qname.getLocalPart();
            return localPart.indexOf(62) >= 0 || localPart.indexOf(91) >= 0;
        }
    }
}

