/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.J2EEComposedMigrationOperation;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationOperation;
import com.ibm.etools.j2ee.migration.internal.JaxrpcmapMetadataMigrationOperation;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;

public class JaxrpcmapMigrationOperation
extends J2EEMigrationOperation {
    public JaxrpcmapMigrationOperation() {
    }

    public JaxrpcmapMigrationOperation(IDataModel config, IOperationHandler handler) {
        super(config, handler);
        this.migrationConfig = config;
    }

    @Override
    public IStatus doExecute(IProgressMonitor aMonitor, IAdaptable info) throws ExecutionException {
        this.migrationConfig = this.getDataModel();
        this.monitor = aMonitor;
        this.verifyFilesInSync();
        this.monitor.beginTask("", this.getTotalWeight());
        boolean autoFlag = ResourcesPlugin.getWorkspace().isAutoBuilding();
        try {
            try {
                if (autoFlag) {
                    ProjectUtilities.turnAutoBuildOff();
                }
                this.execProjectVersionIfNecessary();
            }
            catch (InvocationTargetException ite) {
                J2EEMigrationPlugin.logError(ite);
                this.migrationConfig.dispose();
                if (autoFlag) {
                    ProjectUtilities.turnAutoBuildOn();
                }
                this.monitor.done();
            }
            catch (InterruptedException ie) {
                J2EEMigrationPlugin.logError(ie);
                this.migrationConfig.dispose();
                if (autoFlag) {
                    ProjectUtilities.turnAutoBuildOn();
                }
                this.monitor.done();
            }
        }
        finally {
            this.migrationConfig.dispose();
            if (autoFlag) {
                ProjectUtilities.turnAutoBuildOn();
            }
            this.monitor.done();
        }
        return OK_STATUS;
    }

    protected void execProjectVersionIfNecessary() throws InvocationTargetException, InterruptedException, ExecutionException {
        if (!this.includesVersionMigration()) {
            return;
        }
        JaxrpcmapMetadataMigrationOperation op = null;
        op = new JaxrpcmapMetadataMigrationOperation(this.migrationConfig, this.getSelectedJ2EEVersion(), this.operationHandler);
        J2EEComposedMigrationOperation composedOp = new J2EEComposedMigrationOperation(this.migrationConfig, this.operationHandler);
        List childModels = (List)this.migrationConfig.getProperty("J2EEMigrationConfig.childerenConfigs");
        if (childModels != null && !childModels.isEmpty()) {
            if (this.containsEAR(this.migrationConfig)) {
                composedOp.addRunnable(op);
            }
            boolean addedChildOperations = false;
            int i = 0;
            while (i < childModels.size()) {
                IDataModel childConfig = (IDataModel)childModels.get(i);
                if (childConfig.getBooleanProperty("J2EEMigrationConfig.isSelected")) {
                    JaxrpcmapMetadataMigrationOperation childOp = new JaxrpcmapMetadataMigrationOperation(childConfig, this.getSelectedJ2EEVersion(), this.operationHandler);
                    composedOp.addRunnable(childOp);
                    addedChildOperations = true;
                }
                ++i;
            }
            if (addedChildOperations) {
                this.executeNestedOperation(this.monitor, composedOp, this.getProjectMetaWeight());
            }
        } else {
            this.executeNestedOperation(this.monitor, op, this.getProjectMetaWeight());
        }
    }
}

