/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.internal.J2EEProjectMetadataMigrationOperation;
import com.ibm.etools.j2ee.migration.internal.JaxrpcmapSpecificationMigrator;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.J2EEStatus;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;

public class JaxrpcmapMetadataMigrationOperation
extends J2EEProjectMetadataMigrationOperation {
    public JaxrpcmapMetadataMigrationOperation(IDataModel config, String aTargetVersion, IOperationHandler handler) {
        super(config, aTargetVersion, handler);
    }

    @Override
    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.progressMonitor = monitor;
        if (this.migrationConfigs == null && this.migrationConfigs.isEmpty() && this.targetVersion == null) {
            return OK_STATUS;
        }
        monitor.beginTask(J2EEMigrationUIResourceHandler.MIGRATING_J2EE_VERSION_UI_, this.migrationConfigs.size() * 3);
        try {
            this.migrateProjectVersions();
        }
        finally {
            monitor.done();
        }
        return OK_STATUS;
    }

    @Override
    protected void migrateProjectVersion(IDataModel config) {
        block6: {
            IProject project = (IProject)config.getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT");
            if (JemProjectUtilities.isBinaryProject((IProject)project)) {
                this.appendStatus(3, this.format(J2EEMigrationUIResourceHandler.BINARY_MIGRATION_FAILED, project.getName()));
                return;
            }
            this.tagRootAsMigrating();
            try {
                try {
                    this.progressMonitor.subTask(project.getName());
                    this.migrateDeploymentDescriptor();
                    this.progressMonitor.worked(1);
                    this.migrateFacets(this.currentConfig);
                }
                catch (Exception e) {
                    J2EEMigrationPlugin.logError(e);
                    this.appendStatus(4, e.toString());
                    this.appendStatus(4, this.format(J2EEMigrationUIResourceHandler.J2EE_VERSION_FAILED_UI_, project.getName()));
                    this.removeRootMigrationTag();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.removeRootMigrationTag();
                throw throwable;
            }
            this.removeRootMigrationTag();
        }
        this.currentConfig = null;
    }

    @Override
    protected void migrateDeploymentDescriptor() throws CoreException {
        XMLResource resource = this.getDeploymentDescriptorResource();
        if (resource == null) {
            this.appendStatus(new J2EEStatus(1, resource, this.format(J2EEMigrationUIResourceHandler.NOT_NEEDED_DEPLOYMENT_DESC_MIG, this.getProjectName())));
        }
        JaxrpcmapSpecificationMigrator migrator = new JaxrpcmapSpecificationMigrator(resource, this.targetVersion, this.currentConfig.getBooleanProperty("J2EEMigrationConfig.isComplex"));
        migrator.setComponent((IVirtualComponent)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT"));
        boolean isTargetVersion13 = migrator.getVersion().equals("1.3");
        if (!isTargetVersion13) {
            this.migrateDDTo14(migrator);
        }
    }

    private void migrateDDTo14(JaxrpcmapSpecificationMigrator migrator) throws CoreException {
        J2EEStatus status14 = migrator.migrateTo14();
        if (this.status != null) {
            this.appendStatus(status14);
        }
    }
}

