/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.Connector14SpecificationMigrator;
import com.ibm.etools.j2ee.migration.internal.SpecificationMigrator;
import com.ibm.etools.j2ee.migration.internal.War14SpecificationMigrator;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.internal.impl.CompatibilityDescriptionGroupImpl;
import org.eclipse.jst.j2ee.ejb.AcknowledgeMode;
import org.eclipse.jst.j2ee.ejb.ActivationConfig;
import org.eclipse.jst.j2ee.ejb.ActivationConfigProperty;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.DestinationType;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.MessageDrivenDestination;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.QueryMethod;
import org.eclipse.jst.j2ee.ejb.SubscriptionDurabilityKind;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.jst.j2ee.internal.J2EEMultiStatus;
import org.eclipse.jst.j2ee.internal.J2EESpecificationConstants;
import org.eclipse.jst.j2ee.internal.J2EEStatus;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.ConnectorResource;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;

public class J2EESpecificationMigrator
extends SpecificationMigrator
implements J2EEConstants,
J2EESpecificationConstants {
    private static final EClass COMPATIBILITY_DESCRIPTION_GROUP_ECLASS = CommonPackage.eINSTANCE.getCompatibilityDescriptionGroup();

    public J2EESpecificationMigrator(String aVersion, boolean complex) {
        super(aVersion, complex);
    }

    public J2EESpecificationMigrator(XMLResource anXmlResource, String aVersion, boolean complex) {
        super(anXmlResource, aVersion, complex);
    }

    protected QueryMethod convertMethodElementToQueryMethod(MethodElement me) {
        QueryMethod queryMethod = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createQueryMethod();
        queryMethod.setParms(me.getParms());
        queryMethod.setName(me.getName());
        return queryMethod;
    }

    protected void ensureBeanVersionsSet(EJBJar jar) {
        if (jar != null) {
            EList beans = jar.getEnterpriseBeans();
            int size = beans.size();
            int i = 0;
            while (i < size) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                if (bean.isContainerManagedEntity() && ((ContainerManagedEntity)bean).isVersion1_X()) {
                    ((ContainerManagedEntity)bean).setVersion("1.x");
                }
                ++i;
            }
        }
    }

    protected String format(String aPattern, String arg1) {
        return MessageFormat.format(aPattern, arg1);
    }

    protected String format(String aPattern, String arg1, String arg2) {
        return MessageFormat.format(aPattern, arg1, arg2);
    }

    protected J2EEStatus getMigrateToLowerLevelStatus(EJBJar ejbJar) {
        J2EEStatus status = null;
        if (ejbJar != null) {
            EList beans = ejbJar.getEnterpriseBeans();
            int size = beans.size();
            int i = 0;
            while (i < size) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                J2EEStatus beanStatus = this.getMigrateToLowerLevelStatus(bean);
                status = status == null ? beanStatus : status.append(beanStatus);
                ++i;
            }
        }
        return status;
    }

    protected J2EEStatus getMigrateToLowerLevelStatus(EnterpriseBean bean) {
        if (bean.isMessageDriven() && this.isVersion1_2()) {
            return new J2EEStatus(2, (EObject)bean);
        }
        if (bean.isContainerManagedEntity() && ((ContainerManagedEntity)bean).isVersion2_X() && this.isVersion1_2()) {
            return new J2EEStatus(2, (EObject)bean);
        }
        return null;
    }

    protected J2EEStatus migrate(ContainerManagedEntity aCMP) {
        boolean is1_x = aCMP.getVersion().equals("1.x");
        if (this.isVersion1_2() && !is1_x) {
            return new J2EEStatus(2, (EObject)aCMP);
        }
        if ((this.isVersion1_4() || this.isVersion1_3()) && is1_x) {
            return this.migrate1_xCMPFor2_0Target(aCMP);
        }
        return new J2EEStatus(1, (EObject)aCMP);
    }

    protected void migrateDescriptionsTo14(XMLResource resource) {
        ((EJBResource)resource).getEJBJar().getDescription();
    }

    protected J2EEStatus migrateTo13(EnterpriseBean anEJB) {
        if (anEJB != null && this.getVersion() != null) {
            if (anEJB.isContainerManagedEntity()) {
                return this.migrate((ContainerManagedEntity)anEJB);
            }
            return this.migrateBeanInterfaces(anEJB);
        }
        return new J2EEStatus(1, (EObject)anEJB);
    }

    protected J2EEStatus migrate1_xCMPFor2_0Target(ContainerManagedEntity aCMP) {
        aCMP.setVersion("2.x");
        if (!this.isComplex()) {
            aCMP.setVersion("1.x");
        } else {
            aCMP.setAbstractSchemaName(aCMP.getName());
        }
        return new J2EEStatus(0, (EObject)aCMP);
    }

    protected J2EEStatus migrateBeanInterfaces(EnterpriseBean anEJB) {
        if (this.isVersion1_2() && anEJB.getVersionID() >= 20 && anEJB.hasLocalClient()) {
            anEJB.setLocalInterface(null);
            anEJB.setLocalHomeInterface(null);
            return new J2EEStatus(3, (EObject)anEJB, this.format(REMOVED_LOCAL_CLIENT_MSG, anEJB.getName()));
        }
        return new J2EEStatus(1, (EObject)anEJB);
    }

    private J2EEMultiStatus migrateBeans13(EJBJar jar) {
        J2EEMultiStatus status = new J2EEMultiStatus();
        if (jar != null) {
            EList beans = jar.getEnterpriseBeans();
            int size = beans.size();
            int i = 0;
            while (i < size) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                status.merge(this.migrateTo13(bean));
                ++i;
            }
        }
        return status;
    }

    private J2EEMultiStatus migrateBeans14(EJBJar jar, HashMap beanMap) {
        J2EEMultiStatus status = new J2EEMultiStatus();
        if (jar != null) {
            EList beans = jar.getEnterpriseBeans();
            int size = beans.size();
            int i = 0;
            while (i < size) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                status.merge(this.migrateTo14Bean(bean, beanMap));
                ++i;
            }
        }
        return status;
    }

    private J2EEStatus migrateMessageDrivenTo14(MessageDriven anEJB) {
        String messageSelector;
        MessageDrivenDestination destination;
        ActivationConfig config = EjbFactoryImpl.getActiveFactory().createActivationConfig();
        ActivationConfigProperty property = null;
        AcknowledgeMode ackMode = anEJB.getAcknowledgeMode();
        String ackModeName = ackMode.getName();
        if (ackModeName != null && ackModeName.length() > 0) {
            property = EjbFactoryImpl.getActiveFactory().createActivationConfigProperty();
            property.setName("acknowledgeMode");
            property.setValue(ackModeName);
            config.getConfigProperties().add((Object)property);
            anEJB.setAcknowledgeMode(null);
        }
        if ((destination = anEJB.getDestination()) != null) {
            this.create14Destination(anEJB, destination, config);
        }
        if ((messageSelector = anEJB.getMessageSelector()) != null && messageSelector.length() > 0) {
            property = EjbFactoryImpl.getActiveFactory().createActivationConfigProperty();
            property.setName("messageSelector");
            property.setValue(messageSelector);
            config.getConfigProperties().add((Object)property);
            anEJB.setMessageSelector(null);
        }
        anEJB.setActivationConfig(config);
        return new J2EEStatus(0, (EObject)anEJB);
    }

    private void create14Destination(MessageDriven bean, MessageDrivenDestination destination, ActivationConfig config) {
        JavaHelpers helper;
        DestinationType type = destination.getType();
        String typeString = null;
        if (type != null) {
            switch (type.getValue()) {
                case 0: {
                    typeString = "javax.jms.Queue";
                    break;
                }
                case 1: {
                    typeString = "javax.jms.Topic";
                }
            }
        }
        if ((helper = JavaRefFactory.eINSTANCE.reflectType(typeString, bean.eContainer())) != null) {
            bean.setMessageDestination(helper.getWrapper());
        }
        ActivationConfigProperty property = EjbFactoryImpl.getActiveFactory().createActivationConfigProperty();
        property.setName("destinationType");
        property.setValue(typeString);
        config.getConfigProperties().add((Object)property);
        SubscriptionDurabilityKind durability = destination.getSubscriptionDurability();
        String durabilityName = durability.getName();
        if (durabilityName != null && durabilityName.length() > 0) {
            property = EjbFactoryImpl.getActiveFactory().createActivationConfigProperty();
            property.setName("subscriptionDurability");
            property.setValue(durabilityName);
            config.getConfigProperties().add((Object)property);
            bean.getDestination().setSubscriptionDurability(null);
        }
    }

    @Override
    protected J2EEStatus migrateTo13(ApplicationClientResource appClientResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEStatus(1, (XMLResource)appClientResource);
        }
        boolean isVersion1_3 = this.isVersion1_3();
        String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN" : "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN";
        String sysId = isVersion1_3 ? "http://java.sun.com/dtd/application-client_1_3.dtd" : "http://java.sun.com/j2ee/dtds/application-client_1_2.dtd";
        appClientResource.setDoctypeValues(pubId, sysId);
        return new J2EEStatus(0, (XMLResource)appClientResource);
    }

    @Override
    protected J2EEStatus migrateTo13(ApplicationResource appResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEStatus(1, (XMLResource)appResource);
        }
        boolean isVersion1_3 = this.isVersion1_3();
        String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN" : "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
        String sysId = isVersion1_3 ? "http://java.sun.com/dtd/application_1_3.dtd" : "http://java.sun.com/j2ee/dtds/application_1_2.dtd";
        appResource.setDoctypeValues(pubId, sysId);
        return new J2EEStatus(0, (XMLResource)appResource);
    }

    @Override
    protected J2EEStatus migrateTo13(EJBResource ejbResource) {
        J2EEStatus status = null;
        boolean b = this.basicNeedsToMigrate();
        boolean isVersion1_3 = this.isVersion1_3();
        EJBJar jar = ejbResource.getEJBJar();
        if (b) {
            if (!isVersion1_3 && (status = this.getMigrateToLowerLevelStatus(jar)) != null) {
                return status;
            }
            this.ensureBeanVersionsSet(jar);
            String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN" : "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
            String sysId = isVersion1_3 ? "http://java.sun.com/dtd/ejb-jar_2_0.dtd" : "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd";
            ejbResource.setDoctypeValues(pubId, sysId);
        } else {
            status = new J2EEStatus(1, (XMLResource)ejbResource);
        }
        boolean notNeeded = status != null;
        status = this.mergeStatuses(status, (J2EEStatus)this.migrateBeans13(jar));
        if (!notNeeded) {
            status = this.mergeStatuses(status, new J2EEStatus(0, (XMLResource)ejbResource));
        }
        return status;
    }

    @Override
    protected J2EEStatus migrateTo13(WebAppResource webResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEStatus(1, (XMLResource)webResource);
        }
        boolean isVersion1_3 = this.isVersion1_3();
        String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN" : "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
        String sysId = isVersion1_3 ? "http://java.sun.com/dtd/web-app_2_3.dtd" : "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd";
        webResource.setDoctypeValues(pubId, sysId);
        return new J2EEStatus(0, (XMLResource)webResource);
    }

    @Override
    protected J2EEStatus migrateTo14(ApplicationClientResource appClientResource) {
        if (!this.basicNeedsMigrationTo14()) {
            return new J2EEStatus(1, (XMLResource)appClientResource);
        }
        appClientResource.setModuleVersionID(14);
        this.migrateCompatibilityDescriptionGroup((XMLResource)appClientResource);
        EObject rootObject = appClientResource.getRootObject();
        appClientResource.removePreservingIds(rootObject);
        appClientResource.getContents().remove((Object)rootObject);
        appClientResource.getContents().add((Object)rootObject);
        return new J2EEStatus(0, (XMLResource)appClientResource);
    }

    @Override
    protected J2EEStatus migrateTo14(ApplicationResource appResource) {
        if (!this.basicNeedsMigrationTo14()) {
            return new J2EEStatus(1, (XMLResource)appResource);
        }
        appResource.setJ2EEVersionID(14);
        this.migrateCompatibilityDescriptionGroup((XMLResource)appResource);
        EObject rootObject = appResource.getRootObject();
        appResource.removePreservingIds(rootObject);
        appResource.getContents().add((Object)rootObject);
        return new J2EEStatus(0, (XMLResource)appResource);
    }

    @Override
    protected J2EEStatus migrateTo14(ConnectorResource connectorResource) {
        if (!this.basicNeedsMigrationTo14()) {
            return new J2EEStatus(1, (XMLResource)connectorResource);
        }
        connectorResource.setModuleVersionID(15);
        EObject rootObject = connectorResource.getRootObject();
        connectorResource.getContents().remove((Object)rootObject);
        connectorResource.getContents().add((Object)rootObject);
        Connector14SpecificationMigrator migrator = new Connector14SpecificationMigrator();
        J2EEStatus status = migrator.migrateConnectorTo14(connectorResource.getConnector());
        status = this.mergeStatuses(status, new J2EEStatus(0, (XMLResource)connectorResource));
        return status;
    }

    @Override
    protected J2EEStatus migrateTo14(EJBResource ejbResource) {
        J2EEStatus status = null;
        boolean b = this.basicNeedsMigrationTo14();
        boolean isVersion1_4 = this.isVersion1_4();
        EJBJar jar = ejbResource.getEJBJar();
        HashMap beanCache = new HashMap();
        if (jar.getVersionID() == 11) {
            this.createBeanCache(jar, beanCache);
        }
        if (b) {
            if (!isVersion1_4 && (status = this.getMigrateToLowerLevelStatus(jar)) != null) {
                return status;
            }
            ejbResource.setModuleVersionID(21);
            this.migrateCompatibilityDescriptionGroup((XMLResource)ejbResource);
            EObject rootObject = ejbResource.getRootObject();
            ejbResource.removePreservingIds(rootObject);
            ejbResource.getContents().add((Object)rootObject);
        } else {
            status = new J2EEStatus(1, (XMLResource)ejbResource);
        }
        boolean notNeeded = status != null;
        status = this.mergeStatuses(status, (J2EEStatus)this.migrateBeans14(jar, beanCache));
        if (!notNeeded) {
            status = this.mergeStatuses(status, new J2EEStatus(0, (XMLResource)ejbResource));
        }
        return status;
    }

    protected void migrateCompatibilityDescriptionGroup(XMLResource resource) {
        TreeIterator contents = resource.getAllContents();
        EObject object = null;
        while (contents.hasNext()) {
            object = (EObject)contents.next();
            this.migrateCompatibilityDescriptionGroup(object);
        }
    }

    protected void migrateCompatibilityDescriptionGroup(EObject eObj) {
        if (COMPATIBILITY_DESCRIPTION_GROUP_ECLASS.isInstance((Object)eObj)) {
            CompatibilityDescriptionGroupImpl cg = (CompatibilityDescriptionGroupImpl)eObj;
            if (cg.getDisplayNameGen() != null) {
                cg.setDisplayName(cg.getDisplayNameGen());
            }
            if (cg.getDescriptionGen() != null) {
                cg.setDescription(cg.getDescriptionGen());
            }
            if (cg.getLargeIconGen() != null) {
                cg.setLargeIcon(cg.getLargeIconGen());
            }
            if (cg.getSmallIconGen() != null) {
                cg.setSmallIcon(cg.getSmallIconGen());
            }
        }
    }

    private void createBeanCache(EJBJar jar, HashMap beanCache) {
        EList beans = jar.getEnterpriseBeans();
        int i = 0;
        while (i < beans.size()) {
            EnterpriseBean bean = (EnterpriseBean)beans.get(i);
            if (bean.isContainerManagedEntity() && ((ContainerManagedEntity)bean).isVersion1_X()) {
                beanCache.put(bean, "1.x");
            }
            ++i;
        }
    }

    @Override
    protected J2EEStatus migrateTo14(WebAppResource webResource) {
        J2EEStatus status = null;
        try {
            if (!this.basicNeedsMigrationTo14()) {
                return new J2EEStatus(1, (XMLResource)webResource);
            }
            webResource.setModuleVersionID(24);
            this.migrateCompatibilityDescriptionGroup((XMLResource)webResource);
            EObject rootObject = webResource.getRootObject();
            webResource.removePreservingIds(rootObject);
            webResource.getContents().add((Object)rootObject);
            webResource.saveIfNecessary();
            War14SpecificationMigrator migrator = new War14SpecificationMigrator();
            status = migrator.migrateWebAppTo14(webResource.getWebApp());
            status = this.mergeStatuses(status, new J2EEStatus(0, (XMLResource)webResource));
            return status;
        }
        catch (Exception e) {
            J2EEMigrationPlugin.logError(e);
            return status;
        }
    }

    private J2EEStatus migrateTo14Bean(EnterpriseBean anEJB, HashMap beanMap) {
        if (!anEJB.isMessageDriven()) {
            if (this.getVersion() != null) {
                if (anEJB.isContainerManagedEntity()) {
                    return this.migrate((ContainerManagedEntity)anEJB, beanMap);
                }
                return this.migrateBeanInterfaces(anEJB);
            }
            return new J2EEStatus(1, (EObject)anEJB);
        }
        if (anEJB.isMessageDriven()) {
            return this.migrateMessageDrivenTo14((MessageDriven)anEJB);
        }
        return new J2EEStatus(1, (EObject)anEJB);
    }

    protected J2EEStatus migrate(ContainerManagedEntity aCMP, HashMap beanMap) {
        boolean is1_x;
        String versionString = (String)beanMap.get(aCMP);
        boolean bl = is1_x = versionString != null && versionString.equals("1.x");
        if (this.isVersion1_2() && !is1_x) {
            return new J2EEStatus(2, (EObject)aCMP);
        }
        if ((this.isVersion1_4() || this.isVersion1_3()) && is1_x) {
            return this.migrate1_xCMPFor2_0Target(aCMP);
        }
        return new J2EEStatus(1, (EObject)aCMP);
    }

    @Override
    protected J2EEStatus migrateTo50(ApplicationClientResource appClientResource) {
        if (!this.basicNeedsMigrationTo50()) {
            return new J2EEStatus(1, (XMLResource)appClientResource);
        }
        J2EEStatus tempStatus = null;
        boolean needs14Mig = this.getXmlResource().getVersionID() < 14;
        boolean bl = needs14Mig = needs14Mig || this.isVersion1_3() || this.isVersion1_2();
        if (needs14Mig) {
            tempStatus = this.migrateTo14(appClientResource);
        }
        J2EEStatus status = this.mergeStatuses(tempStatus, this.run50FacetVersionDelegate((XMLResource)appClientResource));
        return status;
    }

    @Override
    protected J2EEStatus migrateTo50(ApplicationResource appResource) {
        if (!this.basicNeedsMigrationTo50()) {
            return new J2EEStatus(1, (XMLResource)appResource);
        }
        J2EEStatus tempStatus = null;
        boolean needs14Mig = this.getXmlResource().getVersionID() < 14;
        boolean bl = needs14Mig = needs14Mig || this.isVersion1_3() || this.isVersion1_2();
        if (needs14Mig) {
            tempStatus = this.migrateTo14(appResource);
        }
        J2EEStatus status = this.mergeStatuses(tempStatus, this.run50FacetVersionDelegate((XMLResource)appResource));
        return status;
    }

    @Override
    protected J2EEStatus migrateTo50(ConnectorResource connectorResource) {
        if (!this.basicNeedsMigrationTo50()) {
            return new J2EEStatus(1, (XMLResource)connectorResource);
        }
        J2EEStatus tempStatus = null;
        boolean needs14Mig = this.getXmlResource().getVersionID() < 14;
        boolean bl = needs14Mig = needs14Mig || this.isVersion1_3() || this.isVersion1_2();
        if (needs14Mig) {
            tempStatus = this.migrateTo14(connectorResource);
        }
        J2EEStatus status = this.mergeStatuses(tempStatus, this.run50FacetVersionDelegate((XMLResource)connectorResource));
        return status;
    }

    @Override
    protected J2EEStatus migrateTo50(EJBResource ejbResource) {
        if (!this.basicNeedsMigrationTo50()) {
            return new J2EEStatus(1, (XMLResource)ejbResource);
        }
        J2EEStatus tempStatus = null;
        boolean needs14Mig = this.getXmlResource().getVersionID() < 14;
        boolean bl = needs14Mig = needs14Mig || this.isVersion1_3() || this.isVersion1_2();
        if (needs14Mig) {
            tempStatus = this.migrateTo14(ejbResource);
        }
        J2EEStatus status = this.mergeStatuses(tempStatus, this.run50FacetVersionDelegate((XMLResource)ejbResource));
        return status;
    }

    @Override
    protected J2EEStatus migrateTo50(WebAppResource webResource) {
        if (!this.basicNeedsMigrationTo50()) {
            return new J2EEStatus(1, (XMLResource)webResource);
        }
        J2EEStatus tempStatus = null;
        boolean needs14Mig = this.getXmlResource().getVersionID() < 14;
        boolean bl = needs14Mig = needs14Mig || this.isVersion1_3() || this.isVersion1_2();
        if (needs14Mig) {
            tempStatus = this.migrateTo14(webResource);
        }
        J2EEStatus status = this.mergeStatuses(tempStatus, this.run50FacetVersionDelegate((XMLResource)webResource));
        return status;
    }
}

