/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.ejb.creation.CreateClientViewDataModelProvider;
import com.ibm.etools.ejb.creation.CreateClientViewOperation;
import com.ibm.etools.ejb.creation.DeleteClientViewDataModelProvider;
import com.ibm.etools.ejb.creation.DeleteClientViewOperation;
import com.ibm.etools.j2ee.commands.IRootCommand;
import com.ibm.etools.j2ee.common.operations.ProjectFacetVersionMigrator;
import com.ibm.etools.j2ee.ejb.creation.operations.ClientViewModel;
import com.ibm.etools.j2ee.ejb.extensions.BackendMigration;
import com.ibm.etools.j2ee.ejb.extensions.BackendMigrationExtensionReader;
import com.ibm.etools.j2ee.ejb.extensions.DeleteDeployCode;
import com.ibm.etools.j2ee.ejb.extensions.DeleteDeployCodeExtensionReader;
import com.ibm.etools.j2ee.ejb.operations.EjbProgressOperation;
import com.ibm.etools.j2ee.ejb.operations.IEJBProgressCommand;
import com.ibm.etools.j2ee.ejb.operations.RemoveRelationshipDataModel;
import com.ibm.etools.j2ee.ejb.operations.RemoveRelationshipDataModelOperation;
import com.ibm.etools.j2ee.migration.internal.AbstractJ2EEMigrationOperation;
import com.ibm.etools.j2ee.migration.internal.ComposedMigrationConfig;
import com.ibm.etools.j2ee.migration.internal.EJBJarMigrationCommandsHelper;
import com.ibm.etools.j2ee.migration.internal.EJBLinkMigrator;
import com.ibm.etools.j2ee.migration.internal.J2EEMergeMethodElementsOperation;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationHelper;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.internal.J2EESpecificationMigrator;
import com.ibm.etools.j2ee.migration.internal.ProjectFacetVersionMigratorExtension;
import com.ibm.etools.j2ee.migration.internal.ProjectFacetVersionMigratorExtensionReader;
import com.ibm.etools.j2ee.migration.internal.SpecificationMigrator;
import com.ibm.etools.j2ee.migration.internal.WebServicesClientSpecificationMigrator;
import com.ibm.etools.j2ee.migration.internal.WebServicesSpecificationMigrator;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import com.ibm.etools.javaee.project.facet.JavaEEVersionChangeDataModelProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaURL;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.J2EEStatus;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.jca.modulecore.util.ConnectorArtifactEdit;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditProviderOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;
import org.eclipse.wst.common.internal.emfworkbench.integration.ProjectResourceSetEditImpl;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class J2EEProjectMetadataMigrationOperation
extends AbstractJ2EEMigrationOperation {
    protected IDataModel currentConfig;
    protected IVirtualComponent earComponent;
    protected EJBLinkMigrator linkMigrator;
    protected List migrationConfigs;
    protected IProgressMonitor progressMonitor;
    protected String targetVersion;
    protected EJBJarMigrationCommandsHelper ejbMigrationHelper;
    protected IFile fFacetFile = null;
    static final String FACET_FILE_NAME = String.valueOf(File.separator) + ".settings" + File.separator + "org.eclipse.wst.common.project.facet.core.xml";
    static final String J2EE_PROJ_MIGRATION_ADAPTER = "J2EEProjectMigration";
    static final String INSTALLED_FACET = "installed";
    static final String FACET_ATT = "facet";
    static final String VERSION_ATT = "version";
    protected Document fDomDocument = null;

    public J2EEProjectMetadataMigrationOperation(IDataModel config, String aTargetVersion, IOperationHandler handler) {
        super(config, handler);
        if (config.getBooleanProperty("J2EEMigrationConfig.isComposed") && !config.getID().equals("com.ibm.etools.j2ee.migration.ui.internal.J2EEMigrationConfig")) {
            IDataModel composed = config;
            this.migrationConfigs = (List)composed.getProperty("IComposedMigrationConfigProperties.GET_ALL_VERSION_MIGRATABLE_CONFIGS");
            if (composed.getBooleanProperty("J2EEMigrationConfig.isEARComponent")) {
                this.earComponent = (IVirtualComponent)composed.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
            }
        } else {
            this.migrationConfigs = Collections.singletonList(config);
        }
        this.targetVersion = aTargetVersion;
        IVirtualComponent moduleComponent = (IVirtualComponent)config.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
        this.setCurrentComponent(moduleComponent);
        this.setEARComponent(moduleComponent);
    }

    private void setEARComponent(IVirtualComponent moduleComponent) {
        IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects((IProject)moduleComponent.getProject());
        if (earProjects != null && earProjects.length > 0) {
            this.earComponent = ComponentCore.createComponent((IProject)earProjects[0]);
        }
    }

    private ClientViewModel createDefaultClientViewModel() {
        IDataModel config = this.getEJBJarConfig();
        ClientViewModel model = new ClientViewModel();
        model.setShouldCreateLocalCommand(true);
        model.setLocalSelected(true);
        model.setLocalSuffix(config.getStringProperty("EJBJarMigrationConfig.localClientViewSuffix"));
        if (config.getBooleanProperty("EJBJarMigrationConfig.deleteRemoteClientView")) {
            model.setShouldDeleteRemote(true);
            model.setShouldDelete(true);
        }
        return model;
    }

    protected void execute11CMPCodeGenCleanup() throws InvocationTargetException, InterruptedException, ExecutionException {
        this.executeDeleteDeployCode();
        this.ejbMigrationHelper.setupCodeGenCommands(this.getEJBJarConfig());
        this.executeDeleteRelationships();
        this.execute11CMPDeleteCodeGenCommand();
    }

    private void execute11CMPDeleteCodeGenCommand() throws InvocationTargetException, InterruptedException, ExecutionException {
        this.executeCodeGenCommand(this.ejbMigrationHelper.getDeleteCommand());
    }

    private void execute20CMPCodeGenCommand() throws InvocationTargetException, InterruptedException, ExecutionException {
        IRootCommand root = this.ejbMigrationHelper.getCreateCommand();
        if (root != null) {
            root.setShouldPropagateAllChanges(false);
            this.executeCodeGenCommand(root);
            this.appendStatus(0, this.format(J2EEMigrationUIResourceHandler.COMPLETED_CMP20_CODEGEN, this.getEJBJarConfig().getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")));
        }
    }

    private void executeCodeGenCommand(IRootCommand root) throws InvocationTargetException, InterruptedException, ExecutionException {
        if (root != null) {
            EjbProgressOperation op = new EjbProgressOperation((CommandStack)((ArtifactEditModel)this.getArtifactEdit().getAdapter(ArtifactEditModel.class)).getCommandStack(), (IEJBProgressCommand)root);
            op.run(this.progressMonitor);
            J2EEStatus status = (J2EEStatus)this.getDataModel().getProperty("J2EEMigrationConfig.migrationStatus");
            status.append(new J2EEStatus(0, op.getStatus().getMessage()));
        }
    }

    private void executeDeleteDeployCode() {
        List cmps = (List)this.getEJBJarConfig().getProperty("EJBJarMigrationConfig.get11CMPs");
        this.deleteDeployCodeForCmps(cmps);
    }

    private void executeDelete20DeployCode() {
        List cmps = (List)this.getEJBJarConfig().getProperty("EJBJarMigrationConfig.get20CMPs");
        this.deleteDeployCodeForCmps(cmps);
    }

    protected void deleteDeployCodeForCmps(List cmps) {
        if (cmps.isEmpty()) {
            return;
        }
        DeleteDeployCode op = DeleteDeployCodeExtensionReader.getInstance().getDeleteDeployCodeExt();
        if (op != null) {
            op.runDeleteDeployCode((IProject)this.getEJBJarConfig().getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT"), cmps);
        }
    }

    private void executeDeleteRelationships() throws InvocationTargetException, InterruptedException {
        List rels = (List)this.getEJBJarConfig().getProperty("EJBJarMigrationConfig.get11Relationships");
        if (rels.isEmpty()) {
            return;
        }
        RemoveRelationshipDataModel model = new RemoveRelationshipDataModel();
        model.setProperty("RemoveRelationshipDataModel.COMMON_RELATIONSHIP_LIST", (Object)rels);
        model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)this.getTargetProject().getName());
        RemoveRelationshipDataModelOperation op = new RemoveRelationshipDataModelOperation(model);
        op.run(null);
    }

    private void executeLocalClientCreation(ClientViewModel model, EnterpriseBean ejb, boolean reuseRemote, boolean deleteRemote) {
        this.setupLocalClientViewModel(model, ejb, reuseRemote, deleteRemote);
        CreateClientViewOperation clientViewCreationOp = null;
        try {
            if (deleteRemote) {
                IDataModel deleteClientViewDM = DataModelFactory.createDataModel((IDataModelProvider)new DeleteClientViewDataModelProvider());
                deleteClientViewDM.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", this.getDataModel().getProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
                deleteClientViewDM.setProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", this.getDataModel().getProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME"));
                deleteClientViewDM.setProperty("IEjbModificationDataModeProperties.OPERATION_HANDLER", (Object)this.operationHandler);
                deleteClientViewDM.setProperty("IEjbUpdateCommandDataModelProperties.ENTERPRISEBEAN", (Object)ejb);
                deleteClientViewDM.setProperty("IAbstractClientViewDataModelProperties.EJB_CLIENTVIEW_MODEL", (Object)model);
                DeleteClientViewOperation deleteViewOp = new DeleteClientViewOperation(deleteClientViewDM);
                model.setShouldCreateLocalCommand(false);
                this.executeNestedOperation(this.progressMonitor, (ArtifactEditProviderOperation)deleteViewOp, 1);
            }
            IDataModel createClientViewDM = DataModelFactory.createDataModel((IDataModelProvider)new CreateClientViewDataModelProvider());
            createClientViewDM.setProperty("IEjbModificationDataModeProperties.OPERATION_HANDLER", (Object)this.operationHandler);
            createClientViewDM.setProperty("IEjbUpdateCommandDataModelProperties.ENTERPRISEBEAN", (Object)ejb);
            createClientViewDM.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", this.getDataModel().getProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
            createClientViewDM.setProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", this.getDataModel().getProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME"));
            model.setShouldCreateLocalCommand(true);
            model.setShouldCreateRemoteCommand(false);
            createClientViewDM.setProperty("IAbstractClientViewDataModelProperties.EJB_CLIENTVIEW_MODEL", (Object)model);
            clientViewCreationOp = new CreateClientViewOperation(createClientViewDM);
            this.executeNestedOperation(this.progressMonitor, (ArtifactEditProviderOperation)clientViewCreationOp, 1);
            this.appendStatus(0, this.format(J2EEMigrationUIResourceHandler.COMPLETED_LOCAL_CLIENT_CREATE, ejb.getName()));
        }
        catch (InvocationTargetException e) {
            String msg = this.format(J2EEMigrationUIResourceHandler.FAILED_LOCAL_CLIENT_CREATE, ejb.getName());
            J2EEMigrationPlugin.logWarning(msg);
            J2EEMigrationPlugin.logWarning(e.getMessage());
            this.appendStatus(3, msg);
        }
        catch (InterruptedException e) {
            J2EEMigrationPlugin.logError(e);
        }
        catch (ExecutionException ee) {
            J2EEMigrationPlugin.logError(ee);
        }
    }

    private void executeLocalClientGeneration() {
        List ejbs = (List)this.getEJBJarConfig().getDefaultProperty("EJBJarMigrationConfig.localClientViewEJBs");
        if (ejbs.isEmpty()) {
            return;
        }
        this.unloadCurrentJavaResources();
        ClientViewModel model = this.createDefaultClientViewModel();
        int size = ejbs.size();
        boolean reuseRemote = this.getEJBJarConfig().getBooleanProperty("EJBJarMigrationConfig.reuseRemoteClientViewName");
        boolean deleteRemote = this.getEJBJarConfig().getBooleanProperty("EJBJarMigrationConfig.deleteRemoteClientView");
        int i = 0;
        while (i < size) {
            EnterpriseBean ejb = (EnterpriseBean)ejbs.get(i);
            if (ejb.hasLocalClient()) {
                this.appendStatus(1, this.format(J2EEMigrationUIResourceHandler.LOCAL_CLIENT_NOT_NEEDED, ejb.getName()));
            } else {
                this.executeLocalClientCreation(model, ejb, reuseRemote, deleteRemote);
            }
            ++i;
        }
    }

    private void execMethodElementMerge() throws InvocationTargetException, InterruptedException, ExecutionException {
        J2EEMergeMethodElementsOperation op = null;
        op = new J2EEMergeMethodElementsOperation(this.currentConfig, this.operationHandler, 24);
        this.executeNestedOperation(this.progressMonitor, op, 1);
    }

    protected IDataModel getConfigForProject(IVirtualComponent component) {
        int size = this.migrationConfigs.size();
        IDataModel config = null;
        int i = 0;
        while (i < size) {
            config = this.migrationConfigs.get(i) instanceof IDataModel ? (IDataModel)this.migrationConfigs.get(i) : ((ComposedMigrationConfig)this.migrationConfigs.get(i)).getDataModel();
            if (config.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME").equals(component.getName())) {
                return config;
            }
            ++i;
        }
        return null;
    }

    protected XMLResource getDeploymentDescriptorResource() {
        IProject project = null;
        if (this.currentConfig != null) {
            project = (IProject)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT");
        }
        if (project == null) {
            return null;
        }
        if (J2EEProjectUtilities.getJ2EEProjectType(project).equals("jst.appclient")) {
            return (XMLResource)this.getAppClientDeploymentDescriptorRoot(project).eResource();
        }
        if (J2EEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.ear")) {
            return (XMLResource)this.getEARDeploymentDescriptorRoot(project).eResource();
        }
        if (J2EEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.ejb")) {
            return (XMLResource)this.getEJBDeploymentDescriptorRoot(project).eResource();
        }
        if (J2EEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.web")) {
            return (XMLResource)this.getWEBDeploymentDescriptorRoot(project).eResource();
        }
        if (J2EEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.connector")) {
            return (XMLResource)this.getRARDeploymentDescriptorRoot(project).eResource();
        }
        return null;
    }

    protected EObject getDeploymentDescriptorRoot() {
        IProject project = (IProject)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT");
        if (project == null) {
            return null;
        }
        String j2eeProjectType = J2EEProjectUtilities.getJ2EEProjectType((IProject)project);
        if (j2eeProjectType.equals("jst.appclient")) {
            return this.getAppClientDeploymentDescriptorRoot(project);
        }
        if (j2eeProjectType.equals("jst.ear")) {
            return this.getEARDeploymentDescriptorRoot(project);
        }
        if (j2eeProjectType.equals("jst.ejb")) {
            return this.getEJBDeploymentDescriptorRoot(project);
        }
        if (j2eeProjectType.equals("jst.web")) {
            return this.getWEBDeploymentDescriptorRoot(project);
        }
        if (j2eeProjectType.equals("jst.connector")) {
            return this.getRARDeploymentDescriptorRoot(project);
        }
        return null;
    }

    protected EObject getRARDeploymentDescriptorRoot(IProject project) {
        ConnectorArtifactEdit artifactEdit = null;
        artifactEdit = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IProject)project);
        return artifactEdit.getDeploymentDescriptorRoot();
    }

    protected EObject getEARDeploymentDescriptorRoot(IProject project) {
        EARArtifactEdit artifactEdit = null;
        artifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)project);
        return artifactEdit.getDeploymentDescriptorRoot();
    }

    protected EObject getWEBDeploymentDescriptorRoot(IProject project) {
        WebArtifactEdit artifactEdit = null;
        artifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
        return artifactEdit.getDeploymentDescriptorRoot();
    }

    protected EObject getEJBDeploymentDescriptorRoot(IProject project) {
        EJBArtifactEdit artifactEdit = null;
        artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)project);
        return artifactEdit.getDeploymentDescriptorRoot();
    }

    protected EObject getAppClientDeploymentDescriptorRoot(IProject project) {
        AppClientArtifactEdit artifactEdit = null;
        artifactEdit = AppClientArtifactEdit.getAppClientArtifactEditForRead((IProject)project);
        return artifactEdit.getDeploymentDescriptorRoot();
    }

    protected String getDeploymentDescriptorType() {
        return J2EEProjectUtilities.getJ2EEProjectType((IProject)((IVirtualComponent)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT")).getProject());
    }

    protected IDataModel getEJBJarConfig() {
        return this.currentConfig;
    }

    private IVirtualReference[] getMigrateableUtilJARProjects() {
        EARArtifactEdit artifactEdit = null;
        try {
            artifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IVirtualComponent)this.earComponent);
            IVirtualReference[] iVirtualReferenceArray = artifactEdit.getUtilityModuleReferences();
            return iVirtualReferenceArray;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    public String getProjectName() {
        return this.currentConfig.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
    }

    private boolean isComplexCMPMigration(IDataModel config) {
        List cmps11 = null;
        return config.getBooleanProperty("J2EEMigrationConfig.isEJBComponent") && config.getBooleanProperty("J2EEMigrationConfig.isComplex") && (cmps11 = (List)config.getProperty("EJBJarMigrationConfig.get11CMPs")) != null && cmps11.size() > 0;
    }

    protected boolean isConnector() {
        return this.getDeploymentDescriptorType() == "jst.connector";
    }

    public boolean isTargetVersion1_2() {
        return this.targetVersion.equals("1.2");
    }

    public boolean isTargetVersion1_3() {
        return this.targetVersion.equals("1.3");
    }

    public boolean isTargetVersion1_4() {
        return this.targetVersion.equals("1.4");
    }

    public boolean isTargetVersion5_0() {
        return this.targetVersion.equals("5.0");
    }

    @Override
    protected boolean shouldSaveArtifactEditOnDispose() {
        return !this.isTargetVersion5_0();
    }

    protected void migrateDeploymentDescriptor() throws CoreException {
        XMLResource resource = this.getDeploymentDescriptorResource();
        if (resource == null) {
            this.appendStatus(new J2EEStatus(1, resource, this.format(J2EEMigrationUIResourceHandler.NOT_NEEDED_DEPLOYMENT_DESC_MIG, this.getProjectName())));
        }
        J2EESpecificationMigrator migrator = new J2EESpecificationMigrator(resource, this.targetVersion, this.currentConfig.getBooleanProperty("J2EEMigrationConfig.isComplex"));
        WebServicesClientSpecificationMigrator webServicesClientMigrator = new WebServicesClientSpecificationMigrator(resource, this.targetVersion, this.currentConfig.getBooleanProperty("J2EEMigrationConfig.isComplex"));
        WebServicesSpecificationMigrator webSerivcesMigrator = new WebServicesSpecificationMigrator((IProject)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT"), this.targetVersion, this.currentConfig.getBooleanProperty("J2EEMigrationConfig.isComplex"));
        if (this.isTargetVersion1_3()) {
            this.migrateDDTo13(migrator);
        }
        if (this.isTargetVersion1_4()) {
            this.migrateDDTo14(migrator, webServicesClientMigrator, webSerivcesMigrator);
        }
        if (this.isTargetVersion5_0()) {
            this.migrateDDTo50(migrator, webServicesClientMigrator, webSerivcesMigrator);
        }
        if (this.getDeploymentDescriptorType() != "jst.ear") {
            if (this.isTargetVersion1_3() && this.isConnector()) {
                return;
            }
            if (this.earComponent != null) {
                this.linkMigrator.setCurrentConfig(this.currentConfig);
                this.linkMigrator.migrate(this.earComponent);
            }
        } else if (this.earComponent != null) {
            this.removeEARFromOldServerEnvironment(this.earComponent.getProject());
        }
    }

    protected void migrateDDTo50(J2EESpecificationMigrator migrator, SpecificationMigrator webServicesClientMigrator, WebServicesSpecificationMigrator webServicesMigrator) throws CoreException {
        J2EEStatus status50 = migrator.migrateTo50();
        if (status50 != null && status50.isOK()) {
            this.setFacetModuleVersion("1.4");
            if (this.artifactEdit != null) {
                this.artifactEdit.save(this.progressMonitor);
            }
        }
        this.appendStatus(status50);
        this.appendStatus(webServicesMigrator.migrateWebServiceResourceTo14IfExists());
        this.appendStatus(webServicesClientMigrator.migrateTo14());
    }

    protected void migrateDDTo14(J2EESpecificationMigrator migrator, SpecificationMigrator webServicesClientMigrator, WebServicesSpecificationMigrator webServicesMigrator) throws CoreException {
        J2EEStatus status14 = migrator.migrateTo14();
        if (status14 != null && status14.isOK()) {
            this.setFacetModuleVersion("1.4");
            if (this.artifactEdit != null) {
                this.artifactEdit.save(this.progressMonitor);
            }
        }
        this.appendStatus(status14);
        this.appendStatus(webServicesMigrator.migrateWebServiceResourceTo14IfExists());
        this.appendStatus(webServicesClientMigrator.migrateTo14());
    }

    private void setFacetModuleVersion(String version) {
        try {
            IProject currentProject = (IProject)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT");
            this.getFacetXMLFile(currentProject);
            this.getDOMDocument(this.fFacetFile);
            Element rootElement = this.fDomDocument.getDocumentElement();
            Element element = this.findChildNode(rootElement, INSTALLED_FACET);
            String facetAtt = element.getAttribute(FACET_ATT);
            String moduleFacetIDFound = null;
            if (Arrays.asList(J2EEMigrationHelper.allJ2EETypes).contains(facetAtt)) {
                if (!"jst.ear".equals(facetAtt)) {
                    moduleFacetIDFound = facetAtt;
                }
                element.setAttribute(VERSION_ATT, J2EEMigrationHelper.getModuleVersion(facetAtt, version));
                this.write(this.currentComponent.getProject());
            }
            if (moduleFacetIDFound != null) {
                IFacetedProject fproj = ProjectFacetsManager.create((IProject)currentProject);
                IProjectFacet facetType = ProjectFacetsManager.getProjectFacet((String)moduleFacetIDFound);
                IProjectFacetVersion fv = fproj.getInstalledVersion(facetType);
                ClasspathHelper.removeClasspathEntries((IProject)currentProject, (IProjectFacetVersion)fv);
                ClasspathHelper.addClasspathEntries((IProject)currentProject, (IProjectFacetVersion)fv);
            }
        }
        catch (CoreException ce) {
            J2EEMigrationPlugin.logError(ce);
        }
    }

    protected Element findChildNode(Element parent, String nodeName) {
        NodeList list = parent.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element curElement;
            Node curNode = list.item(i);
            if (curNode.getNodeType() == 1 && (curElement = (Element)curNode).getNodeName().equalsIgnoreCase(nodeName) && Arrays.asList(J2EEMigrationHelper.allJ2EETypes).contains(curElement.getAttribute(FACET_ATT))) {
                return curElement;
            }
            ++i;
        }
        return null;
    }

    public void write(IProject project) throws CoreException {
        if (this.fDomDocument == null) {
            return;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(this.fDomDocument.getDocumentElement()), new StreamResult(outStream));
        }
        catch (TransformerConfigurationException e) {
            J2EEMigrationPlugin.logError(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            J2EEMigrationPlugin.logError(e);
        }
        catch (TransformerException e) {
            J2EEMigrationPlugin.logError(e);
        }
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(outStream.toByteArray());
        IFile settingsFile = this.getFacetXMLFile(project);
        if (settingsFile.exists()) {
            settingsFile.setContents((InputStream)sourceStream, true, true, null);
        } else {
            settingsFile.create((InputStream)sourceStream, true, null);
        }
    }

    public IFile getFacetXMLFile(IProject fProject) {
        if (this.fFacetFile == null) {
            this.fFacetFile = fProject.getFile(FACET_FILE_NAME);
        }
        return this.fFacetFile;
    }

    protected Document getDOMDocument(IFile facetSettings) {
        if (this.fDomDocument == null) {
            try {
                this.read(facetSettings);
            }
            catch (IOException iOException) {}
        }
        return this.fDomDocument;
    }

    protected void read(IFile settings) throws IOException {
        IFile settingsFile = settings;
        InputStream inputStream = null;
        InputStreamReader fileStream = null;
        if (settingsFile != null) {
            try {
                try {
                    ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                        inputStream = settingsFile.getContents();
                        fileStream = new InputStreamReader(inputStream, "utf-8");
                        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        this.fDomDocument = parser.parse(new InputSource(fileStream));
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(prevClassLoader);
                    }
                }
                catch (SAXException sAXException) {
                    throw new IOException();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException();
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                    if (fileStream != null) {
                        fileStream.close();
                    }
                }
            }
            finally {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
        }
    }

    private void removeEARFromOldServerEnvironment(IProject project) {
        for (IModule module : Arrays.asList(ServerUtil.getModules((String)project.getName()))) {
            IServer[] servers = ServerCore.getServers();
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (!ServerUtil.isSupportedModule((IModuleType[])servers[i].getServerType().getRuntimeType().getModuleTypes(), (String)module.getModuleType().getId(), (String)module.getModuleType().getVersion())) {
                    try {
                        IServerWorkingCopy wc = servers[i].createWorkingCopy();
                        ServerUtil.modifyModules((IServerWorkingCopy)wc, null, (IModule[])new IModule[]{module}, (IProgressMonitor)new NullProgressMonitor());
                        wc.save(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        J2EEMigrationPlugin.logError(e);
                    }
                }
                ++i;
            }
        }
    }

    protected void migrateDDTo13(J2EESpecificationMigrator migrator) throws CoreException {
        J2EEStatus status13 = migrator.migrateTo13();
        if (status13.isOK()) {
            this.setFacetModuleVersion("1.3");
        }
        this.appendStatus(status13);
    }

    protected void migrateProjectClasspath() throws CoreException {
        if (this.getDeploymentDescriptorType().equals("jst.ear")) {
            this.migrateUtilityJARClassPaths();
        }
        this.appendStatus(0, this.format(J2EEMigrationUIResourceHandler.J2EE_VERSION_SUCCESS_UI_, this.getProjectName()));
    }

    protected void migrateProjectVersion(IDataModel config) {
        block26: {
            IProject project = (IProject)config.getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT");
            if (!J2EEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.ear") && JemProjectUtilities.isBinaryProject((IProject)((IProject)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT")))) {
                this.appendStatus(3, this.format(J2EEMigrationUIResourceHandler.BINARY_MIGRATION_FAILED, project.getName()));
                return;
            }
            this.tagRootAsMigrating();
            this.setRuntimeTargetIfNeeded(project);
            boolean isCMP11Migration = this.isComplexCMPMigration(config);
            if (isCMP11Migration) {
                this.ejbMigrationHelper = new EJBJarMigrationCommandsHelper();
            }
            try {
                try {
                    this.progressMonitor.subTask(project.getName());
                    BackendMigration backendMigration = null;
                    if (this.getDeploymentDescriptorType().equals("jst.ejb")) {
                        backendMigration = BackendMigrationExtensionReader.getInstance().getBackendMigrationExt();
                    }
                    if (isCMP11Migration) {
                        if (backendMigration != null) {
                            this.appendStatus(backendMigration.migrate(project, true));
                        }
                        this.execute11CMPCodeGenCleanup();
                    } else if (this.is20CMP(config)) {
                        this.executeDelete20DeployCode();
                    }
                    this.migrateProjectClasspath();
                    this.progressMonitor.worked(1);
                    this.migrateDeploymentDescriptor();
                    this.progressMonitor.worked(1);
                    if (config.getBooleanProperty("J2EEMigrationConfig.isEJBComponent")) {
                        this.execMethodElementMerge();
                        if (config.getBooleanProperty("EJBJarMigrationConfig.hasLocalClientSelected")) {
                            this.executeLocalClientGeneration();
                        }
                    }
                    if (isCMP11Migration) {
                        this.execute20CMPCodeGenCommand();
                    }
                    if (this.getDeploymentDescriptorType().equals("jst.ejb") && backendMigration != null) {
                        this.appendStatus(backendMigration.migrate(project, false));
                    }
                    this.progressMonitor.worked(1);
                    this.migrateFacets(this.currentConfig);
                }
                catch (Exception e) {
                    J2EEMigrationPlugin.logError(e);
                    this.appendStatus(4, e.toString());
                    this.appendStatus(4, this.format(J2EEMigrationUIResourceHandler.J2EE_VERSION_FAILED_UI_, project.getName()));
                    this.removeRootMigrationTag();
                    if (this.artifactEdit != null) {
                        this.artifactEdit.saveIfNecessary(this.progressMonitor);
                    }
                    if (this.ejbMigrationHelper != null && this.ejbMigrationHelper.ejbArtifactEdit != null) {
                        this.ejbMigrationHelper.ejbArtifactEdit.dispose();
                    }
                    if (this.isTargetVersion5_0()) {
                        this.artifactEdit.dispose();
                        this.artifactEdit = null;
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                this.removeRootMigrationTag();
                if (this.artifactEdit != null) {
                    this.artifactEdit.saveIfNecessary(this.progressMonitor);
                }
                if (this.ejbMigrationHelper != null && this.ejbMigrationHelper.ejbArtifactEdit != null) {
                    this.ejbMigrationHelper.ejbArtifactEdit.dispose();
                }
                if (this.isTargetVersion5_0()) {
                    this.artifactEdit.dispose();
                    this.artifactEdit = null;
                }
                throw throwable;
            }
            this.removeRootMigrationTag();
            if (this.artifactEdit != null) {
                this.artifactEdit.saveIfNecessary(this.progressMonitor);
            }
            if (this.ejbMigrationHelper != null && this.ejbMigrationHelper.ejbArtifactEdit != null) {
                this.ejbMigrationHelper.ejbArtifactEdit.dispose();
            }
            if (this.isTargetVersion5_0()) {
                this.artifactEdit.dispose();
                this.artifactEdit = null;
            }
        }
        if (this.isTargetVersion5_0()) {
            this.invoke50VersionChangeDelegate();
        }
        this.currentConfig = null;
    }

    /*
     * Unable to fully structure code
     */
    private void invoke50VersionChangeDelegate() {
        block10: {
            block9: {
                project = (IProject)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT");
                J2EEMigrationHelper.clearStatus();
                try {
                    try {
                        existingRuntime = J2EEMigrationHelper.getTargetRuntime(project);
                        hs = new HashSet<IFacetedProject.Action>();
                        fProject = ProjectFacetsManager.create((IProject)project);
                        pfv = this.getNewFacetVersion();
                        if (!JavaEEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.ear")) {
                            javaFacet = ProjectFacetsManager.getProjectFacet((String)"jst.java");
                            act = new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, javaFacet.getLatestSupportedVersion(existingRuntime), null);
                            hs.add(act);
                            fProject.modify(hs, (IProgressMonitor)new NullProgressMonitor());
                        }
                        actions = new HashSet<IFacetedProject.Action>();
                        versionChangedModel = DataModelFactory.createDataModel((IDataModelProvider)new JavaEEVersionChangeDataModelProvider());
                        versionChangedModel.setBooleanProperty("IJavaEEFacetVersionChangeDataModelProperties.CHANGE_XMLHEADER", true);
                        if (pfv != null) {
                            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, this.getNewFacetVersion(), (Object)versionChangedModel));
                            fProject.modify(actions, (IProgressMonitor)new NullProgressMonitor());
                        }
                        break block9;
                    }
                    catch (CoreException e) {
                        J2EEMigrationPlugin.logError(e);
                        newStat = new J2EEStatus(4, NLS.bind((String)J2EEMigrationUIResourceHandler.J2EEProjectMetadataMigrationOperation_0_Check_log_for_details_, (Object)e.getStatus().getMessage()));
                        this.appendStatus(newStat);
                        allStatus = J2EEMigrationHelper.getStatus();
                        ** for (stat : allStatus)
                    }
                }
                catch (Throwable var8_19) {
                    allStatus = J2EEMigrationHelper.getStatus();
                    ** for (stat : allStatus)
                }
lbl-1000:
                // 1 sources

                {
                    this.appendStatus(stat);
                    continue;
lbl31:
                    // 1 sources

                    break block10;
                }
lbl-1000:
                // 1 sources

                {
                    this.appendStatus(stat);
                    continue;
                }
lbl37:
                // 1 sources

                throw var8_19;
            }
            allStatus = J2EEMigrationHelper.getStatus();
            for (J2EEStatus stat : allStatus) {
                this.appendStatus(stat);
            }
        }
    }

    private IProjectFacetVersion getNewFacetVersion() {
        if (this.getDeploymentDescriptorType().equals("jst.ejb")) {
            IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
            return pf.getVersion("3.0");
        }
        if (this.getDeploymentDescriptorType().equals("jst.web")) {
            IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)"jst.web");
            return pf.getVersion("2.5");
        }
        if (this.getDeploymentDescriptorType().equals("jst.appclient")) {
            IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
            return pf.getVersion("5.0");
        }
        if (this.getDeploymentDescriptorType().equals("jst.connector")) {
            return null;
        }
        if (this.getDeploymentDescriptorType().equals("jst.ear")) {
            IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
            return pf.getVersion("5.0");
        }
        return null;
    }

    private boolean is20CMP(IDataModel config) {
        List cpms20 = null;
        return config.getBooleanProperty("J2EEMigrationConfig.isEJBComponent") && (cpms20 = (List)config.getProperty("EJBJarMigrationConfig.get20CMPs")) != null && cpms20.size() > 0;
    }

    protected void migrateProjectVersions() {
        if (this.currentComponent != null) {
            this.currentConfig = this.getConfigForProject(this.currentComponent);
            if (this.currentConfig != null) {
                this.migrateProjectVersion(this.currentConfig);
            }
        }
    }

    private void migrateUtilityJARClassPath(IProject p) {
        this.setRuntimeTargetIfNeeded(p);
    }

    private boolean migrateUtilityJARClassPaths() {
        IVirtualReference[] utilityJARProjects = this.getMigrateableUtilJARProjects();
        if (utilityJARProjects.length == 0) {
            return false;
        }
        int i = 0;
        while (i < utilityJARProjects.length) {
            IVirtualComponent p = utilityJARProjects[i].getReferencedComponent();
            if (!p.isBinary()) {
                this.migrateUtilityJARClassPath(p.getProject());
            }
            ++i;
        }
        return true;
    }

    protected void removeRootMigrationTag() {
        Adapter adapter;
        EObject root = this.getDeploymentDescriptorRoot();
        if (root != null && (adapter = EcoreUtil.getExistingAdapter((Notifier)root, (Object)J2EE_PROJ_MIGRATION_ADAPTER)) != null) {
            root.eAdapters().remove((Object)adapter);
        }
    }

    private void resolveMethodTypes(ClientViewModel model) {
        if (model.getHomeMethodCollection() != null) {
            this.resolveMethodTypes(model.getHomeMethodCollection());
        }
        if (model.getMethodCollection() != null) {
            this.resolveMethodTypes(model.getMethodCollection());
        }
    }

    private void resolveMethodTypes(List methods) {
        int size = methods.size();
        int i = 0;
        while (i < size) {
            Method method = (Method)methods.get(i);
            EList params = method.getParameters();
            int j = 0;
            while (j < params.size()) {
                JavaParameter param = (JavaParameter)params.get(j);
                param.getJavaType();
                ++j;
            }
            ++i;
        }
    }

    protected void setRuntimeTargetIfNeeded(IProject project) {
        try {
            IDataModel stModel = this.currentConfig.getNestedModel("J2EEMigrationConfig.NESTED_MODEL_SERVER_TARGET");
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime existingRuntime = J2EEMigrationHelper.getTargetRuntime(project);
            String newRuntimeName = stModel.getStringProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID");
            if (existingRuntime == null || !existingRuntime.getName().equals(newRuntimeName)) {
                IRuntime newRuntime = J2EEProjectMetadataMigrationOperation.getRuntimeByID(newRuntimeName);
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime newFacetedRuntime = FacetUtil.getRuntime((IRuntime)newRuntime);
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
                if (newFacetedRuntime != null) {
                    if (!this.isProjectJavaFacetCompatibleToRuntime(fProject, newFacetedRuntime)) {
                        IProjectFacet javaFacet = ProjectFacetsManager.getProjectFacet((String)"jst.java");
                        IFacetedProject.Action act = new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, javaFacet.getLatestSupportedVersion(newFacetedRuntime), null);
                        HashSet<IFacetedProject.Action> hs = new HashSet<IFacetedProject.Action>();
                        hs.add(act);
                        fProject.modify(hs, (IProgressMonitor)new NullProgressMonitor());
                    }
                    HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime> set = new HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime>();
                    set.add(newFacetedRuntime);
                    fProject.setTargetedRuntimes(set, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (CoreException ce) {
            J2EEMigrationPlugin.logError(ce);
            this.appendStatus(4, ce.toString());
            this.appendStatus(4, this.format(J2EEMigrationUIResourceHandler.SERVER_TARGET_SETTING_FAILED_UI_, project.getName()));
        }
    }

    private boolean isProjectJavaFacetCompatibleToRuntime(IFacetedProject fproject, org.eclipse.wst.common.project.facet.core.runtime.IRuntime newFacetedRuntime) {
        IProjectFacet javaFacet = ProjectFacetsManager.getProjectFacet((String)"jst.java");
        IProjectFacetVersion pversion = fproject.getInstalledVersion(javaFacet);
        if (pversion != null) {
            return newFacetedRuntime.supports(pversion.getProjectFacet());
        }
        return true;
    }

    public static IRuntime getRuntimeByID(String id) {
        IRuntime[] targets = ServerUtil.getRuntimes((String)"", (String)"");
        int i = 0;
        while (i < targets.length) {
            IRuntime target = targets[i];
            if (id.equals(target.getId())) {
                return target;
            }
            ++i;
        }
        return null;
    }

    private void setupLocalClientViewModel(ClientViewModel clientModel, EnterpriseBean ejb, boolean reuseRemote, boolean deleteRemote) {
        clientModel.resetDerivedAttributes();
        clientModel.setEjbBean(ejb);
        JavaClass remote = ejb.getRemoteInterface();
        JavaClass home = ejb.getHomeInterface();
        clientModel.setRemoteInterfaceExisting(remote);
        clientModel.setRemoteExistingName(remote.getQualifiedName());
        clientModel.setHomeInterfaceExisting(home);
        clientModel.setHomeExistingName(home.getQualifiedName());
        clientModel.setMethodCollection((List)remote.getMethods());
        clientModel.setHomeMethodCollection((List)home.getMethods());
        if (reuseRemote) {
            clientModel.setLocalExistingName(clientModel.getRemoteExistingName());
            clientModel.setLocalHomeExistingName(clientModel.getHomeExistingName());
        }
        if (deleteRemote) {
            this.resolveMethodTypes(clientModel);
        }
    }

    protected void tagRootAsMigrating() {
        EObject root = this.getDeploymentDescriptorRoot();
        if (root != null) {
            root.eAdapters().add((Object)new AdapterImpl(){

                public boolean isAdapterForType(Object type) {
                    return J2EEProjectMetadataMigrationOperation.J2EE_PROJ_MIGRATION_ADAPTER.equals(type);
                }
            });
        }
    }

    private void unloadCurrentJavaResources() {
        if (this.currentConfig.getBooleanProperty("J2EEMigrationConfig.isEARComponent")) {
            return;
        }
        ProjectResourceSetEditImpl set = (ProjectResourceSetEditImpl)((ArtifactEditModel)this.getArtifactEdit().getAdapter(ArtifactEditModel.class)).getResourceSet();
        ArrayList<Resource> remove = null;
        for (Resource res : set.getResources()) {
            if (!JavaURL.isJavaURL((String)res.getURI().toString())) continue;
            if (remove == null) {
                remove = new ArrayList<Resource>();
            }
            remove.add(res);
        }
        if (remove != null) {
            WorkbenchResourceHelperBase.removeAndUnloadAll(remove, (ResourceSet)set);
        }
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.progressMonitor = monitor;
        if (this.migrationConfigs == null && this.migrationConfigs.isEmpty() && this.targetVersion == null) {
            return OK_STATUS;
        }
        monitor.beginTask(J2EEMigrationUIResourceHandler.MIGRATING_J2EE_VERSION_UI_, this.migrationConfigs.size() * 3);
        this.linkMigrator = new EJBLinkMigrator(this.currentConfig);
        try {
            this.migrateProjectVersions();
        }
        finally {
            this.linkMigrator.release();
            monitor.done();
        }
        return OK_STATUS;
    }

    protected void migrateFacets(IDataModel config) {
        List list = ProjectFacetVersionMigratorExtensionReader.getInstance().getProjectFacetVersionMigrators();
        Iterator it = list.iterator();
        HashSet facetsSet = new HashSet();
        while (it.hasNext()) {
            ProjectFacetVersionMigratorExtension ext = (ProjectFacetVersionMigratorExtension)it.next();
            ProjectFacetVersionMigrator migrator = ext.getInstance();
            HashSet set = migrator.getFacetedProjectActionSet(config);
            facetsSet.addAll(set);
        }
        if (!facetsSet.isEmpty()) {
            IProject project = (IProject)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT");
            try {
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
                fProject.modify(facetsSet, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                J2EEMigrationPlugin.logError(e);
            }
        }
    }
}

