/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.AbstractJ2EEMigrationOperation;
import com.ibm.etools.j2ee.migration.internal.J2EEComposedMigrationOperation;
import com.ibm.etools.j2ee.migration.internal.J2EEProjectMetadataMigrationOperation;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;

public class J2EEMigrationOperation
extends AbstractJ2EEMigrationOperation {
    protected IDataModel migrationConfig;
    protected IProgressMonitor monitor;
    protected Integer projectMetaWeight = null;
    protected Integer projectStructureWeight = null;

    public J2EEMigrationOperation(IDataModel config, IOperationHandler handler) {
        super(config, handler);
        this.migrationConfig = config;
    }

    public J2EEMigrationOperation() {
    }

    protected int computeProjectStructureMigrationWeight() {
        return this.computeWeight(false);
    }

    protected int computeVersionMigrationWeight() {
        return this.computeWeight(true);
    }

    protected int computeWeight(boolean testForComplex) {
        if (this.migrationConfig != null && !this.migrationConfig.getBooleanProperty("J2EEMigrationConfig.isComposed")) {
            return this.primComputeMigrationWeight(this.migrationConfig, testForComplex);
        }
        int weight = 0;
        List configs = (List)this.migrationConfig.getProperty("IComposedMigrationConfigProperties.WITH_ALL_SELECTED_PROJECTS");
        int i = 0;
        while (i < configs.size()) {
            if (configs.get(i) instanceof IDataModel) {
                weight += this.primComputeMigrationWeight((IDataModel)configs.get(i), testForComplex);
            }
            ++i;
        }
        return weight;
    }

    protected boolean containsEAR(IDataModel config) {
        IVirtualComponent component = (IVirtualComponent)config.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
        if (component != null) {
            return J2EEProjectUtilities.getJ2EEProjectType((IProject)component.getProject()).equals("jst.ear");
        }
        return false;
    }

    private J2EEProjectMetadataMigrationOperation createModuleMetadataMigrationOp(IDataModel childConfig) {
        String targetVersion = this.getSelectedJ2EEVersion();
        J2EEProjectMetadataMigrationOperation moduleOperation = new J2EEProjectMetadataMigrationOperation(childConfig, targetVersion, this.operationHandler);
        moduleOperation.setCurrentComponent((IVirtualComponent)childConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT"));
        return moduleOperation;
    }

    private void execProjectVersionIfNecessary() throws InvocationTargetException, InterruptedException, ExecutionException {
        if (!this.includesVersionMigration()) {
            return;
        }
        J2EEProjectMetadataMigrationOperation op = new J2EEProjectMetadataMigrationOperation(this.migrationConfig, this.getSelectedJ2EEVersion(), this.operationHandler);
        J2EEComposedMigrationOperation composedOp = new J2EEComposedMigrationOperation(this.migrationConfig, this.operationHandler);
        List childModels = (List)this.migrationConfig.getProperty("J2EEMigrationConfig.childerenConfigs");
        if (childModels != null && !childModels.isEmpty()) {
            if (this.containsEAR(this.migrationConfig)) {
                composedOp.addRunnable(op);
            }
            int i = 0;
            while (i < childModels.size()) {
                IDataModel childConfig = (IDataModel)childModels.get(i);
                if (childConfig.getBooleanProperty("J2EEMigrationConfig.isSelected")) {
                    composedOp.addRunnable(this.createModuleMetadataMigrationOp(childConfig));
                }
                ++i;
            }
            if (composedOp.nestedOperations != null && !composedOp.nestedOperations.isEmpty()) {
                this.executeNestedOperation(this.monitor, composedOp, this.getProjectMetaWeight());
            }
        } else {
            this.executeNestedOperation(this.monitor, op, this.getProjectMetaWeight());
        }
    }

    public int getProjectMetaWeight() {
        if (this.projectMetaWeight == null) {
            this.projectMetaWeight = new Integer(this.computeVersionMigrationWeight());
        }
        return this.projectMetaWeight;
    }

    public int getProjectStructureWeight() {
        if (this.projectStructureWeight == null) {
            this.projectStructureWeight = new Integer(this.computeProjectStructureMigrationWeight());
        }
        return this.projectStructureWeight;
    }

    public String getSelectedJ2EEVersion() {
        return this.migrationConfig.getStringProperty("J2EEMigrationConfig.J2EE_MIGRATION_VERSION");
    }

    protected List getSelectedProjects() {
        if (this.migrationConfig != null) {
            return (List)this.migrationConfig.getProperty("IComposedMigrationConfigProperties.GET_ALL_SELECTED_PROJECTS");
        }
        return Collections.EMPTY_LIST;
    }

    protected int getTotalWeight() {
        int weight = this.getProjectMetaWeight();
        if (this.includesVersionMigration()) {
            weight += this.getProjectMetaWeight();
        }
        return weight;
    }

    protected boolean includesVersionMigration() {
        if (this.migrationConfig != null) {
            return this.migrationConfig.getBooleanProperty("J2EEMigrationConfig.isVersionMigratable");
        }
        return false;
    }

    protected int primComputeMigrationWeight(IDataModel config, boolean testForComplex) {
        if (config == null || !config.getBooleanProperty("J2EEMigrationConfig.isSelected")) {
            return 0;
        }
        return testForComplex && config.getBooleanProperty("J2EEMigrationConfig.isComplex") ? 3 : 1;
    }

    public void verifyFilesInSync() {
        List projects = this.getSelectedProjects();
        int i = 0;
        while (i < projects.size()) {
            IProject proj = (IProject)projects.get(i);
            if (!proj.isSynchronized(2)) {
                try {
                    proj.refreshLocal(2, null);
                }
                catch (CoreException ce) {
                    J2EEMigrationPlugin.logError(ce);
                }
            }
            ++i;
        }
    }

    public IStatus doExecute(IProgressMonitor aMonitor, IAdaptable info) throws ExecutionException {
        this.monitor = aMonitor;
        this.verifyFilesInSync();
        this.monitor.beginTask("", this.getTotalWeight());
        boolean autoFlag = ResourcesPlugin.getWorkspace().isAutoBuilding();
        try {
            try {
                if (autoFlag) {
                    ProjectUtilities.turnAutoBuildOff();
                }
                this.execProjectVersionIfNecessary();
            }
            catch (InvocationTargetException ite) {
                J2EEMigrationPlugin.logError(ite);
                this.migrationConfig.dispose();
                if (autoFlag) {
                    ProjectUtilities.turnAutoBuildOn();
                }
                this.monitor.done();
            }
            catch (InterruptedException ie) {
                J2EEMigrationPlugin.logError(ie);
                this.migrationConfig.dispose();
                if (autoFlag) {
                    ProjectUtilities.turnAutoBuildOn();
                }
                this.monitor.done();
            }
        }
        finally {
            this.migrationConfig.dispose();
            if (autoFlag) {
                ProjectUtilities.turnAutoBuildOn();
            }
            this.monitor.done();
        }
        return OK_STATUS;
    }
}

