/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.J2EEStatus;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class J2EEMigrationHelper {
    public static final String IMPORTED_JAR_SUFFIX = ".imported_classes.jar";
    public static final String[] allJ2EETypes = new String[]{"jst.appclient", "jst.ear", "jst.ejb", "jst.web", "jst.connector"};
    private static List facetStatus = Collections.synchronizedList(new ArrayList());

    public static IRuntime getTargetRuntime(IProject project) throws CoreException {
        IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
        if (fProject != null) {
            return fProject.getRuntime();
        }
        return null;
    }

    protected static boolean isEJB1_X(EnterpriseBean bean) {
        return bean.isVersion1_X();
    }

    public static boolean isJ2EEComponent(IProject project) {
        String projectType = J2EEProjectUtilities.getJ2EEProjectType((IProject)project);
        return projectType.equals("jst.ear") || projectType.equals("jst.web") || projectType.equals("jst.appclient") || projectType.equals("jst.ejb") || projectType.equals("jst.connector");
    }

    public static String getDeploymentDescriptorType(IDataModel config) {
        return config.getStringProperty("J2EEMigrationConfig.deploymentDesType");
    }

    public static boolean isEJB2_X(EnterpriseBean bean) {
        return bean.isVersion2_X();
    }

    public static String getModuleVersion(String ddType, String version) {
        if (ddType.equals("jst.ejb")) {
            return J2EEMigrationHelper.getEJBModuleVersion(version);
        }
        if (ddType.equals("jst.web")) {
            return J2EEMigrationHelper.getWebModuleVersion(version);
        }
        if (ddType.equals("jst.connector")) {
            return J2EEMigrationHelper.getConnectorModuleVersion(version);
        }
        return version;
    }

    public static String getConnectorModuleVersion(String version) {
        if (version.equals("1.3")) {
            return "1.0";
        }
        if (version.equals("1.4")) {
            return "1.5";
        }
        if (version.equals("5.0")) {
            return "1.5";
        }
        return version;
    }

    public static String getWebModuleVersion(String version) {
        if (version.equals("1.3")) {
            return "2.3";
        }
        if (version.equals("1.4")) {
            return "2.4";
        }
        if (version.equals("5.0")) {
            return "2.5";
        }
        if (version.equals("5.0")) {
            return "2.5";
        }
        return version;
    }

    public static void reportException(CoreException ex) {
        J2EEMigrationPlugin.logError(ex);
        J2EEStatus newStat = new J2EEStatus(4, NLS.bind((String)J2EEMigrationUIResourceHandler.J2EEProjectMetadataMigrationOperation_0_Check_log_for_details_, (Object)ex.getStatus().getMessage()));
        facetStatus.add(newStat);
    }

    public static void clearStatus() {
        facetStatus.clear();
    }

    protected static List getStatus() {
        return facetStatus;
    }

    public static String getEJBModuleVersion(String version) {
        if (version.equals("1.3")) {
            return "2.0";
        }
        if (version.equals("5.0")) {
            return "3.0";
        }
        if (version.equals("1.4")) {
            return "2.1";
        }
        if (version.equals("5.0")) {
            return "3.0";
        }
        return version;
    }
}

