/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.EJBJarMigrationConfig;
import com.ibm.etools.j2ee.migration.internal.IJ2EEMigrationConfigProperties;
import com.ibm.etools.j2ee.migration.internal.J2EEExtendedProjectServerTargetDataModelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.internal.J2EEVersionConstants;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperationDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class J2EEMigrationConfig
extends ArtifactEditOperationDataModelProvider
implements IAdaptable,
J2EEVersionConstants,
IJ2EEMigrationConfigProperties,
IDataModelListener {
    public static final int APP_CLIENT_TYPE = 1;
    public static final int APPLICATION_TYPE = 2;
    public static final int EJB_TYPE = 3;
    public static final int WEB_APP_TYPE = 4;
    public static final int RAR_TYPE = 5;
    public static final int WEB_SERVICES_CLIENT_TYPE = 6;
    public static final String J2EE_CONFIG = "J2EEMigrationConfig";
    public IDataModel serverTargetDataModel;

    public static IDataModel createConfig(IVirtualComponent component) {
        if (component == null || component.isBinary()) {
            return null;
        }
        String compTypeId = J2EEProjectUtilities.getJ2EEProjectType((IProject)component.getProject());
        IDataModel moduleDataModel = null;
        if (compTypeId.equals("jst.ejb")) {
            moduleDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EJBJarMigrationConfig(component));
            J2EEMigrationConfig.initializeDataModel(component, compTypeId, moduleDataModel);
            moduleDataModel.setProperty("EJBJarMigrationConfig.initClientViewChildren", (Object)moduleDataModel);
        } else {
            moduleDataModel = DataModelFactory.createDataModel((IDataModelProvider)new J2EEMigrationConfig());
            J2EEMigrationConfig.initializeDataModel(component, compTypeId, moduleDataModel);
        }
        return moduleDataModel;
    }

    protected static void initializeDataModel(IVirtualComponent component, String compTypeId, IDataModel moduleDataModel) {
        moduleDataModel.setProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", (Object)component.getName());
        moduleDataModel.setProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT", (Object)component);
        moduleDataModel.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)component.getProject().getName());
        moduleDataModel.setProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT", (Object)component.getProject());
        moduleDataModel.setProperty("IArtifactEditOperationDataModelProperties.TYPE_ID", (Object)compTypeId);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT") && propertyValue != null) {
            IVirtualComponent comp = (IVirtualComponent)propertyValue;
            this.getDataModel().setProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT", (Object)comp);
            this.getDataModel().setProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", (Object)comp.getName());
            this.getDataModel().setProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT", (Object)comp.getProject());
            this.getDataModel().setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)comp.getProject().getName());
            this.getDataModel().setProperty("J2EEMigrationConfig.deploymentDesType", (Object)JavaEEProjectUtilities.getJ2EEProjectType((IProject)comp.getProject()));
        }
        if (propertyName.equals("J2EEMigrationConfig.isSelected")) {
            this.setProperty("J2EEMigrationConfig.isSelected", propertyValue);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private void addNestedServerTargetDataModel(IDataModel moduleModel) {
        this.serverTargetDataModel = DataModelFactory.createDataModel((IDataModelProvider)new J2EEExtendedProjectServerTargetDataModelProvider());
        moduleModel.addNestedModel("J2EEMigrationConfig.NESTED_MODEL_SERVER_TARGET", this.serverTargetDataModel);
        this.serverTargetDataModel.addListener((IDataModelListener)this);
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("J2EEMigrationConfig.J2EE_MIGRATION_VERSION")) {
            return this.getValidJ2EEVersionLabels();
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public List createConfigs(List components) {
        ArrayList<IDataModel> result = new ArrayList<IDataModel>();
        for (IVirtualComponent component : components) {
            IDataModel config;
            if (component == null || J2EEProjectUtilities.getJ2EEProjectType((IProject)component.getProject()).equals("jst.utility") || (config = J2EEMigrationConfig.createConfig(component)) == null) continue;
            result.add(config);
        }
        return result;
    }

    public void init() {
        super.init();
        this.addNestedServerTargetDataModel(this.getDataModel());
        this.getDataModel().getNestedModel("J2EEMigrationConfig.NESTED_MODEL_SERVER_TARGET").setProperty("IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID", (Object)this.getDataModel().getStringProperty("IArtifactEditOperationDataModelProperties.TYPE_ID"));
    }

    public static boolean isAnyVersionMigrateable(List configs) {
        int i = 0;
        while (i < configs.size()) {
            IDataModel child = (IDataModel)configs.get(i);
            if (child.getBooleanProperty("J2EEMigrationConfig.isVersionMigratable")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public J2EEMigrationConfig(IVirtualComponent component, String aDeploymentDesType) {
    }

    public J2EEMigrationConfig() {
    }

    public static List getProjects(List j2eeMigrationConfigs) {
        ArrayList result = new ArrayList(j2eeMigrationConfigs.size());
        int i = 0;
        while (i < j2eeMigrationConfigs.size()) {
            result.add(j2eeMigrationConfigs.get(i));
            ++i;
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (this.getTargetProject() == null) {
            return null;
        }
        return Platform.getAdapterManager().getAdapter((Object)this.getTargetProject(), adapter);
    }

    public String getID() {
        return J2EE_CONFIG;
    }

    private Object getDefaultJ2EEVersion() {
        return "5.0";
    }

    public IDataModelOperation getDefaultOperation() {
        return super.getDefaultOperation();
    }

    public IDataModel getServerTargetDataModel() {
        return this.serverTargetDataModel;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("J2EEMigrationConfig.J2EE_MIGRATION_VERSION")) {
            return this.getDefaultJ2EEVersion();
        }
        if (propertyName.equals("J2EEMigrationConfig.isSelected")) {
            return this.getDefaultIsSelectedProperty();
        }
        if (propertyName.equals("J2EEMigrationConfig.isComposed")) {
            return this.isComposed();
        }
        if (propertyName.equals("J2EEMigrationConfig.isComplex")) {
            return this.isComplex();
        }
        if (propertyName.equals("J2EEMigrationConfig.isVersionMigratable")) {
            return new Boolean(true);
        }
        if (propertyName.equals("J2EEMigrationConfig.isEJBComponent")) {
            return new Boolean(this.isEJB());
        }
        if (propertyName.equals("J2EEMigrationConfig.isEARComponent")) {
            return new Boolean(this.isEAR());
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object getDefaultIsSelectedProperty() {
        return new Boolean(true);
    }

    public String getDeploymentDesType() {
        return this.getStringProperty("J2EEMigrationConfig.deploymentDesType");
    }

    protected DataModelPropertyDescriptor[] getValidJ2EEVersionLabels() {
        IProject project = (IProject)this.getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT");
        if (project != null) {
            String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project);
            if (version.equals("1.2") || version.equals("2.2") || version.equals("1.1") || version.equals("1.0")) {
                return this.getDescriptorsForStrings(new String[]{"1.3", "1.4", "5.0"});
            }
            if (version.equals("1.3") || version.equals("2.3") || version.equals("2.0")) {
                return this.getDescriptorsForStrings(new String[]{"1.4", "5.0"});
            }
            if (version.equals("1.4") || version.equals("2.4") || version.equals("2.1")) {
                return this.getDescriptorsForStrings(new String[]{"5.0"});
            }
            return new DataModelPropertyDescriptor[0];
        }
        return this.getDescriptorsForStrings(new String[]{"1.3", "1.4", "5.0"});
    }

    protected DataModelPropertyDescriptor[] getDescriptorsForStrings(String[] strings) {
        DataModelPropertyDescriptor[] versionDesc = new DataModelPropertyDescriptor[strings.length];
        int i = 0;
        while (i < strings.length) {
            versionDesc[i] = new DataModelPropertyDescriptor((Object)strings[i]);
            ++i;
        }
        return versionDesc;
    }

    public Set getPropertyNames() {
        Set superPropertyNames = super.getPropertyNames();
        superPropertyNames.addAll(Arrays.asList("J2EEMigrationConfig.deploymentDesType", "J2EEMigrationConfig.isSelected", "J2EEMigrationConfig.J2EE_MIGRATION_VERSION", "J2EEMigrationConfig.migrationStatus", "J2EEMigrationConfig.isEARComponent", "J2EEMigrationConfig.isEJBComponent", "J2EEMigrationConfig.shouldMigrateVersion", "J2EEMigrationConfig.isComplex", "J2EEMigrationConfig.isComposed", "J2EEMigrationConfig.isVersionMigratable", "J2EEMigrationConfig.childerenConfigs"));
        return superPropertyNames;
    }

    public boolean isAppClient() {
        return this.getStringProperty("J2EEMigrationConfig.deploymentDesType").equals("jst.appclient");
    }

    public Boolean isComplex() {
        return new Boolean(false);
    }

    public Boolean isComposed() {
        return new Boolean(this.isPrimComposed() || this.isEAR());
    }

    public boolean isEAR() {
        return this.getStringProperty("J2EEMigrationConfig.deploymentDesType").equals("jst.ear");
    }

    public boolean isEJB() {
        return this.getStringProperty("J2EEMigrationConfig.deploymentDesType").equals("jst.ejb");
    }

    public boolean isPrimComposed() {
        return this.getStringProperty("J2EEMigrationConfig.deploymentDesType") == "";
    }

    public boolean isSelected() {
        return this.getBooleanProperty("J2EEMigrationConfig.isSelected");
    }

    public boolean isWeb() {
        return this.getStringProperty("J2EEMigrationConfig.deploymentDesType").equals("jst.web");
    }

    public void setIsSelected(boolean isSelected) {
        this.setBooleanProperty("J2EEMigrationConfig.isSelected", isSelected);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(project: " + this.getTargetProject().getName() + ")";
    }

    public void propertyChanged(DataModelEvent event) {
    }
}

