/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.AbstractJ2EEMigrationOperation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.TransactionAttributeType;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;

public class J2EEMergeMethodElementsOperation
extends AbstractJ2EEMigrationOperation {
    protected IDataModel config = null;
    protected int flag = -1;
    public static final int METHOD_PERMISSION = 8;
    public static final int METHOD_TRANSACTION = 16;
    public static final int ALL = 24;
    protected EJBArtifactEdit ejbArtifactEdit = null;

    public J2EEMergeMethodElementsOperation(IDataModel config, IOperationHandler handler, int flag) {
        super(config, handler);
        this.config = config;
        this.flag = flag;
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        block8: {
            try {
                IVirtualComponent component = (IVirtualComponent)this.config.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
                if (component == null || !J2EEProjectUtilities.getJ2EEProjectType((IProject)component.getProject()).equals("jst.ejb")) break block8;
                try {
                    this.ejbArtifactEdit = EJBArtifactEdit.getEJBArtifactEditForWrite((IVirtualComponent)component);
                    EJBJar jar = this.ejbArtifactEdit.getEJBJar();
                    this.migrate(jar);
                    this.ejbArtifactEdit.saveIfNecessary(monitor);
                }
                finally {
                    if (this.ejbArtifactEdit != null) {
                        this.ejbArtifactEdit.dispose();
                    }
                    if (this.config != null) {
                        this.config.dispose();
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
        return OK_STATUS;
    }

    protected void migrate(EJBJar jar) {
        if ((this.flag & 0x10) > 0) {
            this.migrateMethodTransaction(jar);
        }
        if ((this.flag & 8) > 0) {
            this.migrateMethodPermission(jar);
        }
    }

    private void migrateMethodPermission(EJBJar jar) {
        EList methodPermissions = null;
        ArrayList<MethodPermission> filtered = new ArrayList<MethodPermission>();
        if (jar.getAssemblyDescriptor() != null) {
            methodPermissions = jar.getAssemblyDescriptor().getMethodPermissions();
        }
        if (methodPermissions != null && !methodPermissions.isEmpty()) {
            int i = 0;
            while (i < methodPermissions.size()) {
                MethodPermission mp = (MethodPermission)methodPermissions.get(i);
                EList roles = mp.getRoles();
                filtered.clear();
                int j = 0;
                while (j < methodPermissions.size()) {
                    boolean found = false;
                    MethodPermission perm = (MethodPermission)methodPermissions.get(j);
                    if (perm != mp && (found = this.checkSecurityRoles((List)roles, (List)perm.getRoles()))) {
                        filtered.add(perm);
                    }
                    ++j;
                }
                this.processFiltered((List)mp.getMethodElements(), EjbPackage.eINSTANCE.getMethodPermission_MethodElements(), filtered);
                methodPermissions.removeAll(filtered);
                ++i;
            }
        }
    }

    private boolean checkSecurityRoles(List roles, List otherRoles) {
        if (roles.size() == otherRoles.size()) {
            int i = 0;
            while (i < roles.size()) {
                if (!otherRoles.contains(roles.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void migrateMethodTransaction(EJBJar jar) {
        List tranType = TransactionAttributeType.VALUES;
        ArrayList<MethodTransaction> filtered = new ArrayList<MethodTransaction>();
        EList methodTransactions = null;
        if (jar.getAssemblyDescriptor() != null) {
            methodTransactions = jar.getAssemblyDescriptor().getMethodTransactions();
        }
        if (methodTransactions != null && !methodTransactions.isEmpty()) {
            int j = 0;
            while (j < tranType.size()) {
                filtered.clear();
                int k = 0;
                while (k < methodTransactions.size()) {
                    MethodTransaction mt = (MethodTransaction)methodTransactions.get(k);
                    if (mt.getTransactionAttribute().equals(tranType.get(j))) {
                        filtered.add(mt);
                    }
                    ++k;
                }
                if (filtered.size() > 1) {
                    MethodTransaction newMT = EjbFactory.eINSTANCE.createMethodTransaction();
                    newMT.setTransactionAttribute((TransactionAttributeType)tranType.get(j));
                    this.processFiltered((EObject)newMT, EjbPackage.eINSTANCE.getMethodTransaction_MethodElements(), filtered);
                    methodTransactions.removeAll(filtered);
                    methodTransactions.add(newMT);
                }
                ++j;
            }
        }
    }

    protected void processFiltered(EObject owner, EReference feature, List filtered) {
        ArrayList grouped = new ArrayList();
        int i = 0;
        while (i < filtered.size()) {
            EObject oldObject = (EObject)filtered.get(i);
            Object o = oldObject.eGet((EStructuralFeature)feature);
            if (o instanceof List) {
                List data = (List)o;
                grouped.addAll(data);
            }
            ++i;
        }
        owner.eSet((EStructuralFeature)feature, grouped);
    }

    protected void processFiltered(List list, EReference feature, List filtered) {
        ArrayList grouped = new ArrayList();
        int i = 0;
        while (i < filtered.size()) {
            EObject oldObject = (EObject)filtered.get(i);
            Object o = oldObject.eGet((EStructuralFeature)feature);
            if (o instanceof List) {
                List data = (List)o;
                grouped.addAll(data);
            }
            ++i;
        }
        list.addAll(grouped);
    }
}

