/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationHelper;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.internal.servertarget.J2EEProjectServerTargetDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;

public class J2EEExtendedProjectServerTargetDataModelProvider
extends J2EEProjectServerTargetDataModelProvider {
    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID")) {
            return this.getVersionsSpecificValidServerTargetDescriptors();
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    private DataModelPropertyDescriptor[] getVersionsSpecificValidServerTargetDescriptors() {
        String j2eeType = this.getDataModel().getStringProperty("IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID");
        String j2eeVersion = J2EEMigrationHelper.getModuleVersion(j2eeType, this.getDataModel().getStringProperty("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID"));
        if (j2eeType != null || j2eeVersion != null) {
            org.eclipse.wst.server.core.IRuntime[] runtimes = ServerUtil.getRuntimes((String)j2eeType, (String)j2eeVersion);
            List runtimesList = this.getValidRuntimesList(runtimes);
            DataModelPropertyDescriptor[] descriptors = null;
            if (!runtimesList.isEmpty()) {
                int serverTargetListSize = runtimesList.size();
                descriptors = new DataModelPropertyDescriptor[serverTargetListSize];
                int i = 0;
                while (i < runtimesList.size()) {
                    org.eclipse.wst.server.core.IRuntime runtime = (org.eclipse.wst.server.core.IRuntime)runtimesList.get(i);
                    descriptors[i] = new DataModelPropertyDescriptor((Object)runtime.getId(), runtime.getName());
                    ++i;
                }
            } else {
                descriptors = new DataModelPropertyDescriptor[]{};
            }
            return descriptors;
        }
        return null;
    }

    public List getVersionsSpecificValidServerTargets() {
        List runtimesList = null;
        String j2eeType = this.getDataModel().getStringProperty("IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID");
        String j2eeVersion = J2EEMigrationHelper.getModuleVersion(j2eeType, this.getDataModel().getStringProperty("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID"));
        if (j2eeType != null || j2eeVersion != null) {
            org.eclipse.wst.server.core.IRuntime[] runtimes = ServerUtil.getRuntimes((String)j2eeType, (String)j2eeVersion);
            runtimesList = this.getValidRuntimesList(runtimes);
        }
        return runtimesList;
    }

    private List getValidRuntimesList(org.eclipse.wst.server.core.IRuntime[] targetedRuntimes) {
        IProject project = this.getProject();
        if (project != null) {
            try {
                ArrayList<org.eclipse.wst.server.core.IRuntime> validServerTargets = new ArrayList<org.eclipse.wst.server.core.IRuntime>();
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                IRuntime primaryFacetedRuntime = facetedProject.getPrimaryRuntime();
                org.eclipse.wst.server.core.IRuntime primaryServerRuntime = null;
                if (primaryFacetedRuntime != null) {
                    primaryServerRuntime = FacetUtil.getRuntime((IRuntime)primaryFacetedRuntime);
                }
                int i = 0;
                while (i < targetedRuntimes.length) {
                    IRuntime target = FacetUtil.getRuntime((org.eclipse.wst.server.core.IRuntime)targetedRuntimes[i]);
                    if (target != null && facetedProject.isTargetable(target)) {
                        if (primaryServerRuntime != null && !targetedRuntimes[i].equals(primaryServerRuntime)) {
                            validServerTargets.add(targetedRuntimes[i]);
                        } else if (primaryServerRuntime != null && targetedRuntimes[i].equals(primaryServerRuntime)) {
                            validServerTargets.add(0, targetedRuntimes[i]);
                        } else if (primaryServerRuntime == null) {
                            validServerTargets.add(targetedRuntimes[i]);
                        }
                    }
                    ++i;
                }
                return validServerTargets;
            }
            catch (CoreException ex) {
                J2EEMigrationPlugin.logError(ex);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID")) {
            this.setProperty("IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID", propertyValue);
        } else if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID")) {
            this.setProperty("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID", propertyValue);
            IRuntime runtime = null;
            org.eclipse.wst.server.core.IRuntime serverRuntime = null;
            try {
                runtime = J2EEMigrationHelper.getTargetRuntime(this.getProject());
                if (runtime != null) {
                    serverRuntime = FacetUtil.getRuntime((IRuntime)runtime);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (serverRuntime != null) {
                this.propertySet("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", serverRuntime.getId());
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private String getDefaultVersionID() {
        return "5.0";
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID")) {
            return this.getDefaultVersionID();
        }
        if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID")) {
            return this.getDefaultVersionID();
        }
        return super.getDefaultProperty(propertyName);
    }
}

