/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationHelper;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EJBLinkMigrator {
    protected IVirtualComponent referencedEARComponent;
    protected Map earNamesToEARFiles = new HashMap();
    protected static final char QUALIFIER_CHAR = '#';
    private IDataModel currentConfig;

    public EJBLinkMigrator() {
    }

    public EJBLinkMigrator(IDataModel config) {
        this.currentConfig = config;
    }

    public void migrate(IVirtualComponent earComponent) {
        if (this.isConnector()) {
            return;
        }
        this.initEAR(earComponent);
        this.migrate();
    }

    protected boolean isConnector() {
        return J2EEMigrationHelper.getDeploymentDescriptorType(this.currentConfig).equals("jst.connector");
    }

    protected void migrate() {
        EARFile ear = this.getCurrentEARFile();
        if (ear == null) {
            return;
        }
        IVirtualReference ref = this.referencedEARComponent.getReference(this.currentConfig.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME"));
        if (ref == null) {
            return;
        }
        String uri = ref.getReferencedComponent().getName();
        this.migrate(uri, ear);
    }

    protected void migrate(String uri, EARFile ear) {
        String j2eeModuleType = J2EEMigrationHelper.getDeploymentDescriptorType(this.currentConfig);
        if (j2eeModuleType.equals("jst.ejb")) {
            this.migrateEJBModule(uri, ear);
        } else if (j2eeModuleType.equals("jst.web")) {
            this.migrateWebModule(uri, ear);
        } else if (j2eeModuleType.equals("jst.appclient")) {
            this.migrateAppClientModule(uri, ear);
        }
    }

    protected void migrateAppClientModule(String uri, EARFile ear) {
        IVirtualComponent component = (IVirtualComponent)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
        AppClientArtifactEdit artifactEdit = null;
        try {
            artifactEdit = AppClientArtifactEdit.getAppClientArtifactEditForWrite((IVirtualComponent)component);
            ApplicationClient client = artifactEdit.getApplicationClient();
            if (client == null) {
                return;
            }
            this.migrateRefs(uri, (List)client.getEjbReferences(), ear);
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.saveIfNecessary(null);
                artifactEdit.dispose();
            }
        }
    }

    protected void migrateWebModule(String uri, EARFile ear) {
        IVirtualComponent component = (IVirtualComponent)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
        WebArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)component);
            WebApp webapp = artifactEdit.getWebApp();
            if (webapp == null) {
                return;
            }
            this.migrateRefs(uri, (List)webapp.getEjbRefs(), ear);
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.saveIfNecessary(null);
                artifactEdit.dispose();
            }
        }
    }

    protected void migrateEJBModule(String uri, EARFile ear) {
        IVirtualComponent component = (IVirtualComponent)this.currentConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
        EJBArtifactEdit artifactEdit = null;
        try {
            artifactEdit = EJBArtifactEdit.getEJBArtifactEditForWrite((IVirtualComponent)component);
            EJBJar ejbJar = artifactEdit.getEJBJar();
            if (ejbJar == null) {
                return;
            }
            EList beans = ejbJar.getEnterpriseBeans();
            int i = 0;
            while (i < beans.size()) {
                EnterpriseBean owner = (EnterpriseBean)beans.get(i);
                this.migrateRefs(uri, (List)owner.getEjbRefs(), ear);
                ++i;
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.saveIfNecessary(null);
                artifactEdit.dispose();
            }
        }
    }

    protected void migrateRefs(String uri, List refs, EARFile ear) {
        int i = 0;
        while (i < refs.size()) {
            EjbRef ref = (EjbRef)refs.get(i);
            this.migrateRef(uri, ref, ear);
            ++i;
        }
    }

    protected void migrateRef(String uri, EjbRef ref, EARFile ear) {
        String link = ref.getLink();
        if (link == null || this.isQualifiedLink(link)) {
            return;
        }
        EnterpriseBean bean = ear.getEnterpiseBeanFromRef(ref, uri);
        if (bean == null) {
            return;
        }
        String referencedURI = this.getEJBJarURI(bean, ear);
        if (referencedURI != null && !referencedURI.equals(uri)) {
            ref.setLink(this.computeRelativeText(uri, referencedURI, bean));
        }
    }

    protected String getEJBJarURI(EnterpriseBean bean, EARFile ear) {
        List jarFiles = ear.getEJBJarFiles();
        int i = 0;
        while (i < jarFiles.size()) {
            EJBJarFile jarFile = (EJBJarFile)jarFiles.get(i);
            if (jarFile.getDeploymentDescriptor() == bean.getEjbJar()) {
                return jarFile.getURI();
            }
            ++i;
        }
        return null;
    }

    protected String computeRelativeText(String referencingURI, String referencedURI, EnterpriseBean bean) {
        return J2EEProjectUtilities.computeRelativeText((String)referencingURI, (String)referencedURI, (EnterpriseBean)bean);
    }

    protected boolean isQualifiedLink(String ejbLink) {
        return ejbLink != null && ejbLink.indexOf(35) != -1;
    }

    protected void initEAR(IVirtualComponent component) {
        this.referencedEARComponent = component;
    }

    protected EARFile getCurrentEARFile() {
        if (this.referencedEARComponent == null) {
            return null;
        }
        EARFile earFile = (EARFile)this.earNamesToEARFiles.get(this.referencedEARComponent.getName());
        if (earFile == null) {
            earFile = this.initCurrentEARFile();
        }
        return earFile;
    }

    protected EARFile initCurrentEARFile() {
        EARFile earFile = null;
        EARArtifactEdit earEdit = null;
        try {
            earEdit = EARArtifactEdit.getEARArtifactEditForRead((IVirtualComponent)this.referencedEARComponent);
            earFile = (EARFile)earEdit.asArchive(false);
            this.earNamesToEARFiles.put(this.referencedEARComponent.getName(), earFile);
            EARFile eARFile = earFile;
            return eARFile;
        }
        catch (OpenFailureException ex) {
            J2EEMigrationPlugin.logError(ex);
            return null;
        }
        finally {
            if (earEdit != null) {
                earEdit.dispose();
            }
        }
    }

    public void release() {
        Iterator iter = this.earNamesToEARFiles.values().iterator();
        while (iter.hasNext()) {
            ((EARFile)iter.next()).close();
        }
        this.earNamesToEARFiles.clear();
    }

    public IDataModel getCurrentConfig() {
        return this.currentConfig;
    }

    public void setCurrentConfig(IDataModel currentConfig) {
        this.currentConfig = currentConfig;
    }
}

