/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.EJBClientViewMigrationConfig;
import com.ibm.etools.j2ee.migration.internal.IEJBJarMigrationConfigProperties;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationConfig;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class EJBJarMigrationConfig
extends J2EEMigrationConfig
implements IEJBJarMigrationConfigProperties {
    protected Map beansToConfigs = new HashMap();
    protected List children;
    protected EjbModuleExtensionHelper modHelper;
    protected List relationships11;

    public static List filterConfigsWithNoApplicableClientConfigs(List jarConfigs) {
        ArrayList<IDataModel> result = new ArrayList<IDataModel>();
        int i = 0;
        while (i < jarConfigs.size()) {
            IDataModel config = (IDataModel)jarConfigs.get(i);
            if (!((List)config.getProperty("EJBJarMigrationConfig.getApplicableChildren")).isEmpty()) {
                result.add(config);
            }
            ++i;
        }
        return result;
    }

    public EJBJarMigrationConfig() {
    }

    public EJBJarMigrationConfig(IVirtualComponent component) {
        if (this.model != null) {
            this.init1XTo2XChildren(component);
        }
    }

    public void deselectAllChildren() {
        this.setAllChildrenSelected(false);
    }

    public List get11CMPChildren() {
        ArrayList<EJBClientViewMigrationConfig> result = null;
        int i = 0;
        while (i < this.getChildren().size()) {
            EJBClientViewMigrationConfig child = (EJBClientViewMigrationConfig)this.getChildren().get(i);
            if (child.is11CMP()) {
                if (result == null) {
                    result = new ArrayList<EJBClientViewMigrationConfig>();
                }
                result.add(child);
            }
            ++i;
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public List get11CMPs() {
        ArrayList<EnterpriseBean> result = null;
        if (this.getChildren().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        int size = this.getChildren().size();
        int i = 0;
        while (i < size) {
            EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)this.children.get(i);
            if (config.is11CMP()) {
                if (result == null) {
                    result = new ArrayList<EnterpriseBean>(size);
                }
                result.add(config.getEjb());
            }
            ++i;
        }
        return result;
    }

    public List get11Relationships() {
        if (this.relationships11 == null) {
            EJBJar jar = (EJBJar)this.getDataModel().getProperty("EJBJarMigrationConfig.ejbJar");
            this.initializeModuleExtHelper();
            this.relationships11 = this.modHelper != null ? this.modHelper.getRelationships_cmp11(jar) : Collections.EMPTY_LIST;
        }
        return this.relationships11;
    }

    public List getApplicableChildren() {
        if (this.isMigrateCMP1xto2x()) {
            return this.getChildren();
        }
        ArrayList<EJBClientViewMigrationConfig> result = new ArrayList<EJBClientViewMigrationConfig>();
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                EJBClientViewMigrationConfig child = (EJBClientViewMigrationConfig)this.children.get(i);
                if (!child.is11CMP()) {
                    result.add(child);
                }
                ++i;
            }
        }
        return result;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public EJBClientViewMigrationConfig getChildFor(EnterpriseBean ejb) {
        return (EJBClientViewMigrationConfig)this.beansToConfigs.get(ejb);
    }

    public List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    private List getChildrenForRoots() {
        if (this.getChildren() == null || this.getChildren().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EJBClientViewMigrationConfig> result = new ArrayList<EJBClientViewMigrationConfig>();
        int size = this.getChildren().size();
        int i = 0;
        while (i < size) {
            EJBClientViewMigrationConfig child = (EJBClientViewMigrationConfig)this.children.get(i);
            if (this.isRoot(child)) {
                result.add(child);
            }
            ++i;
        }
        return result;
    }

    public List getChildrenRequiringSelection() {
        HashSet beanConfigs = new HashSet();
        this.traverseRelationships(beanConfigs);
        this.traverseInheritance(beanConfigs);
        ArrayList<EJBClientViewMigrationConfig> result = new ArrayList<EJBClientViewMigrationConfig>();
        for (EJBClientViewMigrationConfig config : beanConfigs) {
            if (config.isSelected()) continue;
            result.add(config);
        }
        return result;
    }

    public List getDefaults() {
        ArrayList<EJBClientViewMigrationConfig> result = null;
        if (this.getChildren().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)this.children.get(i);
            if (result == null) {
                result = new ArrayList<EJBClientViewMigrationConfig>(size);
            }
            result.add(config);
            ++i;
        }
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public EJBJar getEJBJar(IVirtualComponent component) {
        EJBArtifactEdit edit = null;
        edit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
        if (edit != null) {
            return edit.getEJBJar();
        }
        return null;
    }

    public List getEntityChildren() {
        ArrayList<EJBClientViewMigrationConfig> result = null;
        if (this.getChildren() == null || this.getChildren().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)this.children.get(i);
            if (config.isEntity()) {
                if (result == null) {
                    result = new ArrayList<EJBClientViewMigrationConfig>(size);
                }
                result.add(config);
            }
            ++i;
        }
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public String getLocalClientViewSuffix() {
        return this.getStringProperty("EJBJarMigrationConfig.localClientViewSuffix");
    }

    public int getSelectedCount() {
        if (this.getChildren().isEmpty()) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < this.children.size()) {
            EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)this.children.get(i);
            if (config.isSelected()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public List getSelectedLocalClientEJBs() {
        ArrayList<EnterpriseBean> result = null;
        if (this.getChildren().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)this.children.get(i);
            if (config.isSelected() && !J2EEMigrationHelper.isEJB1_X(config.getEjb())) {
                if (result == null) {
                    result = new ArrayList<EnterpriseBean>(size);
                }
                result.add(config.getEjb());
            }
            ++i;
        }
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    private List getSubtypes(EJBClientViewMigrationConfig superTypeConfig) {
        List subTypes = null;
        this.initializeModuleExtHelper();
        if (this.modHelper != null) {
            subTypes = this.modHelper.getSubtypes(superTypeConfig.getEjb());
        }
        if (subTypes == null) {
            return Collections.EMPTY_LIST;
        }
        return subTypes;
    }

    public boolean has11CMPsToMigrate() {
        if (!this.getChildren().isEmpty()) {
            int size = this.getChildren().size();
            int i = 0;
            while (i < size) {
                EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)this.getChildren().get(i);
                if (config.is11CMP()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasLocalClientSelected() {
        if (!this.getChildren().isEmpty()) {
            int size = this.getChildren().size();
            int i = 0;
            while (i < size) {
                EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)this.getChildren().get(i);
                if (config.isSelected()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void init1XTo2XChildren(IVirtualComponent component) {
        this.children = new ArrayList();
        EJBJar jar = this.getEJBJar(component);
        if (jar != null) {
            EList beans = this.getEJBJar(component).getEnterpriseBeans();
            int i = 0;
            while (i < beans.size()) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                if (bean == null || !bean.isMessageDriven()) {
                    EJBClientViewMigrationConfig child = new EJBClientViewMigrationConfig(bean, this.getDataModel());
                    this.children.add(child);
                    this.beansToConfigs.put(bean, child);
                    if (child.is11CMP()) {
                        child.setIsSelected(this.getBooleanProperty("EJBJarMigrationConfig.migrateCMP1xto2x"));
                    }
                }
                ++i;
            }
        }
    }

    private void initializeModuleExtHelper() {
        if (this.modHelper == null) {
            this.modHelper = IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
        }
    }

    @Override
    public Set getPropertyNames() {
        Set superPropertyNames = super.getPropertyNames();
        superPropertyNames.addAll(Arrays.asList("EJBJarMigrationConfig.localClientViewEJBs", "EJBJarMigrationConfig.initClientViewChildren", "EJBJarMigrationConfig.ejbJar", "EJBJarMigrationConfig.hasLocalClientSelected", "EJBJarMigrationConfig.getSelectedCount", "EJBJarMigrationConfig.getChildCount", "EJBJarMigrationConfig.migrateCMP1xto2x", "EJBJarMigrationConfig.deleteRemoteClientView", "EJBJarMigrationConfig.localClientViewSuffix", "EJBJarMigrationConfig.reuseRemoteClientViewName", "Local", "EJBJarMigrationConfig.allChildrenSelected", "EJBJarMigrationConfig.getChildren", "EJBJarMigrationConfig.isAllSelected", "EJBJarMigrationConfig.isAnyChildSelected", "EJBJarMigrationConfig.getApplicableChildren", "EJBJarMigrationConfig.deselectAllEntries", "EJBJarMigrationConfig.selectAllEntries", "EJBJarMigrationConfig.get20CMPs", "EJBJarMigrationConfig.get11CMPs", "EJBJarMigrationConfig.get11Relationships", "EJBJarMigrationConfig.hasAccessBeans", "EJBJarMigrationConfig.getEntityChildren", "EJBJarMigrationConfig.getChildrenRequiringSelection"));
        return superPropertyNames;
    }

    public boolean isAllSelected() {
        if (this.getChildren().isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < this.children.size()) {
            EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)this.children.get(i);
            if (!config.isSelected()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAnyChildSelected() {
        if (this.getChildren().isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < this.children.size()) {
            EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)this.children.get(i);
            if (config.isSelected()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Boolean isComplex() {
        return new Boolean(this.isMigrateCMP1xto2x());
    }

    public boolean isDeleteRemoteClientView() {
        return this.getBooleanProperty("EJBJarMigrationConfig.deleteRemoteClientView");
    }

    public boolean isMigrateCMP1xto2x() {
        return this.getBooleanProperty("EJBJarMigrationConfig.migrateCMP1xto2x");
    }

    public boolean isReuseRemoteClientViewName() {
        return this.getBooleanProperty("EJBJarMigrationConfig.reuseRemoteClientViewName");
    }

    private boolean isRoot(EJBClientViewMigrationConfig current) {
        this.initializeModuleExtHelper();
        if (this.modHelper != null) {
            return this.modHelper.getSuperType(current.getEjb()) == null;
        }
        return true;
    }

    private boolean isSelectedOrRequired(Set beanConfigs, EJBClientViewMigrationConfig current) {
        return current.isSelected() || beanConfigs.contains(current);
    }

    private boolean needsRelationshipTraversal(EJBClientViewMigrationConfig child, List roles) {
        if (roles.isEmpty()) {
            return false;
        }
        return J2EEMigrationHelper.isEJB1_X(child.getEjb()) && this.isMigrateCMP1xto2x();
    }

    public void selectAllChildren() {
        this.setAllChildrenSelected(true);
    }

    public void selectAllEntities() {
        List entities = this.getEntityChildren();
        if (entities.isEmpty()) {
            entities = this.getDefaults();
        }
        int i = 0;
        while (i < entities.size()) {
            ((EJBClientViewMigrationConfig)entities.get(i)).setIsSelected(true);
            ++i;
        }
    }

    public void selectRequiredChildren() {
        this.setChildrenSelected(this.getChildrenRequiringSelection(), true);
    }

    public void setAllChildrenSelected(boolean selected) {
        this.setChildrenSelected(this.getChildren(), selected);
    }

    public void setChildrenSelected(List theChildren, boolean selected) {
        int i = 0;
        while (i < theChildren.size()) {
            EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)theChildren.get(i);
            config.setIsSelected(selected);
            ++i;
        }
    }

    @Override
    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("EJBJarMigrationConfig.allChildrenSelected")) {
            this.setAllChildrenSelected((Boolean)propertyValue);
        }
        if (propertyName.equals("EJBJarMigrationConfig.initClientViewChildren")) {
            this.initClientViewChildren((IDataModel)propertyValue);
        }
        if (propertyName.equals("EJBJarMigrationConfig.migrateCMP1xto2x")) {
            this.setMigrateCMP1xto2x((Boolean)propertyValue);
        }
        if (propertyName.equals("EJBJarMigrationConfig.deselectAllEntries") && propertyValue != null && ((Boolean)propertyValue).booleanValue()) {
            this.deselectAllChildren();
        }
        if (propertyName.equals("EJBJarMigrationConfig.selectAllEntries") && propertyValue != null && ((Boolean)propertyValue).booleanValue()) {
            this.selectAllEntities();
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private void initClientViewChildren(IDataModel model) {
        if (this.getChildren().isEmpty()) {
            IVirtualComponent component = this.getTargetComponent();
            this.init1XTo2XChildren(component);
        }
        List ejbsClientViews = this.getChildren();
        int i = 0;
        while (i < ejbsClientViews.size()) {
            EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)ejbsClientViews.get(i);
            config.setParentConfig(model);
            EnterpriseBean bean = config.ejb;
            if (bean.isContainerManagedEntity() && bean.getVersionID() == 11) {
                config.setIsSelected(this.getBooleanProperty("EJBJarMigrationConfig.migrateCMP1xto2x"));
            }
            ++i;
        }
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("EJBJarMigrationConfig.migrateCMP1xto2x")) {
            return new Boolean(false);
        }
        if (propertyName.equals("EJBJarMigrationConfig.deleteRemoteClientView")) {
            return new Boolean(false);
        }
        if (propertyName.equals("EJBJarMigrationConfig.reuseRemoteClientViewName")) {
            return new Boolean(false);
        }
        if (propertyName.equals("EJBJarMigrationConfig.selectAllEntries")) {
            return new Boolean(false);
        }
        if (propertyName.equals("EJBJarMigrationConfig.localClientViewSuffix")) {
            return "Local";
        }
        if (propertyName.equals("EJBJarMigrationConfig.get11CMPs")) {
            return this.get11CMPs();
        }
        if (propertyName.equals("EJBJarMigrationConfig.get11Relationships")) {
            return this.get11Relationships();
        }
        if (propertyName.equals("EJBJarMigrationConfig.get20CMPs")) {
            return this.get20CMPs();
        }
        if (propertyName.equals("EJBJarMigrationConfig.localClientViewEJBs")) {
            return this.getSelectedLocalClientEJBs();
        }
        if (propertyName.equals("EJBJarMigrationConfig.getApplicableChildren")) {
            return this.getApplicableChildren();
        }
        if (propertyName.equals("EJBJarMigrationConfig.isAnyChildSelected")) {
            return new Boolean(this.isAnyChildSelected());
        }
        if (propertyName.equals("EJBJarMigrationConfig.hasAccessBeans")) {
            return new Boolean(this.containsAccessBeanDocuments());
        }
        if (propertyName.equals("EJBJarMigrationConfig.isAllSelected")) {
            return new Boolean(this.isAllSelected());
        }
        if (propertyName.equals("EJBJarMigrationConfig.getChildren")) {
            return this.getChildren();
        }
        if (propertyName.equals("EJBJarMigrationConfig.getEntityChildren")) {
            return this.getEntityChildren();
        }
        if (propertyName.equals("EJBJarMigrationConfig.getChildrenRequiringSelection")) {
            return this.getChildrenRequiringSelection();
        }
        if (propertyName.equals("EJBJarMigrationConfig.hasLocalClientSelected")) {
            return new Boolean(this.hasLocalClientSelected());
        }
        if (propertyName.equals("EJBJarMigrationConfig.getSelectedCount")) {
            return new Integer(this.getSelectedCount());
        }
        if (propertyName.equals("EJBJarMigrationConfig.getChildCount")) {
            return new Integer(this.getChildCount());
        }
        if (propertyName.equals("EJBJarMigrationConfig.ejbJar")) {
            return this.getEJBJar((IVirtualComponent)this.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT"));
        }
        return super.getDefaultProperty(propertyName);
    }

    public void setDeleteRemoteClientView(boolean deleteRemoteClientView) {
        this.setBooleanProperty("EJBJarMigrationConfig.deleteRemoteClientView", deleteRemoteClientView);
    }

    public void setLocalClientViewSuffix(String localClientViewSuffix) {
        this.setProperty("EJBJarMigrationConfig.localClientViewSuffix", localClientViewSuffix);
    }

    public void setMigrateCMP1xto2x(boolean migrateCMP1xto2x) {
        this.setBooleanProperty("EJBJarMigrationConfig.migrateCMP1xto2x", migrateCMP1xto2x);
        this.setChildrenSelected(this.get11CMPChildren(), migrateCMP1xto2x);
    }

    public void setReuseRemoteClientViewName(boolean reuseRemoteClientViewName) {
        this.setBooleanProperty("EJBJarMigrationConfig.reuseRemoteClientViewName", reuseRemoteClientViewName);
        if (reuseRemoteClientViewName) {
            this.setLocalClientViewSuffix(null);
        }
    }

    private void traverseInheritance(Set beanConfigs) {
        this.traverseInheritanceFull(beanConfigs);
    }

    private void traverseInheritanceFull(Set beanConfigs) {
        List roots = this.getChildrenForRoots();
        int i = 0;
        while (i < roots.size()) {
            EJBClientViewMigrationConfig rootChild = (EJBClientViewMigrationConfig)roots.get(i);
            this.traverseInheritanceFull(beanConfigs, rootChild);
            ++i;
        }
    }

    private void traverseInheritanceFull(Set beanConfigs, EJBClientViewMigrationConfig rootConfig) {
        ArrayList flattened = new ArrayList();
        boolean anyRequired = this.traverseSubtypesAndCheckForRequired(beanConfigs, flattened, rootConfig, false);
        if (anyRequired) {
            beanConfigs.addAll(flattened);
        }
    }

    private void traverseRelationships(Set beanConfigs) {
        if (this.getChildren() == null || this.getChildren().isEmpty()) {
            return;
        }
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            EJBClientViewMigrationConfig child = (EJBClientViewMigrationConfig)this.children.get(i);
            this.traverseRelationships(beanConfigs, child);
            ++i;
        }
    }

    private void traverseRelationships(Set beanConfigs, EJBClientViewMigrationConfig child) {
        if (!child.getEjb().isContainerManagedEntity()) {
            return;
        }
        this.initializeModuleExtHelper();
        if (this.modHelper != null) {
            List roles = this.modHelper.getLocalRelationshipRoles_cmp11((ContainerManagedEntity)child.getEjb());
            if (!this.needsRelationshipTraversal(child, roles)) {
                return;
            }
            beanConfigs.add(child);
            int i = 0;
            while (i < roles.size()) {
                CommonRelationshipRole role = (CommonRelationshipRole)roles.get(i);
                ContainerManagedEntity opp = role.getTypeEntity();
                if (opp != null) {
                    beanConfigs.add(this.getChildFor((EnterpriseBean)opp));
                }
                ++i;
            }
        }
    }

    private boolean traverseSubtypesAndCheckForRequired(Set beanConfigs, List flattened, EJBClientViewMigrationConfig superTypeConfig, boolean required) {
        flattened.add(superTypeConfig);
        required = required || this.isSelectedOrRequired(beanConfigs, superTypeConfig);
        List subtypes = this.getSubtypes(superTypeConfig);
        int i = 0;
        while (i < subtypes.size()) {
            EnterpriseBean subtype = (EnterpriseBean)subtypes.get(i);
            EJBClientViewMigrationConfig subTypeConfig = this.getChildFor(subtype);
            flattened.add(subTypeConfig);
            required = this.traverseSubtypesAndCheckForRequired(beanConfigs, flattened, subTypeConfig, required);
            ++i;
        }
        return required;
    }

    public boolean has20CMPs() {
        if (!this.getChildren().isEmpty()) {
            int size = this.getChildren().size();
            int i = 0;
            while (i < size) {
                EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)this.getChildren().get(i);
                if (config.is20CMP()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public List get20CMPs() {
        ArrayList<EnterpriseBean> result = null;
        if (this.getChildren().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        int size = this.getChildren().size();
        int i = 0;
        while (i < size) {
            EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)this.children.get(i);
            if (config.is20CMP()) {
                if (result == null) {
                    result = new ArrayList<EnterpriseBean>(size);
                }
                result.add(config.getEjb());
            }
            ++i;
        }
        return result;
    }

    public boolean containsAccessBeanDocuments() {
        IVirtualComponent comp = (IVirtualComponent)this.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
        EJBArtifactEdit edit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)comp);
        URI accessbeanURI = URI.createURI((String)"META-INF/ibm-ejb-access-bean.xmi");
        Resource res = edit.getResource(accessbeanURI);
        IFile file = WorkbenchResourceHelper.getFile((Resource)res);
        return file.exists();
    }
}

