/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.commands.CreatePersistentAttributeCommand;
import com.ibm.etools.j2ee.commands.DeletePersistentAttributeCommand;
import com.ibm.etools.j2ee.commands.EnterpriseBeanCommand;
import com.ibm.etools.j2ee.commands.IEJBCommand;
import com.ibm.etools.j2ee.commands.IRootCommand;
import com.ibm.etools.j2ee.commands.PersistentRoleCommand;
import com.ibm.etools.j2ee.commands.UpdateContainerManagedEntityCommand;
import com.ibm.etools.j2ee13.commands.CreateEJB20RelationshipCommand;
import com.ibm.etools.j2ee13.commands.CreatePersistent20RoleCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.CommonRelationship;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBExtensionFilter;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.impl.LocalModelledPersistentAttributeFilter;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EJBJarMigrationCommandsHelper {
    protected IRootCommand deleteCommand;
    protected IRootCommand createCommand;
    protected Map createCommandMap = new HashMap();
    protected final String COLLECTION_TYPE = "java.util.Collection";
    protected EjbModuleExtensionHelper modHelper;
    protected EJBArtifactEdit ejbArtifactEdit = null;

    public IRootCommand getCreateCommand() {
        return this.createCommand;
    }

    public IRootCommand getDeleteCommand() {
        return this.deleteCommand;
    }

    public EnterpriseBeanCommand getCreateCommand(EnterpriseBean ejb) {
        return (EnterpriseBeanCommand)this.createCommandMap.get(ejb);
    }

    public void appendCreateCommand(IEJBCommand cmd) {
        this.createCommand = this.createCommand == null && cmd.isRootCommand() ? (IRootCommand)cmd : this.createCommand.append(cmd);
        if (cmd.isEnterpriseBeanRootCommand()) {
            this.createCommandMap.put(((EnterpriseBeanCommand)cmd).getEjb(), cmd);
        }
    }

    public void appendDeleteCommand(IRootCommand rootCommand) {
        this.deleteCommand = this.deleteCommand == null ? rootCommand : this.deleteCommand.append(rootCommand);
    }

    public void setupAttributeCodeCommands(CMPAttribute att, IRootCommand rootDelete, IRootCommand rootCreate) {
        new DeletePersistentAttributeCommand(rootDelete, att.getName(), true, false).setSourceMetaType((EObject)att);
        CreatePersistentAttributeCommand cmd = new CreatePersistentAttributeCommand(rootCreate, att.getName(), true, false);
        cmd.setSourceMetaType((EObject)att);
        cmd.setKey(att.isKey());
        cmd.setGenerateAccessors(true);
    }

    private void setupAttributeCodeGenCommands(ContainerManagedEntity cmp, EJBArtifactEdit artifactEdit) {
        UpdateContainerManagedEntityCommand rootDelete = new UpdateContainerManagedEntityCommand((EnterpriseBean)cmp, artifactEdit);
        UpdateContainerManagedEntityCommand rootCreate = new UpdateContainerManagedEntityCommand((EnterpriseBean)cmp, artifactEdit);
        rootDelete.setIsMigrationCleanup(true);
        rootCreate.setIsMigrationCleanup(true);
        this.initializeModuleExtensionHelper();
        List attributes = cmp.getFilteredFeatures((EJBExtensionFilter)LocalModelledPersistentAttributeFilter.singleton());
        int size = attributes.size();
        int i = 0;
        while (i < size) {
            CMPAttribute att = (CMPAttribute)attributes.get(i);
            this.setupAttributeCodeCommands(att, (IRootCommand)rootDelete, (IRootCommand)rootCreate);
            ++i;
        }
        this.appendCreateCommand((IEJBCommand)rootCreate);
        this.appendDeleteCommand((IRootCommand)rootDelete);
    }

    public void setupCodeGenCommands(IDataModel config) {
        List cmps = (List)config.getProperty("EJBJarMigrationConfig.get11CMPs");
        if (cmps.isEmpty()) {
            return;
        }
        int size = cmps.size();
        IVirtualComponent comp = (IVirtualComponent)config.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
        if (this.ejbArtifactEdit == null) {
            this.ejbArtifactEdit = EJBArtifactEdit.getEJBArtifactEditForWrite((IVirtualComponent)comp);
        }
        int i = 0;
        while (i < size) {
            ContainerManagedEntity cmp = (ContainerManagedEntity)cmps.get(i);
            this.setupAttributeCodeGenCommands(cmp, this.ejbArtifactEdit);
            ++i;
        }
        this.setupRelationshipCreationCommands(config);
    }

    public void setupRelationshipCreationCommands(IDataModel config) {
        List rels = (List)config.getProperty("EJBJarMigrationConfig.get11Relationships");
        if (rels.isEmpty()) {
            return;
        }
        int size = rels.size();
        int i = 0;
        while (i < size) {
            CommonRelationship rel = (CommonRelationship)rels.get(i);
            this.setupRelationshipCreationCommands(config, rel);
            ++i;
        }
    }

    public void setupRelationshipCreationCommands(IDataModel config, CommonRelationship rel) {
        CreatePersistent20RoleCommand first = this.createRelationshipRoleCreationCommand(config, rel.getFirstCommonRole());
        CreatePersistent20RoleCommand second = this.createRelationshipRoleCreationCommand(config, rel.getSecondCommonRole());
        this.createRelationshipCreationCommand(config, rel, first, second);
    }

    public void createRelationshipCreationCommand(IDataModel config, CommonRelationship rel, CreatePersistent20RoleCommand firstRole, CreatePersistent20RoleCommand secondRole) {
        CreateEJB20RelationshipCommand cmd = new CreateEJB20RelationshipCommand(rel.getName(), (PersistentRoleCommand)firstRole, (PersistentRoleCommand)secondRole);
        this.appendCreateCommand((IEJBCommand)cmd);
    }

    public CreatePersistent20RoleCommand createRelationshipRoleCreationCommand(IDataModel config, CommonRelationshipRole role) {
        ContainerManagedEntity sourceCmp = role.getSourceEntity();
        EnterpriseBeanCommand root = this.getCreateCommand((EnterpriseBean)sourceCmp);
        if (root == null) {
            return null;
        }
        CreatePersistent20RoleCommand cmd = new CreatePersistent20RoleCommand((IRootCommand)root, role.getName());
        CommonRelationshipRole op = role.getOppositeAsCommonRole();
        cmd.setIsMany(op.isMany());
        if (role.isNavigable()) {
            cmd.setCmrFieldName(role.getName());
            if (role.isMany()) {
                cmd.setCmrFieldCollectionTypeName("java.util.Collection");
            }
        }
        cmd.setForward(role.isForward());
        cmd.setKey(role.isKey());
        return cmd;
    }

    protected void initializeModuleExtensionHelper() {
        if (this.modHelper == null) {
            this.modHelper = IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
        }
    }

    public EJBArtifactEdit getEjbArtifactEdit() {
        return this.ejbArtifactEdit;
    }
}

