/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.internal.J2EESpecificationConstants;
import org.eclipse.jst.j2ee.internal.J2EEStatus;
import org.eclipse.jst.j2ee.jca.AuthenticationMechanism;
import org.eclipse.jst.j2ee.jca.AuthenticationMechanismType;
import org.eclipse.jst.j2ee.jca.ConfigProperty;
import org.eclipse.jst.j2ee.jca.ConnectionDefinition;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.JcaFactory;
import org.eclipse.jst.j2ee.jca.OutboundResourceAdapter;
import org.eclipse.jst.j2ee.jca.ResourceAdapter;
import org.eclipse.jst.j2ee.jca.SecurityPermission;

public class Connector14SpecificationMigrator {
    public J2EEStatus migrateConnectorTo14(Connector connector) {
        this.migrateResourceAdaptor(connector);
        return new J2EEStatus(0, new J2EEStatus().format(J2EESpecificationConstants.DEFAULT_COMPLETED_STATUS_MSG, connector.getDisplayName()));
    }

    private void migrateResourceAdaptor(Connector connector) {
        ResourceAdapter resAdaptor = connector.getResourceAdapter();
        if (resAdaptor != null) {
            OutboundResourceAdapter outboundAdaptor = JcaFactory.eINSTANCE.createOutboundResourceAdapter();
            outboundAdaptor.setReauthenticationSupport(resAdaptor.isReauthenticationSupport());
            outboundAdaptor.setTransactionSupport(resAdaptor.getTransactionSupport());
            ConnectionDefinition connDefinition = JcaFactory.eINSTANCE.createConnectionDefinition();
            connDefinition.setManagedConnectionFactoryClass(resAdaptor.getManagedConnectionFactoryClass());
            connDefinition.setConnectionFactoryInterface(resAdaptor.getConnectionFactoryInterface());
            connDefinition.setConnectionFactoryImplClass(resAdaptor.getConnectionFactoryImplClass());
            connDefinition.setConnectionInterface(resAdaptor.getConnectionInterface());
            connDefinition.setConnectionImplClass(resAdaptor.getConnectionImplClass());
            outboundAdaptor.getConnectionDefinitions().add((Object)connDefinition);
            resAdaptor.setOutboundResourceAdapter(outboundAdaptor);
            this.migrateAuthenticationMechanism(resAdaptor);
            this.migrateDescriptions(resAdaptor);
        }
    }

    private void migrateDescriptions(ResourceAdapter resAdaptor) {
        EList configProps;
        EList authMechanisms;
        EList secPermissions = resAdaptor.getSecurityPermissions();
        if (!secPermissions.isEmpty()) {
            int i = 0;
            while (i < secPermissions.size()) {
                SecurityPermission secPerm = (SecurityPermission)secPermissions.get(i);
                String secDescription = secPerm.getDescription();
                if (secDescription != null && secDescription.length() > 0) {
                    Description description = CommonFactory.eINSTANCE.createDescription();
                    description.setValue(secDescription);
                    secPerm.getDescriptions().add((Object)description);
                }
                ++i;
            }
        }
        if (!(authMechanisms = resAdaptor.getAuthenticationMechanisms()).isEmpty()) {
            int i = 0;
            while (i < authMechanisms.size()) {
                AuthenticationMechanism authMech = (AuthenticationMechanism)authMechanisms.get(i);
                String authDescrition = authMech.getDescription();
                if (authDescrition != null && authDescrition.length() > 0) {
                    Description description = CommonFactory.eINSTANCE.createDescription();
                    description.setValue(authDescrition);
                    authMech.getDescriptions().add((Object)description);
                }
                ++i;
            }
        }
        if (!(configProps = resAdaptor.getConfigProperties()).isEmpty()) {
            int i = 0;
            while (i < configProps.size()) {
                ConfigProperty configProp = (ConfigProperty)configProps.get(i);
                String configDescription = configProp.getDescription();
                if (configDescription != null && configDescription.length() > 0) {
                    Description description = CommonFactory.eINSTANCE.createDescription();
                    description.setValue(configDescription);
                    configProp.getDescriptions().add((Object)description);
                }
                ++i;
            }
        }
    }

    private void migrateAuthenticationMechanism(ResourceAdapter resAdaptor) {
        EList authMechanisms = resAdaptor.getAuthenticationMechanisms();
        int i = 0;
        while (i < authMechanisms.size()) {
            AuthenticationMechanism authMech = (AuthenticationMechanism)authMechanisms.get(i);
            AuthenticationMechanismType authType = authMech.getAuthenticationMechanismType();
            if (authType != null) {
                authMech.setAuthenticationMechanism(authType.getName());
            } else {
                String customAuth = authMech.getCustomAuthMechType();
                if (customAuth != null && customAuth.length() > 0) {
                    authMech.setAuthenticationMechanism(customAuth);
                }
            }
            ++i;
        }
    }
}

