/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import com.ibm.etools.j2ee.migration.internal.IComposedMigrationConfigProperties;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationConfig;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationHelper;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationOperation;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class ComposedMigrationConfig
extends J2EEMigrationConfig
implements IDataModelListener,
IComposedMigrationConfigProperties {
    protected List children;
    protected List composedComponents;
    protected J2EEMigrationOperation defaultOperation;
    public static final String COMPOSED_CONFIG = "ComposedConfig";

    public static IDataModel createComposedConfigForEAR(IVirtualComponent anEARComponent) {
        return DataModelFactory.createDataModel((IDataModelProvider)new ComposedMigrationConfig(anEARComponent, "jst.ear"));
    }

    public ComposedMigrationConfig(IVirtualComponent component, String aDeploymentDesType) {
        super(component, aDeploymentDesType);
    }

    protected IStatus validateModuleName() {
        IStatus stat;
        IStatus stat2;
        String moduleName = this.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME");
        if (moduleName == null || moduleName.length() == 0 && !this.isComposed().booleanValue()) {
            return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"34"));
        }
        if (this.isEAR() && (stat2 = this.validateModuleServerTargets(this.getDataModel())) != null && !stat2.isOK()) {
            return stat2;
        }
        if (this.getChildren() != null) {
            int i = 0;
            while (i < this.children.size()) {
                IDataModel config = (IDataModel)this.children.get(i);
                String moduleModuleCompName = config.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME");
                if (moduleModuleCompName == null || moduleModuleCompName.length() == 0) {
                    return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"34"));
                }
                if (config.getBooleanProperty("J2EEMigrationConfig.isSelected") && (stat = this.validateModuleServerTargets(config)) != null && !stat.isOK()) {
                    return stat;
                }
                ++i;
            }
        }
        List ejbConfigs = this.getEJBJarChildren();
        for (IDataModel dm : ejbConfigs) {
            if (!dm.getBooleanProperty("J2EEMigrationConfig.isSelected") || (stat = this.validateContainsValidArtifacts(dm)) == null || stat.isOK()) continue;
            return stat;
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    public IStatus validate(String propertyName) {
        IStatus result = super.validate(propertyName);
        if (result != null && !result.isOK()) {
            return result;
        }
        if (propertyName.equals("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID") || propertyName.equals("J2EEMigrationConfig.J2EE_MIGRATION_VERSION") || propertyName.equals("IComposedMigrationConfigProperties.allAreSelected")) {
            return this.validateModuleName();
        }
        return result;
    }

    private IStatus validateContainsValidArtifacts(IDataModel ejbConfig) {
        String runtimeName = this.getServerTargetDataModel().getStringProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID");
        IRuntime serverRuntime = null;
        serverRuntime = ServerCore.findRuntime((String)runtimeName);
        if (serverRuntime != null && serverRuntime.getRuntimeType().getId().contains("ibm.ws")) {
            boolean hasEntities;
            boolean isV5 = this.getProperty("J2EEMigrationConfig.J2EE_MIGRATION_VERSION").equals("5.0");
            boolean bl = hasEntities = ((List)ejbConfig.getProperty("EJBJarMigrationConfig.getEntityChildren")).size() > 0;
            if (hasEntities && isV5) {
                return WTPCommonPlugin.createErrorStatus((String)J2EEMigrationUIResourceHandler.EJB_module_contains_Entity);
            }
            if (ejbConfig.getBooleanProperty("EJBJarMigrationConfig.hasAccessBeans") && isV5) {
                return WTPCommonPlugin.createErrorStatus((String)J2EEMigrationUIResourceHandler.EJB_module_contains_Access);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    @Override
    public String getID() {
        return COMPOSED_CONFIG;
    }

    public ComposedMigrationConfig() {
    }

    @Override
    public void init() {
        super.init();
        this.composedComponents = (List)this.getProperty("IComposedMigrationConfigProperties.components");
    }

    protected Integer convertVersionLabeltoID(String label) {
        int id = -1;
        if (label.equals("1.3")) {
            id = 13;
        } else if (label.equals("1.4")) {
            id = 14;
        } else if (label.equals("5.0")) {
            id = 50;
        }
        return new Integer(id);
    }

    public void deselectAllChildren() {
        this.setAllChildrenSelected(false);
    }

    public void dispose() {
        super.dispose();
        this.disposeChildren();
    }

    protected void disposeChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            ((IDataModel)this.children.get(i)).dispose();
            ++i;
        }
    }

    @Override
    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName == "J2EEMigrationConfig.J2EE_MIGRATION_VERSION" && propertyValue != null) {
            this.setProperty("J2EEMigrationConfig.J2EE_MIGRATION_VERSION", propertyValue);
            if (this.isEAR()) {
                this.serverTargetDataModel.setProperty("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID", propertyValue);
                this.model.notifyPropertyChange("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID", 4);
            }
            this.propogateVersionChange(propertyValue);
        }
        if (propertyName == "IComposedMigrationConfigProperties.components") {
            this.setProperty("IComposedMigrationConfigProperties.components", propertyValue);
        }
        if (propertyName == "J2EEMigrationConfig.deploymentDesType") {
            this.setProperty("J2EEMigrationConfig.deploymentDesType", propertyValue);
            this.serverTargetDataModel.setProperty("IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID", propertyValue);
        }
        if ("IArtifactEditOperationDataModelProperties.PROJECT_NAME".equals(propertyName)) {
            this.serverTargetDataModel.setProperty("IJ2EEProjectServerTargetDataModelProperties.PROJECT_NAME", propertyValue);
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.allAreSelected")) {
            this.setAllChildrenSelected((Boolean)propertyValue);
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.hasEJBJarChildren")) {
            return this.hasEJBJarChildren();
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.hasWEBChildren")) {
            return this.hasWebChildren();
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.hasConnectorChildren")) {
            return this.hasConnectorChildren();
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private void propogateVersionChange(Object propertyValue) {
        String parentTargetVersion = (String)propertyValue;
        this.children = this.getChildren();
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                IDataModel j2eeConfig = (IDataModel)this.children.get(i);
                j2eeConfig.setStringProperty("J2EEMigrationConfig.J2EE_MIGRATION_VERSION", parentTargetVersion);
                IDataModel childServerModel = j2eeConfig.getNestedModel("J2EEMigrationConfig.NESTED_MODEL_SERVER_TARGET");
                childServerModel.setProperty("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID", (Object)parentTargetVersion);
                ++i;
            }
        }
    }

    private void initServerTargetModel(IDataModel childConfig) {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime existingRuntime = null;
        String childProjName = childConfig.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(childProjName);
        String earTargetVersion = (String)this.serverTargetDataModel.getProperty("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID");
        IDataModel childServerModel = childConfig.getNestedModel("J2EEMigrationConfig.NESTED_MODEL_SERVER_TARGET");
        childServerModel.setProperty("IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID", childConfig.getProperty("IArtifactEditOperationDataModelProperties.TYPE_ID"));
        childServerModel.setProperty("IJ2EEProjectServerTargetDataModelProperties.PROJECT_NAME", (Object)childProjName);
        childServerModel.setProperty("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID", (Object)earTargetVersion);
        if (proj != null) {
            try {
                existingRuntime = J2EEMigrationHelper.getTargetRuntime(proj);
            }
            catch (CoreException e) {
                J2EEMigrationPlugin.logError(e);
            }
            if (existingRuntime != null) {
                childServerModel.setStringProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", existingRuntime.getName());
            }
        }
    }

    public List getAllSelectedProjects() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.isEAR()) {
            result.add(this.getTargetProject());
        }
        List theChildren = this.getSelectedChildren();
        int i = 0;
        while (i < theChildren.size()) {
            IDataModel child = (IDataModel)theChildren.get(i);
            result.add(child.getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT"));
            ++i;
        }
        return result;
    }

    public List getAllVersionMigratableConfigs() {
        List theChildren;
        ArrayList<ComposedMigrationConfig> result = new ArrayList<ComposedMigrationConfig>();
        if (this.getBooleanProperty("J2EEMigrationConfig.isEARComponent")) {
            result.add(this);
        }
        if ((theChildren = this.getChildren()) != null) {
            int i = 0;
            while (i < theChildren.size()) {
                IDataModel child = (IDataModel)theChildren.get(i);
                if (child.getBooleanProperty("J2EEMigrationConfig.isSelected")) {
                    result.add((ComposedMigrationConfig)child);
                }
                ++i;
            }
        }
        return result;
    }

    public List getAppClientChildren() {
        return this.getChildrenOfType("jst.appclient");
    }

    public List getChildren() {
        if (this.children == null) {
            this.initChildren();
        }
        return this.children;
    }

    public List getChildrenOfType(String ddType) {
        if (this.getChildren() == null || this.getChildren().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IDataModel> result = new ArrayList<IDataModel>();
        int i = 0;
        while (i < this.children.size()) {
            IDataModel child = (IDataModel)this.children.get(i);
            if (child.getStringProperty("IArtifactEditOperationDataModelProperties.TYPE_ID").equals(ddType)) {
                result.add(child);
            }
            ++i;
        }
        return result;
    }

    public List getConnectorChildren() {
        return this.getChildrenOfType("jst.connector");
    }

    public List getEJBJarChildren() {
        return this.getChildrenOfType("jst.ejb");
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IComposedMigrationConfigProperties.getEJBJarChildren")) {
            return this.getEJBJarChildren();
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.getConnectorChildren")) {
            return this.getConnectorChildren();
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.getAppClientChildren")) {
            return this.getAppClientChildren();
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.getWEBChildren")) {
            return this.getWebChildren();
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.hasEJBJarChildren")) {
            return new Boolean(this.hasEJBJarChildren());
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.hasWEBChildren")) {
            return new Boolean(this.hasWebChildren());
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.hasAppClientChildren")) {
            return new Boolean(this.hasAppClientChildren());
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.hasConnectorChildren")) {
            return new Boolean(this.hasConnectorChildren());
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.GET_ALL_SELECTED_PROJECTS")) {
            return this.getAllSelectedProjects();
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.WITH_ALL_SELECTED_PROJECTS")) {
            return this.withAllSelectedChildren();
        }
        if (propertyName.equals("IComposedMigrationConfigProperties.GET_ALL_VERSION_MIGRATABLE_CONFIGS")) {
            return this.getAllVersionMigratableConfigs();
        }
        if (propertyName.equals("J2EEMigrationConfig.childerenConfigs")) {
            return this.getChildren();
        }
        return super.getDefaultProperty(propertyName);
    }

    @Override
    public IDataModelOperation getDefaultOperation() {
        if (this.defaultOperation == null) {
            this.defaultOperation = new J2EEMigrationOperation(this.getDataModel(), null);
        }
        return this.defaultOperation;
    }

    @Override
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.addAll(Arrays.asList("IComposedMigrationConfigProperties.getEJBJarChildren", "IComposedMigrationConfigProperties.getConnectorChildren", "IComposedMigrationConfigProperties.getAppClientChildren", "IComposedMigrationConfigProperties.getWEBChildren", "IComposedMigrationConfigProperties.components", "IComposedMigrationConfigProperties.migrateVersionForAll", "IComposedMigrationConfigProperties.allAreSelected", "IComposedMigrationConfigProperties.hasEJBJarChildren", "IComposedMigrationConfigProperties.hasWEBChildren", "IComposedMigrationConfigProperties.hasAppClientChildren", "IComposedMigrationConfigProperties.hasConnectorChildren", "IComposedMigrationConfigProperties.GET_ALL_SELECTED_PROJECTS", "IComposedMigrationConfigProperties.WITH_ALL_SELECTED_PROJECTS", "IComposedMigrationConfigProperties.GET_ALL_VERSION_MIGRATABLE_CONFIGS"));
        return propertyNames;
    }

    public List getSelectedChildren() {
        List theChildren = this.getChildren();
        ArrayList<IDataModel> result = new ArrayList<IDataModel>();
        if (theChildren != null) {
            int i = 0;
            while (i < theChildren.size()) {
                IDataModel child = (IDataModel)theChildren.get(i);
                if (child.getBooleanProperty("J2EEMigrationConfig.isSelected")) {
                    result.add(child);
                }
                ++i;
            }
        }
        return result;
    }

    public IVirtualComponent getComponent() {
        if (this.composedComponents == null) {
            this.composedComponents = new ArrayList();
            this.composedComponents.add(this.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT"));
        }
        if (this.composedComponents.size() > 0) {
            return (IVirtualComponent)this.composedComponents.get(0);
        }
        return null;
    }

    public List getWebChildren() {
        return this.getChildrenOfType("jst.web");
    }

    public boolean hasAppClientChildren() {
        return this.hasChildOfType("jst.appclient");
    }

    public boolean hasConnectorChildren() {
        return this.hasChildOfType("jst.connector");
    }

    public boolean hasChildOfType(String ddType) {
        if (this.getChildren() == null || this.getChildren().isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < this.children.size()) {
            IDataModel child = (IDataModel)this.children.get(i);
            if (child.getProperty("IArtifactEditOperationDataModelProperties.TYPE_ID").equals(ddType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasEJBJarChildren() {
        return this.hasChildOfType("jst.ejb");
    }

    public boolean hasSelectedAppClientChildren() {
        return this.hasSelectedChildOfType("jst.appclient");
    }

    public boolean hasSelectedChildOfType(String ddType) {
        if (this.getChildren().isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < this.children.size()) {
            J2EEMigrationConfig child = (J2EEMigrationConfig)this.children.get(i);
            if (child.getDeploymentDesType() == ddType && child.isSelected()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasSelectedEJBJarChildren() {
        return this.hasSelectedChildOfType("jst.ejb");
    }

    public boolean hasSelectedWebChildren() {
        return this.hasSelectedChildOfType("jst.web");
    }

    public boolean hasWebChildren() {
        return this.hasChildOfType("jst.web");
    }

    protected void initChildConfigsForEAR() {
        IVirtualComponent earComponent = this.getComponent();
        if (earComponent != null) {
            EARArtifactEdit edit = null;
            try {
                edit = EARArtifactEdit.getEARArtifactEditForRead((IVirtualComponent)earComponent);
                IVirtualReference[] refs = edit.getJ2EEModuleReferences();
                ArrayList<IVirtualComponent> refComps = new ArrayList<IVirtualComponent>();
                int i = 0;
                while (i < refs.length) {
                    refComps.add(refs[i].getReferencedComponent());
                    ++i;
                }
                if (!refComps.isEmpty()) {
                    this.children = this.createConfigs(refComps);
                }
                if (this.children != null) {
                    i = 0;
                    while (i < this.children.size()) {
                        IDataModel j2eeConfig = (IDataModel)this.children.get(i);
                        this.initServerTargetModel(j2eeConfig);
                        ++i;
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
    }

    private IStatus validateModuleServerTargets(IDataModel j2eeConfig) {
        IDataModel childServerModel = j2eeConfig.getNestedModel("J2EEMigrationConfig.NESTED_MODEL_SERVER_TARGET");
        DataModelPropertyDescriptor[] validChildRuntimes = childServerModel.getValidPropertyDescriptors("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID");
        String childRuntimeTarget = (String)childServerModel.getProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID");
        IRuntime serverRuntime = null;
        serverRuntime = ServerCore.findRuntime((String)childRuntimeTarget);
        boolean validFound = false;
        int j = 0;
        while (j < validChildRuntimes.length) {
            DataModelPropertyDescriptor dataModelPropertyDescriptor = validChildRuntimes[j];
            if (serverRuntime != null && serverRuntime.getId().equals(dataModelPropertyDescriptor.getPropertyValue())) {
                validFound = true;
                break;
            }
            ++j;
        }
        if (!validFound && serverRuntime != null) {
            return WTPCommonPlugin.createErrorStatus((String)J2EEMigrationUIResourceHandler.bind((String)J2EEMigrationUIResourceHandler.Current_module_runtime_target_not_supported, (Object)j2eeConfig.getProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"), (Object)serverRuntime.getName()));
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected void initChildren() {
        if (this.isEAR()) {
            this.initChildConfigsForEAR();
        } else {
            this.composedComponents = (List)this.getProperty("IComposedMigrationConfigProperties.components");
            this.children = this.createConfigs(this.composedComponents);
            if (this.children != null) {
                int i = 0;
                while (i < this.children.size()) {
                    IDataModel j2eeConfig = (IDataModel)this.children.get(i);
                    this.initServerTargetModel(j2eeConfig);
                    ++i;
                }
            }
        }
    }

    public boolean isAnyVersionMigrateable() {
        return (Boolean)this.getDefaultProperty("J2EEMigrationConfig.isVersionMigratable") != false || ComposedMigrationConfig.isAnyVersionMigrateable(this.getChildren());
    }

    public void selectAllChildren() {
        this.setAllChildrenSelected(true);
    }

    public void setAllChildrenSelected(boolean selected) {
        List theChildren = this.getChildren();
        if (theChildren != null) {
            int i = 0;
            while (i < theChildren.size()) {
                IDataModel config = (IDataModel)theChildren.get(i);
                config.setBooleanProperty("J2EEMigrationConfig.isSelected", selected);
                ++i;
            }
        }
    }

    public List withAllChildren() {
        if (this.isPrimComposed()) {
            return this.getChildren();
        }
        ArrayList<ComposedMigrationConfig> result = new ArrayList<ComposedMigrationConfig>();
        result.add(this);
        result.addAll(this.getChildren());
        return result;
    }

    public List withAllSelectedChildren() {
        if (this.isPrimComposed()) {
            return this.getSelectedChildren();
        }
        ArrayList<ComposedMigrationConfig> result = new ArrayList<ComposedMigrationConfig>();
        result.add(this);
        result.addAll(this.getSelectedChildren());
        return result;
    }

    @Override
    public void propertyChanged(DataModelEvent event) {
        block4: {
            block3: {
                if (event.getDataModel() != this.serverTargetDataModel || !event.getPropertyName().equals("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID")) break block3;
                if (this.children == null) break block4;
                int i = 0;
                while (i < this.children.size()) {
                    IDataModel j2eeConfig = (IDataModel)this.children.get(i);
                    j2eeConfig.setProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", event.getDataModel().getProperty(event.getPropertyName()));
                    ++i;
                }
                break block4;
            }
            if (event.getDataModel() == this.serverTargetDataModel && event.getPropertyName().equals("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID") && this.children != null) {
                int i = 0;
                while (i < this.children.size()) {
                    IDataModel j2eeConfig = (IDataModel)this.children.get(i);
                    j2eeConfig.setProperty("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID", event.getDataModel().getProperty(event.getPropertyName()));
                    ++i;
                }
            }
        }
    }
}

