/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.internal;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;
import org.eclipse.jst.j2ee.internal.J2EEMultiStatus;
import org.eclipse.jst.j2ee.internal.J2EEStatus;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditProviderOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;

public abstract class AbstractJ2EEMigrationOperation
extends ArtifactEditProviderOperation {
    protected J2EEStatus status;
    protected IOperationHandler operationHandler;
    protected EjbModuleExtensionHelper modHelper;
    protected IVirtualComponent currentComponent;

    public AbstractJ2EEMigrationOperation(IDataModel config, IOperationHandler opHandler) {
        super(config);
        this.operationHandler = opHandler;
    }

    public AbstractJ2EEMigrationOperation() {
    }

    public J2EEStatus getMigrationStatus() {
        if (this.status == null) {
            this.status = new J2EEMultiStatus();
        }
        return this.status;
    }

    public void setStatus(J2EEStatus status) {
        this.status = status;
    }

    public String format(String aPattern, String arg1) {
        return this.format(aPattern, new String[]{arg1});
    }

    protected String format(String aPattern, String arg1, String arg2) {
        return MessageFormat.format(aPattern, arg1, arg2);
    }

    protected String format(String aPattern, String arg1, String arg2, String arg3) {
        return MessageFormat.format(aPattern, arg1, arg2, arg3);
    }

    protected String format(String aPattern, String[] args) {
        return MessageFormat.format(aPattern, args);
    }

    public void appendStatus(J2EEStatus aStatus) {
        if (aStatus == null) {
            return;
        }
        this.status = this.status == null ? aStatus : this.status.append(aStatus);
    }

    public void appendStatus(int aSeverity, String message) {
        J2EEStatus newStatus = new J2EEStatus(aSeverity, message);
        this.appendStatus(newStatus);
    }

    protected void executeNestedOperation(IProgressMonitor monitor, AbstractJ2EEMigrationOperation op, int ticks) throws InvocationTargetException, InterruptedException, ExecutionException {
        op.execute(monitor, null);
    }

    protected void executeNestedOperation(IProgressMonitor monitor, ArtifactEditProviderOperation op, int ticks) throws ExecutionException, InvocationTargetException, InterruptedException {
        op.execute(monitor, null);
    }

    protected void initializeModuleExtensionHelper() {
        if (this.modHelper == null) {
            this.modHelper = IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
        }
    }

    public IVirtualComponent getCurrentComponent() {
        return this.currentComponent;
    }

    public void setCurrentComponent(IVirtualComponent currentComp) {
        this.currentComponent = currentComp;
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && projectName.length() > 0) {
            return super.getTargetProject();
        }
        IProject targetProject = null;
        List projects = (List)this.getDataModel().getProperty("IComposedMigrationConfigProperties.GET_ALL_SELECTED_PROJECTS");
        if (projects != null && !projects.isEmpty()) {
            targetProject = (IProject)projects.get(0);
            this.getDataModel().setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)targetProject.getName());
        }
        return targetProject;
    }

    public IVirtualComponent getTargetComponent() {
        String componentName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME");
        if (componentName != null && componentName.length() > 0) {
            return super.getTargetComponent();
        }
        IVirtualComponent targetComp = null;
        List components = (List)this.getDataModel().getProperty("IComposedMigrationConfigProperties.components");
        if (components != null && !components.isEmpty()) {
            targetComp = (IVirtualComponent)components.get(0);
            this.getDataModel().setProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", (Object)targetComp.getName());
        }
        return targetComp;
    }

    protected boolean shouldSaveArtifactEditOnDispose() {
        return true;
    }

    public void dispose() {
        if (this.artifactEdit != null) {
            if (this.shouldSaveArtifactEditOnDispose()) {
                this.artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
            this.artifactEdit.dispose();
        }
    }
}

