/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.forward.migration;

import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import com.ibm.etools.j2ee.ILibModule;
import com.ibm.etools.j2ee.forward.migration.J2EEProjectMigrator;
import com.ibm.etools.j2ee.migration.internal.OldWebSettings;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;

public class WebProjectMigrator
extends J2EEProjectMigrator {
    protected static final String JSP_LEVEL = "JSPLevel";
    protected OldWebSettings fWebSettings;

    public IMigrationStatus migrate(IProject project, IProgressMonitor monitor) {
        try {
            this.init(project);
            this.doMigration(monitor);
            if (this.currentErrorStatus == null || this.currentErrorStatus != null && this.currentErrorStatus.getSeverity() != 4) {
                this.setServerContextRoot();
            }
        }
        catch (Exception e) {
            this.reportError(e);
        }
        return new MigrationStatus(this.getStatus());
    }

    @Override
    protected void init(IProject project) {
        super.init(project);
        this.fWebSettings = null;
    }

    @Override
    protected IResource[] getResources(String componentName, int type) {
        IResource[] resources = null;
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                resources = this.getWebContentFolder();
                this.fJavaSourceFolders = resources;
            }
        }
        return resources;
    }

    private void updateWebProperties(WorkbenchComponent module) {
        ILibModule[] libModules = this.getWebSettings().getLibModules();
        int i = 0;
        while (i < libModules.length) {
            ReferencedComponent refComponent = ComponentcoreFactory.eINSTANCE.createReferencedComponent();
            String projectName = libModules[i].getProjectName();
            StringBuffer buffer = new StringBuffer("module:/resource/");
            buffer.append(projectName);
            buffer.append("/");
            buffer.append(projectName);
            URI handleURI = URI.createURI((String)buffer.toString());
            refComponent.setHandle(handleURI);
            refComponent.setRuntimePath((IPath)new Path("/WEB-INF/lib"));
            refComponent.setArchiveName(libModules[i].getJarName());
            module.getReferencedComponents().add((Object)refComponent);
            ++i;
        }
    }

    private IResource[] getWebContentFolder() {
        IFolder[] resources = new IFolder[1];
        String webcontentPath = this.getBasicWebModulePath();
        if (webcontentPath == null) {
            return null;
        }
        resources[0] = this.currentProject.getFolder(webcontentPath);
        return resources;
    }

    private OldWebSettings getWebSettings() {
        if (this.fWebSettings == null) {
            this.fWebSettings = new OldWebSettings(this.getProject());
        }
        return this.fWebSettings;
    }

    @Override
    protected IPath getRuntimeType(IResource resource, int type) {
        if (resource.getName().equals("JavaSource")) {
            return new Path("/WEB-INF/classes");
        }
        return new Path("/");
    }

    private String getBasicWebModulePath() {
        OldWebSettings webSettings = this.getWebSettings();
        String name = webSettings.getWebContentName();
        if (name == null) {
            IResource metaFolder = this.findMemberRecursively((IResource)this.getProject(), "WEB-INF");
            if (metaFolder == null) {
                return null;
            }
            name = metaFolder.getParent().getName();
        }
        return name;
    }

    @Override
    protected String getComponentTypeName(String componentName) {
        return "jst.web";
    }

    @Override
    protected String getComponentTypeVersion(String componentName) {
        return J2EEVersionUtil.getServletTextVersion((int)this.getModuleVersion());
    }

    @Override
    protected Property[] getProperties(String componentName) {
        String jspLevel = this.getWebSettings().getJSPLevel();
        String[] featureIDs = this.getWebSettings().getFeatureIds();
        Property[] properties = new Property[featureIDs.length + 1];
        properties[0] = this.createProperty(JSP_LEVEL, jspLevel);
        int i = 1;
        while (i < featureIDs.length + 1) {
            properties[i] = this.createProperty("FeatureID_" + i, featureIDs[i - 1]);
            ++i;
        }
        return properties;
    }

    private String getContextRoot() {
        String contextRootName = this.getWebSettings().getContextRoot();
        return contextRootName;
    }

    @Override
    protected String getDDFileName() {
        return "web.xml";
    }

    @Override
    protected String getDDFolderName() {
        return "WEB-INF";
    }

    private void setServerContextRoot() {
        String contextRoot = this.getContextRoot();
        if (contextRoot != null) {
            J2EEProjectUtilities.setServerContextRoot((IProject)this.currentProject, (String)contextRoot);
        }
    }

    @Override
    protected void postMigrateStrategy(WorkbenchComponent module) {
        this.updateWebProperties(module);
    }

    public List<IFile> getResourcesToChange(IProject project, IProgressMonitor monitor) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        files.add(project.getFile(".project"));
        files.add(project.getFile(".classpath"));
        files.add(project.getFile(StructureEdit.MODULE_META_FILE_NAME));
        files.add(project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml"));
        return files;
    }

    @Override
    protected boolean isConfigFolder(IFolder sourceFolder) {
        return sourceFolder.findMember("WEB-INF/web.xml") != null;
    }
}

