/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.forward.migration;

import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import com.ibm.etools.j2ee.forward.migration.J2EEProjectMigrator;
import com.ibm.etools.j2ee.migration.internal.OldWebSettings;
import com.ibm.etools.j2ee.web.ISimpleWebNatureConstants;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;

public class StaticWebProjectMigrator
extends J2EEProjectMigrator {
    protected OldWebSettings fWebSettings;

    public IMigrationStatus migrate(IProject project, IProgressMonitor monitor) {
        try {
            this.init(project);
            this.doMigration(monitor);
        }
        catch (Exception e) {
            this.reportError(e);
        }
        return new MigrationStatus(this.getStatus());
    }

    @Override
    protected void init(IProject project) {
        super.init(project);
        this.fWebSettings = null;
    }

    @Override
    protected IResource[] getResources(String componentName, int type) {
        IResource[] resources = null;
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                resources = new IFolder[1];
                IFolder webContent = this.currentProject.getFolder(this.getBasicWebModulePath());
                if (webContent == null) break;
                resources[0] = webContent;
            }
        }
        return resources;
    }

    private OldWebSettings getWebSettings() {
        if (this.fWebSettings == null) {
            this.fWebSettings = new OldWebSettings(this.getProject());
        }
        return this.fWebSettings;
    }

    @Override
    protected IPath getRuntimeType(IResource resource, int type) {
        return new Path("/");
    }

    private IPath getBasicWebModulePath() {
        OldWebSettings webSettings = this.getWebSettings();
        String name = webSettings.getWebContentName();
        if (name == null) {
            int version = Integer.parseInt(webSettings.getVersion());
            if (version != -1 && version >= 500) {
                Path oldContentPath;
                Path contentPath = new Path("WebContent");
                if (version == 500 && !this.currentProject.getFolder((IPath)contentPath).exists() && this.currentProject.getFolder((IPath)(oldContentPath = new Path("Web Content"))).exists()) {
                    return oldContentPath;
                }
                return contentPath;
            }
            return ISimpleWebNatureConstants.WEB_MODULE_PATH_V4;
        }
        return new Path(name);
    }

    @Override
    protected String getComponentTypeName(String componentName) {
        return "wst.web";
    }

    @Override
    protected String getComponentTypeVersion(String componentName) {
        return null;
    }

    @Override
    protected Property[] getProperties(String componentName) {
        String[] featureIDs = this.getWebSettings().getFeatureIds();
        Property[] properties = new Property[featureIDs.length];
        int i = 0;
        while (i < featureIDs.length) {
            properties[i] = this.createProperty("FeatureID_" + (i + 1), featureIDs[i]);
            ++i;
        }
        return properties;
    }

    @Override
    protected String getDDFileName() {
        return null;
    }

    @Override
    protected String getDDFolderName() {
        return null;
    }

    public List<IFile> getResourcesToChange(IProject project, IProgressMonitor monitor) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        files.add(project.getFile(".project"));
        files.add(project.getFile(StructureEdit.MODULE_META_FILE_NAME));
        files.add(project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml"));
        return files;
    }

    @Override
    protected boolean isConfigFolder(IFolder sourceFolder) {
        return false;
    }

    @Override
    protected void addJEMNature() {
    }
}

