/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.forward.migration;

import com.ibm.etools.common.migration.framework.AbstractMigration;
import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;

public class LegacyComponentMigrator
extends AbstractMigration {
    private IStatus currentErrorStatus;

    public IMigrationStatus migrate(IProject project, IProgressMonitor monitor) {
        try {
            this.init();
            this.migrateComponentFile(project);
        }
        catch (Exception e) {
            this.reportError(e);
        }
        return new MigrationStatus(this.getStatus());
    }

    private void migrateComponentFile(IProject project) throws Exception {
        IFile componentFile = project.getFile(StructureEdit.MODULE_META_FILE_NAME);
        IFile legacyCompFile = project.getFile(".settings/.component");
        if (!legacyCompFile.exists()) {
            legacyCompFile = project.getFile(".component");
        }
        if (legacyCompFile.exists()) {
            StructureEdit edit = null;
            try {
                edit = StructureEdit.getStructureEditForRead((IProject)project);
                WorkbenchComponent comp = edit.getComponent();
                Resource resource = comp.eResource();
                if (resource.isLoaded()) {
                    ResourceSet aSet = WorkbenchResourceHelperBase.getResourceSet((IProject)project);
                    ArrayList<Resource> resources = new ArrayList<Resource>();
                    resources.add(resource);
                    if (aSet != null) {
                        WorkbenchResourceHelperBase.removeAndUnloadAll(resources, (ResourceSet)aSet);
                    }
                }
                this.saveToIFile(componentFile, legacyCompFile.getContents());
                legacyCompFile.delete(true, null);
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
    }

    private void init() {
        this.currentErrorStatus = null;
    }

    protected void reportError(Exception e) {
        J2EEMigrationPlugin.logError(e);
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        if (this.currentErrorStatus == null) {
            this.currentErrorStatus = J2EEMigrationPlugin.createStatus(4, message, e);
        }
    }

    protected IStatus getStatus() {
        if (this.currentErrorStatus != null) {
            return this.currentErrorStatus;
        }
        return Status.OK_STATUS;
    }

    protected void saveToIFile(IFile iFile, InputStream in) throws Exception {
        this.mkdirs(iFile.getFullPath().removeLastSegments(1), ResourcesPlugin.getWorkspace().getRoot());
        iFile.create(in, true, null);
    }

    protected void mkdirs(IPath path, IWorkspaceRoot root) throws CoreException {
        if (path.segmentCount() <= 1) {
            return;
        }
        IFolder folder = root.getFolder(path);
        if (!folder.exists()) {
            this.mkdirs(path.removeLastSegments(1), root);
            folder.create(true, true, null);
        }
    }

    public List<IFile> getResourcesToChange(IProject project, IProgressMonitor monitor) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        files.add(project.getFile(StructureEdit.MODULE_META_FILE_NAME));
        IFile componentFile = project.getFile(".settings/.component");
        if (componentFile.exists()) {
            files.add(project.getFile(".settings/.component"));
            return files;
        }
        files.add(project.getFile(".component"));
        return files;
    }
}

