/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.forward.migration;

import com.ibm.etools.j2ee.forward.migration.J2EEMigrator;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;

public abstract class J2EEProjectMigrator
extends J2EEMigrator {
    protected static final String MODULE_URI = "module:/resource/";
    protected static final String FEATURE_ID = "FeatureID";
    protected static final String JAVA_SOURCE = "JavaSource";
    protected IResource[] fJavaSourceFolders;

    protected abstract IResource[] getResources(String var1, int var2);

    protected abstract String getComponentTypeName(String var1);

    protected abstract String getDDFileName();

    protected abstract String getDDFolderName();

    protected abstract boolean isConfigFolder(IFolder var1);

    protected void init(IProject project) {
        this.setMigrator(this);
        this.currentProject = project;
        this.currentErrorStatus = null;
        this.resourceTypeMap = new HashMap();
        this.app = null;
        this.aResource = null;
        this.configFolder = null;
    }

    protected IResource[] getJavaSourceResources() {
        IPackageFragmentRoot[] roots = this.getPackageRoots();
        ArrayList<IResource> sourceFolders = new ArrayList<IResource>(roots.length);
        int i = 0;
        while (i < roots.length) {
            try {
                IResource packageResource;
                IResource iResource = packageResource = roots[i].getKind() == 1 ? roots[i].getCorrespondingResource() : null;
                if (packageResource != null && packageResource.getType() == 2 && this.currentProject == packageResource.getProject()) {
                    sourceFolders.add(packageResource);
                }
            }
            catch (JavaModelException e) {
                J2EEMigrationPlugin.logError((CoreException)((Object)e));
            }
            ++i;
        }
        Container[] resources = new Container[sourceFolders.size()];
        sourceFolders.toArray(resources);
        this.fJavaSourceFolders = resources;
        return resources;
    }

    private IPackageFragmentRoot[] getPackageRoots() {
        try {
            return this.getJavaProject().getAllPackageFragmentRoots();
        }
        catch (JavaModelException e) {
            J2EEMigrationPlugin.logError((CoreException)((Object)e));
            return null;
        }
    }

    private IJavaProject getJavaProject() {
        IJavaProject javaProject = JavaCore.create((IProject)this.currentProject);
        return javaProject;
    }

    protected IPath getRuntimeType(IResource resource, int type) {
        return new Path("/");
    }

    protected IProject getProject() {
        return this.currentProject;
    }

    protected String getComponentTypeVersion(String componentName) {
        return J2EEVersionUtil.getJ2EETextVersion((int)this.getModuleVersion());
    }

    protected Property[] getProperties(String componentName) {
        return null;
    }

    protected Property createProperty(String name, String value) {
        Property property = ComponentcoreFactory.eINSTANCE.createProperty();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    protected int getModuleVersion() {
        String location = this.getModuleLocation();
        if (location == null) {
            return 14;
        }
        ModuleFile moduleFile = null;
        try {
            moduleFile = (ModuleFile)CommonarchivePackage.eINSTANCE.getCommonarchiveFactory().openArchive(location);
        }
        catch (OpenFailureException e) {
            J2EEMigrationPlugin.logError(e);
        }
        int version = ArchiveUtil.getFastSpecVersion((ModuleFile)moduleFile);
        return version;
    }

    private String getModuleLocation() {
        Object parent = this.configFolder != null ? this.configFolder : this.getProject();
        IResource ddFile = this.findMemberRecursively((IResource)parent, this.getDDFileName());
        if (ddFile == null) {
            J2EEMigrationPlugin.logError("Cannot find deployment descriptor file in the project: " + this.getProject().getName());
            return null;
        }
        IContainer ddFolder = ddFile.getParent();
        if (!ddFolder.getName().equals(this.getDDFolderName())) {
            J2EEMigrationPlugin.logError("Incorrect deployment descriptor folder name in the project: " + this.getProject().getName());
            return null;
        }
        IContainer moduleFolder = ddFolder.getParent();
        String location = moduleFolder.getLocation().toOSString();
        return location;
    }

    protected boolean hasReferencedComponent(String componentName) {
        return false;
    }

    protected String[] getReferencedComponentNames(String componentName) {
        return null;
    }

    protected DependencyType getDependancyType(String referencedComponentName, String componentName) {
        return null;
    }

    protected IPath getReferencedComponentHandleURI(String referencedComponentName, String componentName) {
        return null;
    }

    protected IPath getReferencedComponentRuntimeType(String referencedComponentName, String componentName) {
        return null;
    }

    protected IResource findMemberRecursively(IResource parent, String resourceName) {
        IResource rtrn = null;
        if (parent.getType() != 1) {
            IResource[] children = null;
            try {
                children = ((IContainer)parent).members();
                int i = 0;
                while (i < children.length) {
                    IResource child = children[i];
                    if (child.getName().equals(resourceName)) {
                        rtrn = child;
                    } else if (child.getType() == 1 || (rtrn = this.findMemberRecursively(child, resourceName)) == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (CoreException e) {
                J2EEMigrationPlugin.logError(e);
            }
        }
        return rtrn;
    }

    protected IResource[] getJavaSourceFolders() {
        return this.fJavaSourceFolders;
    }

    protected void setMigrator(J2EEProjectMigrator projectMigrator) {
        this.projectMigrator = projectMigrator;
    }

    protected void postMigrateStrategy(WorkbenchComponent module) {
    }

    protected boolean isEarProject() {
        return false;
    }

    @Override
    protected IFolder getConfigFolder() {
        IResource[] sourceResource = this.getJavaSourceFolders();
        if (sourceResource != null && sourceResource.length > 0) {
            int i = 0;
            while (i < sourceResource.length) {
                IFolder sourceFolder = this.getProject().getFolder(sourceResource[i].getProjectRelativePath().toString());
                if (this.isConfigFolder(sourceFolder)) {
                    return sourceFolder;
                }
                ++i;
            }
        }
        return null;
    }

    protected void addJEMNature() {
        try {
            WtpUtils.addNatures((IProject)this.currentProject);
        }
        catch (CoreException e) {
            J2EEMigrationPlugin.logError(e);
        }
    }
}

