/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.forward.migration;

import com.ibm.etools.common.migration.framework.AbstractMigration;
import com.ibm.etools.j2ee.forward.migration.FacetMigrator;
import com.ibm.etools.j2ee.forward.migration.J2EEProjectMigrator;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import com.ibm.etools.j2ee.migration.propertytester.UtilityProjectPropertyTester;
import com.ibm.etools.j2ee.migration.validation.ValidationMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.ModuleMappingImpl;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentType;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class J2EEMigrator
extends AbstractMigration {
    public static final String R0_7_MODULE_META_FILE_NAME = ".component";
    public static final String R1_MODULE_META_FILE_NAME = ".settings/.component";
    public static final String MODULE_MAP_URI = "META-INF/.modulemaps";
    public static final String FACET_SETTINGS_FILE_NAME = ".settings/org.eclipse.wst.common.project.facet.core.xml";
    protected static final int SOURCE = 0;
    protected static final int CONTENT = 1;
    protected IProject currentProject;
    protected IStatus currentErrorStatus;
    protected J2EEProjectMigrator projectMigrator;
    protected HashMap resourceTypeMap;
    protected Application app;
    protected IFolder configFolder;
    protected Resource aResource;

    protected abstract IFolder getConfigFolder();

    protected void doMigration(IProgressMonitor monitor) throws Exception {
        IFacetedProject facetedProject;
        this.migrateModuleCoreNature();
        IVirtualComponent virtualComponent = ComponentCore.createComponent((IProject)this.currentProject);
        if (virtualComponent == null) {
            this.reportError(ValidationMessages.J2EEMigrationValidation_component_migration_failed);
            return;
        }
        String configFolderName = null;
        if (this.configFolder != null) {
            configFolderName = this.configFolder.getName();
        }
        FacetMigrator facetMigrate = new FacetMigrator(configFolderName);
        facetMigrate.migrateProject(this.currentProject);
        if (!this.projectMigrator.isEarProject() && this.isJavaProject(this.currentProject)) {
            this.migrateJavaProject();
        }
        if ((facetedProject = ProjectFacetsManager.create((IProject)this.currentProject)) == null) {
            this.reportError(ValidationMessages.J2EEMigrationValidation_facet_migration_failed);
        }
        this.unloadResources();
    }

    private void migrateJavaProject() {
        IClasspathEntry[] existingClasspath = null;
        IJavaProject javaProject = JavaCore.create((IProject)this.currentProject);
        if (javaProject != null) {
            try {
                existingClasspath = javaProject.getRawClasspath();
            }
            catch (JavaModelException e) {
                J2EEMigrationPlugin.logError((CoreException)((Object)e));
            }
        }
        if (existingClasspath != null) {
            int i = 0;
            while (i < existingClasspath.length) {
                IClasspathEntry classpathEntry = existingClasspath[i];
                if (classpathEntry.getEntryKind() == 1) {
                    IPath path = classpathEntry.getPath();
                    IPath relativePath = new Path(path.lastSegment()).makeAbsolute();
                    if (this.currentProject.getFolder(path.lastSegment()).exists()) {
                        IVirtualFolder f = null;
                        if (J2EEProjectUtilities.isDynamicWebProject((IProject)this.currentProject)) {
                            IPath webInfClasses = new Path("WEB-INF/classes").makeAbsolute();
                            f = ComponentCore.createFolder((IProject)this.currentProject, (IPath)webInfClasses);
                        } else {
                            f = ComponentCore.createFolder((IProject)this.currentProject, (IPath)Path.ROOT);
                        }
                        try {
                            f.createLink(relativePath, 0, null);
                        }
                        catch (CoreException e) {
                            J2EEMigrationPlugin.logError(e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void migrateModuleCoreNature() {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.currentProject);
        if (nature == null) {
            ModuleCoreNature.addModuleCoreNatureIfNecessary((IProject)this.currentProject, (IProgressMonitor)new NullProgressMonitor());
        }
        this.projectMigrator.addJEMNature();
        StructureEdit moduleCore = null;
        ComponentType componentType = null;
        WorkbenchComponent module = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.currentProject);
            String componentName = this.currentProject.getName();
            moduleCore.getModuleStructuralModel().setUseOldFormat(true);
            module = moduleCore.getComponent();
            if (module == null) {
                module = moduleCore.createWorkbenchModule(componentName);
            }
            IResource[] sourceResource = this.projectMigrator.getResources(componentName, 0);
            IResource[] contentResource = this.projectMigrator.getResources(componentName, 1);
            this.configFolder = this.getConfigFolder();
            componentType = this.getModuleType(moduleCore, this.projectMigrator, componentName);
            if (componentType != null && !componentType.equals("")) {
                module.setComponentType(componentType);
            }
            this.createComponentResources(this.projectMigrator, module, sourceResource, contentResource);
            if (this.projectMigrator.hasReferencedComponent(componentName)) {
                this.createReferencedComponents(this.projectMigrator, componentName, module);
            }
            this.projectMigrator.postMigrateStrategy(module);
        }
        finally {
            if (moduleCore != null) {
                moduleCore.save(null);
                moduleCore.getModuleStructuralModel().setUseOldFormat(false);
                moduleCore.dispose();
            }
        }
    }

    private boolean isJavaProject(IProject proj) {
        try {
            return proj.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void createReferencedComponents(J2EEProjectMigrator aProjectMigrator, String componentName, WorkbenchComponent module) {
        String[] referencedComponentNames = aProjectMigrator.getReferencedComponentNames(componentName);
        int i = 0;
        while (i < referencedComponentNames.length) {
            ReferencedComponent refComponent = ComponentcoreFactory.eINSTANCE.createReferencedComponent();
            IPath handlePath = aProjectMigrator.getReferencedComponentHandleURI(referencedComponentNames[i], componentName);
            URI handleURI = URI.createURI((String)handlePath.toString());
            refComponent.setHandle(handleURI);
            DependencyType type = aProjectMigrator.getDependancyType(referencedComponentNames[i], componentName);
            refComponent.setDependencyType(type);
            IPath runtimePath = aProjectMigrator.getReferencedComponentRuntimeType(referencedComponentNames[i], componentName);
            refComponent.setRuntimePath(runtimePath);
            if (aProjectMigrator.isEarProject()) {
                UtilityProjectPropertyTester.EarProjectModules moduleMap;
                HashMap map;
                boolean isClassPathURI;
                String refComponentProjectName = "";
                if (handleURI != null && !(isClassPathURI = ModuleURIUtil.isClassPathURI((URI)handleURI))) {
                    refComponentProjectName = handleURI.segment(1);
                }
                if (refComponentProjectName != null && refComponentProjectName != "" && (map = J2EEMigrationPlugin.getDefault().getModuleMaps()) != null && (moduleMap = (UtilityProjectPropertyTester.EarProjectModules)map.get(this.currentProject)) != null) {
                    Set modules = moduleMap.getModuleProjects().keySet();
                    Set utilities = moduleMap.getUtilityProjects().keySet();
                    if (modules.contains(refComponentProjectName)) {
                        Module moduleURI = ((ModuleMappingImpl)moduleMap.getModuleProjects().get(refComponentProjectName)).getModule();
                        Application application = this.getApplication();
                        if (application != null) {
                            Module existingModule = application.getFirstModule(moduleURI.getUri());
                            refComponent.setDependentObject((EObject)existingModule);
                        }
                    } else if (utilities.contains(refComponentProjectName)) {
                        String jarURI = (String)moduleMap.getUtilityProjects().get(refComponentProjectName);
                        refComponent.setArchiveName(jarURI);
                    }
                }
            }
            module.getReferencedComponents().add((Object)refComponent);
            ++i;
        }
    }

    private Application getApplication() {
        if (this.app == null) {
            Resource resource;
            IFile file = this.currentProject.getFile("META-INF/application.xml");
            this.aResource = resource = WorkbenchResourceHelperBase.getResource((IFile)file, (boolean)true);
            if (resource != null && resource.getContents() != null && resource.getContents().size() > 0) {
                this.app = (Application)resource.getContents().get(0);
            }
        }
        return this.app;
    }

    private void unloadResources() {
        if (this.aResource != null) {
            ResourceSet aSet = WorkbenchResourceHelperBase.getResourceSet((IProject)this.currentProject);
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.add(this.aResource);
            if (aSet != null) {
                WorkbenchResourceHelperBase.removeAndUnloadAll(resources, (ResourceSet)aSet);
            }
        }
    }

    private void createComponentResources(J2EEProjectMigrator aProjectMigrator, WorkbenchComponent module, IResource[] sourceResource, IResource[] contentResource) {
        IResource[] deltaResources = this.addResources(sourceResource, contentResource);
        if (sourceResource != null && sourceResource.length > 0) {
            this.populateResourceTypes(sourceResource, 0);
        }
        if (contentResource != null && contentResource.length > 0) {
            this.populateResourceTypes(contentResource, 1);
        }
        if (deltaResources != null && deltaResources.length > 0) {
            int i = 0;
            while (i < deltaResources.length) {
                boolean foundRes = false;
                IResource deltaRes = deltaResources[i];
                if (deltaRes != null) {
                    ComponentResource componentResource = this.createWorkbenchModuleResource(deltaRes);
                    IPath path = aProjectMigrator.getRuntimeType(deltaRes, this.getResourceType(deltaResources[i]));
                    componentResource.setRuntimePath(path);
                    ComponentResource[] resources = module.findResourcesByRuntimePath(path);
                    int j = 0;
                    while (j < resources.length) {
                        ComponentResource resource = resources[j];
                        if (resource.getSourcePath().equals((Object)componentResource.getSourcePath())) {
                            foundRes = true;
                        }
                        ++j;
                    }
                    if (!foundRes) {
                        module.getResources().add((Object)componentResource);
                    }
                }
                ++i;
            }
        }
    }

    private int getResourceType(IResource resource) {
        Integer integer = (Integer)this.resourceTypeMap.get(resource);
        return integer;
    }

    private void populateResourceTypes(IResource[] resources, int type) {
        int i = 0;
        while (i < resources.length) {
            this.resourceTypeMap.put(resources[i], new Integer(type));
            ++i;
        }
    }

    private IResource[] addResources(IResource[] aResource, IResource[] bResource) {
        if (aResource == null && bResource == null) {
            return null;
        }
        if (aResource == null) {
            return bResource;
        }
        if (bResource == null) {
            return aResource;
        }
        IResource[] resources = new IResource[aResource.length + bResource.length];
        System.arraycopy(aResource, 0, resources, 0, aResource.length);
        System.arraycopy(bResource, 0, resources, aResource.length, bResource.length);
        return resources;
    }

    private ComponentType getModuleType(StructureEdit anEditFacade, J2EEProjectMigrator aProjectMigrator, String componentName) {
        String componentModuleID = aProjectMigrator.getComponentTypeName(componentName);
        if (componentModuleID == null) {
            return null;
        }
        String componentVersion = aProjectMigrator.getComponentTypeVersion(componentName);
        Property[] componentProperites = aProjectMigrator.getProperties(componentName);
        ComponentType componentType = anEditFacade.createModuleType(componentModuleID);
        if (componentVersion != null) {
            componentType.setVersion(componentVersion);
        }
        if (componentProperites != null) {
            componentType.getProperties().addAll(Arrays.asList(componentProperites));
        }
        return componentType;
    }

    private ComponentResource createWorkbenchModuleResource(IResource aResource) {
        ComponentResource moduleResource = ComponentcorePackage.eINSTANCE.getComponentcoreFactory().createComponentResource();
        String sourcePath = String.valueOf('/') + aResource.getProjectRelativePath().toString();
        moduleResource.setSourcePath((IPath)new Path(sourcePath));
        return moduleResource;
    }

    protected void reportError(String message) {
        if (this.currentErrorStatus == null) {
            this.currentErrorStatus = J2EEMigrationPlugin.createStatus(4, message);
        }
    }

    protected void reportError(Exception e) {
        J2EEMigrationPlugin.logError(e);
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        if (this.currentErrorStatus == null) {
            this.currentErrorStatus = J2EEMigrationPlugin.createStatus(4, message, e);
        }
    }

    protected IStatus getStatus() {
        if (this.currentErrorStatus != null) {
            return this.currentErrorStatus;
        }
        return Status.OK_STATUS;
    }
}

