/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.forward.migration;

import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.common.project.facet.JavaFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.earcreation.EarFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.jca.project.facet.ConnectorFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.AppClientFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.UtilityFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetInstallDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.ComponentType;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.project.facet.SimpleWebFacetInstallDataModelProvider;

public class FacetMigrator {
    private IProject project;
    private String fConfigFolder;

    public FacetMigrator(String configFolder) {
        this.fConfigFolder = configFolder;
    }

    public void migrateProject(IProject aProject) {
        if (aProject.isAccessible() && aProject.getFile(StructureEdit.MODULE_META_FILE_NAME).exists()) {
            this.project = aProject;
            this.addFacets(this.project);
            J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.project);
        }
    }

    protected IDataModel setupJavaInstallAction(IProject aProject) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new JavaFacetInstallDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        String jVersion = "1.4";
        ProjectScope context = new ProjectScope(this.project);
        IEclipsePreferences prefs = context.getNode("org.eclipse.jdt.core");
        if ("1.5".equals(prefs.get("org.eclipse.jdt.core.compiler.compliance", "1.4"))) {
            jVersion = "5.0";
        }
        dm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)jVersion);
        return dm;
    }

    protected IDataModel setupUtilInstallAction(IProject aProject, String specVersion) {
        IDataModel aFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new UtilityFacetInstallDataModelProvider());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)specVersion);
        aFacetInstallDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        aFacetInstallDataModel.setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", null);
        return aFacetInstallDataModel;
    }

    protected IDataModel setupEarInstallAction(IProject aProject, String specVersion) {
        IDataModel earFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EarFacetInstallDataModelProvider());
        earFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        earFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)specVersion);
        return earFacetInstallDataModel;
    }

    protected IDataModel setupAppClientInstallAction(IProject aProject, String specVersion) {
        IDataModel aFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new AppClientFacetInstallDataModelProvider());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)specVersion);
        aFacetInstallDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        aFacetInstallDataModel.setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", null);
        aFacetInstallDataModel.setBooleanProperty("IAppClientComponentCreationDataModelProperties.CREATE_DEFAULT_MAIN_CLASS", false);
        return aFacetInstallDataModel;
    }

    protected IDataModel setupConnectorInstallAction(IProject aProject, String specVersion) {
        IDataModel aFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorFacetInstallDataModelProvider());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)specVersion);
        aFacetInstallDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        aFacetInstallDataModel.setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", null);
        return aFacetInstallDataModel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFacets(IProject aProject) {
        StructureEdit edit = null;
        try {
            edit = StructureEdit.getStructureEditForWrite((IProject)aProject);
            if (edit == null) {
                return;
            }
            edit.getModuleStructuralModel().setUseOldFormat(true);
            if (edit.getComponent() == null) {
                return;
            }
            ComponentType type = edit.getComponent().getComponentType();
            if (type == null) {
                return;
            }
            String compId = type.getComponentTypeId();
            String specVersion = edit.getComponent().getComponentType().getVersion();
            this.moveMetaProperties(edit.getComponent(), type);
            this.addFacetsToProject(aProject, compId, specVersion);
            return;
        }
        finally {
            if (edit != null) {
                edit.save(null);
                edit.getModuleStructuralModel().setUseOldFormat(false);
                edit.dispose();
            }
        }
    }

    private void moveMetaProperties(WorkbenchComponent component, ComponentType type) {
        EList props = type.getProperties();
        EList compProps = component.getProperties();
        for (Property element : props) {
            Property newProp = ComponentcoreFactory.eINSTANCE.createProperty();
            newProp.setName(element.getName());
            newProp.setValue(element.getValue());
            compProps.add(newProp);
        }
        props.clear();
    }

    private void addFacetsToProject(IProject aProject, String compId, String specVersion) {
        if (compId.equals("jst.web")) {
            this.installWEBFacets(aProject, specVersion);
        } else if (compId.equals("jst.ejb")) {
            this.installEJBFacets(aProject, specVersion);
        } else if (compId.equals("jst.appclient")) {
            this.installAppClientFacets(aProject, specVersion);
        } else if (compId.equals("jst.ear")) {
            this.installEARFacets(aProject, specVersion);
        } else if (compId.equals("jst.connector")) {
            this.installConnectorFacets(aProject, specVersion);
        } else if (compId.equals("jst.utility")) {
            this.installUtilityFacets(aProject, specVersion);
        } else if (compId.equals("wst.web")) {
            this.installStaticWebFacets(aProject, specVersion);
        }
    }

    private void installStaticWebFacets(IProject project, String specVersion) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel newModel = this.setupStaticWebInstallAction(project);
        this.migrateFacets(dm, facetDMs, newModel);
    }

    private IDataModel setupStaticWebInstallAction(IProject project) {
        IDataModel webFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new SimpleWebFacetInstallDataModelProvider());
        webFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
        webFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)"1.0");
        return webFacetInstallDataModel;
    }

    private void installUtilityFacets(IProject aProject, String specVersion) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        facetDMs.add(this.setupJavaInstallAction(aProject));
        IDataModel newModel = this.setupUtilInstallAction(aProject, specVersion);
        this.migrateFacets(dm, facetDMs, newModel);
    }

    private void installConnectorFacets(IProject aProject, String specVersion) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        facetDMs.add(this.setupJavaInstallAction(aProject));
        IDataModel newModel = this.setupConnectorInstallAction(aProject, specVersion);
        this.migrateFacets(dm, facetDMs, newModel);
    }

    private void migrateFacets(IDataModel dm, IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs, IDataModel newModel) {
        if (this.fConfigFolder != null) {
            newModel.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)this.fConfigFolder);
        }
        facetDMs.add(newModel);
        try {
            dm.getDefaultOperation().execute(null, null);
        }
        catch (ExecutionException e) {
            J2EEMigrationPlugin.logError(e);
        }
    }

    private void installEARFacets(IProject aProject, String specVersion) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel newModel = this.setupEarInstallAction(aProject, specVersion);
        this.migrateFacets(dm, facetDMs, newModel);
    }

    private void installAppClientFacets(IProject aProject, String specVersion) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        facetDMs.add(this.setupJavaInstallAction(aProject));
        IDataModel newModel = this.setupAppClientInstallAction(aProject, specVersion);
        this.migrateFacets(dm, facetDMs, newModel);
    }

    private void installEJBFacets(IProject ejbProject, String ejbVersion) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)ejbProject.getName());
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        facetDMs.add(this.setupJavaInstallAction(ejbProject));
        IDataModel newModel = this.setupEjbInstallAction(ejbProject, ejbVersion);
        this.migrateFacets(dm, facetDMs, newModel);
    }

    private void installWEBFacets(IProject webProj, String specVersion) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)webProj.getName());
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        facetDMs.add(this.setupJavaInstallAction(webProj));
        IDataModel newModel = this.setupWebInstallAction(webProj, specVersion);
        this.migrateFacets(dm, facetDMs, newModel);
    }

    protected IDataModel setupEjbInstallAction(IProject aProject, String ejbVersion) {
        IDataModel ejbFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetInstallDataModelProvider());
        ejbFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        ejbFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)ejbVersion);
        ejbFacetInstallDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        ejbFacetInstallDataModel.setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", null);
        return ejbFacetInstallDataModel;
    }

    protected IDataModel setupWebInstallAction(IProject aProject, String specVersion) {
        IDataModel webFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetInstallDataModelProvider());
        webFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        webFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)specVersion);
        webFacetInstallDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        webFacetInstallDataModel.setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", null);
        return webFacetInstallDataModel;
    }
}

