/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.forward.migration;

import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import com.ibm.etools.j2ee.forward.migration.J2EEProjectMigrator;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import com.ibm.etools.j2ee.migration.propertytester.UtilityProjectPropertyTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;

public class EJBProjectMigrator
extends J2EEProjectMigrator {
    private EJBJar jar;
    private String clientJarProject;
    private List utilityProjects;

    public IMigrationStatus migrate(IProject project, IProgressMonitor monitor) {
        try {
            this.init(project);
            this.doMigration(monitor);
        }
        catch (Exception e) {
            this.reportError(e);
        }
        return new MigrationStatus(this.getStatus());
    }

    @Override
    protected void init(IProject project) {
        super.init(project);
        this.jar = null;
        this.clientJarProject = null;
        this.utilityProjects = new ArrayList();
    }

    @Override
    protected IResource[] getResources(String componentName, int type) {
        IResource[] resources = null;
        switch (type) {
            case 0: {
                resources = this.getJavaSourceResources();
                break;
            }
        }
        return resources;
    }

    private String[] getUtilityProjectNames() {
        return this.utilityProjects.toArray(new String[this.utilityProjects.size()]);
    }

    private void findClientUtilityProjects() {
        this.clientJarProject = "";
        String projectName = this.getProject().getName();
        String eJBClientName = this.getEJBJar().getEjbClientJar();
        HashMap map = J2EEMigrationPlugin.getDefault().getModuleMaps();
        if (map == null) {
            return;
        }
        Collection col = map.values();
        for (UtilityProjectPropertyTester.EarProjectModules projectMap : col) {
            if (!projectMap.getModuleProjects().keySet().contains(projectName)) continue;
            Set utilities = projectMap.getUtilityProjects().keySet();
            for (String utilityProject : utilities) {
                String uri = (String)projectMap.getUtilityProjects().get(utilityProject);
                if (!uri.toLowerCase().equals(eJBClientName.toLowerCase())) continue;
                this.clientJarProject = utilityProject;
                this.utilityProjects.add(this.clientJarProject);
                return;
            }
        }
    }

    @Override
    protected void postMigrateStrategy(WorkbenchComponent module) {
        this.updateEJBClientProperties(module);
    }

    private void updateEJBClientProperties(WorkbenchComponent module) {
        String ejbClientJarUri;
        if (this.hasEJBClientJar() && (ejbClientJarUri = this.getEjbClientJarURI()) != null) {
            String clientProjName = this.getClientJarProject();
            Property prop = ComponentcoreFactory.eINSTANCE.createProperty();
            prop.setName("ClientProject");
            prop.setValue(clientProjName);
            module.getProperties().add((Object)prop);
            prop = ComponentcoreFactory.eINSTANCE.createProperty();
            prop.setName("ClientJARURI");
            prop.setValue(ejbClientJarUri);
            module.getProperties().add((Object)prop);
        }
    }

    private boolean hasEJBClientJar() {
        this.jar = this.getEJBJar();
        return this.jar != null && this.jar.getEjbClientJar() != null;
    }

    private EJBJar getEJBJar() {
        if (this.jar == null) {
            Resource resource;
            IFile file = this.getEJBDeploymentDescriptor();
            this.aResource = resource = WorkbenchResourceHelperBase.getResource((IFile)file, (boolean)true);
            if (resource != null && resource.getContents() != null && resource.getContents().size() > 0) {
                this.jar = (EJBJar)resource.getContents().get(0);
            }
        }
        return this.jar;
    }

    private IFile getEJBDeploymentDescriptor() {
        IResource[] sourceResource = this.getJavaSourceFolders();
        if (sourceResource != null && sourceResource.length > 0) {
            int i = 0;
            while (i < sourceResource.length) {
                IFolder sourceFolder = this.getProject().getFolder(sourceResource[i].getProjectRelativePath().toString());
                IFile file = sourceFolder.getFile("META-INF/ejb-jar.xml");
                if (file.exists()) {
                    return file;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    protected String getComponentTypeName(String componentName) {
        return "jst.ejb";
    }

    @Override
    protected String getComponentTypeVersion(String componentName) {
        return J2EEVersionUtil.getEJBTextVersion((int)this.getModuleVersion());
    }

    private String getClientJarProject() {
        if (this.clientJarProject == null) {
            this.findClientUtilityProjects();
        }
        return this.clientJarProject;
    }

    @Override
    protected boolean hasReferencedComponent(String componentName) {
        boolean hasClientJar = this.hasEJBClientJar();
        if (!hasClientJar) {
            return false;
        }
        boolean isClientJarProject = !this.currentProject.getName().equals(this.getClientJarProject());
        return isClientJarProject;
    }

    @Override
    protected String[] getReferencedComponentNames(String componentName) {
        return this.getUtilityProjectNames();
    }

    @Override
    protected DependencyType getDependancyType(String referencedComponentName, String componentName) {
        return DependencyType.USES_LITERAL;
    }

    @Override
    protected IPath getReferencedComponentHandleURI(String referencedComponentName, String componentName) {
        return new Path("module:/resource/" + referencedComponentName + "/" + referencedComponentName);
    }

    @Override
    protected IPath getReferencedComponentRuntimeType(String referencedComponentName, String componentName) {
        return new Path("/");
    }

    @Override
    protected String getDDFileName() {
        return "ejb-jar.xml";
    }

    @Override
    protected String getDDFolderName() {
        return "META-INF";
    }

    private String getEjbClientJarURI() {
        return this.getEJBJar().getEjbClientJar();
    }

    public List<IFile> getResourcesToChange(IProject project, IProgressMonitor monitor) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        files.add(project.getFile(".project"));
        files.add(project.getFile(".classpath"));
        files.add(project.getFile(StructureEdit.MODULE_META_FILE_NAME));
        files.add(project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml"));
        return files;
    }

    @Override
    protected boolean isConfigFolder(IFolder sourceFolder) {
        return sourceFolder.findMember("META-INF/ejb-jar.xml") != null;
    }
}

