/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.forward.migration;

import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import com.ibm.etools.j2ee.forward.migration.J2EEProjectMigrator;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import com.ibm.etools.j2ee.migration.propertytester.UtilityProjectPropertyTester;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class EARProjectMigrator
extends J2EEProjectMigrator {
    public static final String NATURE_ID = "com.ibm.wtp.j2ee.EARNature";
    public static final String NATURE_ID_512 = "com.ibm.etools.j2ee.EARNature";
    public static final String EAR_NATURE_13 = "com.ibm.etools.j2ee.EAR13Nature";
    public static final String EAR_NATURE_14 = "org.eclipse.jst.j2ee.EARNature";

    public IMigrationStatus migrate(IProject project, IProgressMonitor monitor) {
        try {
            this.init(project);
            this.doMigration(monitor);
            this.migrateEARProject();
        }
        catch (Exception e) {
            this.reportError(e);
        }
        return new MigrationStatus(this.getStatus());
    }

    @Override
    protected IResource[] getResources(String componentName, int type) {
        IResource[] resources = null;
        switch (type) {
            case 0: {
                resources = new IResource[]{this.currentProject};
                break;
            }
        }
        return resources;
    }

    @Override
    protected String getComponentTypeName(String componentName) {
        return "jst.ear";
    }

    @Override
    protected boolean hasReferencedComponent(String componentName) {
        return true;
    }

    @Override
    protected String[] getReferencedComponentNames(String componentName) {
        HashSet projects = new HashSet();
        projects.addAll(this.getModuleProjects());
        projects.addAll(this.getUtilityProjects());
        return projects.toArray(new String[projects.size()]);
    }

    @Override
    protected DependencyType getDependancyType(String referencedComponentName, String componentName) {
        return DependencyType.USES_LITERAL;
    }

    @Override
    protected IPath getReferencedComponentHandleURI(String referencedComponentName, String componentName) {
        return new Path("module:/resource/" + referencedComponentName + "/" + referencedComponentName);
    }

    @Override
    protected IPath getReferencedComponentRuntimeType(String referencedComponentName, String componentName) {
        return new Path("/");
    }

    public void migrateEARProject() {
        String EAR_CONTENT = "EarContent";
        IFolder earContentFolder = (IFolder)this.currentProject.findMember(EAR_CONTENT);
        if (earContentFolder != null && earContentFolder.exists() && earContentFolder.findMember("META-INF") == null) {
            IVirtualComponent earComp = ComponentCore.createComponent((IProject)this.currentProject);
            IVirtualFolder rootFolder = earComp.getRootFolder();
            Path compPath = new Path(EAR_CONTENT);
            try {
                rootFolder.removeLink((IPath)compPath, 256, (IProgressMonitor)new NullProgressMonitor());
                earContentFolder.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                J2EEMigrationPlugin.logError(e);
            }
        }
    }

    protected List getModuleProjects() {
        UtilityProjectPropertyTester.EarProjectModules projectMap;
        ArrayList moduleProjects = new ArrayList();
        HashMap map = J2EEMigrationPlugin.getDefault().getModuleMaps();
        if (map != null && (projectMap = (UtilityProjectPropertyTester.EarProjectModules)map.get(this.currentProject)) != null) {
            moduleProjects.addAll(projectMap.getModuleProjects().keySet());
        }
        return moduleProjects;
    }

    protected List getUtilityProjects() {
        UtilityProjectPropertyTester.EarProjectModules projectMap;
        ArrayList utilityProjects = new ArrayList();
        HashMap map = J2EEMigrationPlugin.getDefault().getModuleMaps();
        if (map != null && (projectMap = (UtilityProjectPropertyTester.EarProjectModules)map.get(this.currentProject)) != null) {
            utilityProjects.addAll(projectMap.getUtilityProjects().keySet());
        }
        return utilityProjects;
    }

    @Override
    protected String getDDFileName() {
        return "application.xml";
    }

    @Override
    protected String getDDFolderName() {
        return "META-INF";
    }

    @Override
    protected boolean isEarProject() {
        return true;
    }

    public List<IFile> getResourcesToChange(IProject project, IProgressMonitor monitor) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        files.add(project.getFile(".project"));
        files.add(project.getFile(StructureEdit.MODULE_META_FILE_NAME));
        files.add(project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml"));
        return files;
    }

    @Override
    protected boolean isConfigFolder(IFolder sourceFolder) {
        return sourceFolder.findMember("META-INF/application.xml") != null;
    }

    @Override
    protected void addJEMNature() {
    }
}

