/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.forward.migration;

import com.ibm.etools.common.migration.framework.AbstractMigration;
import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import com.ibm.etools.j2ee.migration.plugin.J2EEMigrationPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BuilderSpecMigrator
extends AbstractMigration {
    private static final String OLD_BUILDER_SPEC = "com.ibm.etools.j2ee.LibCopyBuilder";
    private static final String NEW_BUILDER_SPEC = "org.eclipse.jst.j2ee.LibCopyBuilder";
    private IStatus currentErrorStatus;

    public IMigrationStatus migrate(IProject project, IProgressMonitor monitor) {
        try {
            this.init();
            this.migrateBuilderSpec(project);
        }
        catch (Exception e) {
            this.reportError(e);
        }
        return new MigrationStatus(this.getStatus());
    }

    private void init() {
        this.currentErrorStatus = null;
    }

    private void migrateBuilderSpec(IProject project) throws Exception {
        IProjectDescription description = project.getDescription();
        ICommand[] builderCommands = description.getBuildSpec();
        ArrayList<ICommand> result = new ArrayList<ICommand>();
        boolean alreadyPresent = false;
        int i = 0;
        while (i < builderCommands.length) {
            ICommand builder = builderCommands[i];
            boolean reject = false;
            if (builder.getBuilderName().equals(OLD_BUILDER_SPEC)) {
                reject = true;
            } else if (builder.getBuilderName().equals(NEW_BUILDER_SPEC)) {
                alreadyPresent = true;
            }
            if (!reject) {
                result.add(builder);
            }
            ++i;
        }
        if (!alreadyPresent) {
            ICommand newBuilder = description.newCommand();
            newBuilder.setBuilderName(NEW_BUILDER_SPEC);
            result.add(newBuilder);
        }
        ICommand[] resultantBuilders = result.toArray(new ICommand[result.size()]);
        description.setBuildSpec(resultantBuilders);
        project.setDescription(description, null);
    }

    protected void reportError(Exception e) {
        J2EEMigrationPlugin.logError(e);
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        if (this.currentErrorStatus == null) {
            this.currentErrorStatus = J2EEMigrationPlugin.createStatus(4, message, e);
        }
    }

    protected IStatus getStatus() {
        if (this.currentErrorStatus != null) {
            return this.currentErrorStatus;
        }
        return Status.OK_STATUS;
    }

    public List<IFile> getResourcesToChange(IProject project, IProgressMonitor monitor) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        files.add(project.getFile(".project"));
        return files;
    }
}

