/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.ui.internal.actions;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.ui.internal.actions.IJ2EEMigrationConstants;
import com.ibm.etools.j2ee.migration.ui.internal.plugin.MigrationUIPlugin;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jst.j2ee.internal.J2EEStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MigrationStatusDialog
extends Dialog
implements IJ2EEMigrationConstants {
    private static final int LIST_ITEM_COUNT = 7;
    private Button detailsButton;
    private String title;
    private String message;
    private Text text;
    private boolean textCreated = false;
    private J2EEStatus status;
    private List statusList;

    public MigrationStatusDialog(Shell parentShell, String dialogTitle, String message, J2EEStatus status) {
        super(parentShell);
        this.status = status;
        this.setTitleOrDefault(dialogTitle);
        this.setMessageOrDefault(message);
        this.statusList = Arrays.asList(status.getChildren());
        this.setShellStyle(67696);
    }

    protected void setTitleOrDefault(String dialogTitle) {
        if (dialogTitle != null) {
            this.title = dialogTitle;
        } else {
            switch (this.status.getSeverity()) {
                case 4: {
                    this.title = J2EEMigrationUIResourceHandler.MIGRATION_ERRORS;
                    break;
                }
                default: {
                    this.title = J2EEMigrationUIResourceHandler.MIGRATION_COMPLETE;
                }
            }
        }
    }

    protected void setMessageOrDefault(String dialogMessage) {
        if (dialogMessage != null) {
            this.message = dialogMessage;
        } else if (this.status.getMessage() != null) {
            this.message = this.status.getMessage();
        } else {
            switch (this.status.getSeverity()) {
                case 4: {
                    this.message = J2EEMigrationUIResourceHandler.MIGRATION_ERRORS_REPORT_UI_;
                    break;
                }
                case 3: {
                    this.message = J2EEMigrationUIResourceHandler.MIGRATION_WARNINGS_REPORT_UI_;
                    break;
                }
                case 1: {
                    this.message = J2EEMigrationUIResourceHandler.MIGRATION_NOT_NEEDED_REPORT;
                    break;
                }
                case 2: {
                    this.message = J2EEMigrationUIResourceHandler.MIGRATION_NOT_POSSIBLE_REPORT;
                }
                default: {
                    this.message = J2EEMigrationUIResourceHandler.MIGRATION_SUCCESS_REPORT_UI_;
                }
            }
        }
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            this.logStatus();
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.status.isMultiStatus()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected int getImageKey() {
        switch (this.status.getSeverity()) {
            case 4: {
                return 1;
            }
            case 3: {
                return 8;
            }
        }
        return 2;
    }

    protected Control createDialogArea(Composite parent) {
        Label label;
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Image image = composite.getDisplay().getSystemImage(this.getImageKey());
        if (image != null) {
            label = new Label(composite, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
        }
        if (this.message != null) {
            label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        return composite;
    }

    protected Text createDropDownText(Composite parent) {
        this.text = new Text(parent, 2818);
        this.populateText(this.text);
        GridData data = new GridData(1808);
        data.heightHint = this.text.getLineHeight() * 7;
        this.text.setLayoutData((Object)data);
        this.textCreated = true;
        return this.text;
    }

    public static int openDialog(Shell parentShell, String title, String message, J2EEStatus status) {
        MigrationStatusDialog dialog = new MigrationStatusDialog(parentShell, title, message, status);
        return dialog.open();
    }

    private void logStatus() {
        Iterator aenum = this.statusList.iterator();
        StringBuffer sb = new StringBuffer();
        sb.append(this.message);
        while (aenum.hasNext()) {
            J2EEStatus childStatus = (J2EEStatus)aenum.next();
            this.populateText(sb, childStatus, 0);
        }
        MigrationUIPlugin.logInfo(sb.toString());
    }

    private void populateText(Text localText) {
        Iterator aenum = this.statusList.iterator();
        StringBuffer sb = new StringBuffer();
        while (aenum.hasNext()) {
            J2EEStatus childStatus = (J2EEStatus)aenum.next();
            this.populateText(sb, childStatus, 0);
        }
        localText.setText(sb.toString());
    }

    private void populateText(StringBuffer sb, J2EEStatus aStatus, int nesting) {
        int i = 0;
        while (i < nesting) {
            sb.append("  ");
            ++i;
        }
        sb.append(aStatus.getMessageForDisplay());
        sb.append('\n');
        J2EEStatus[] children = aStatus.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            this.populateText(sb, children[i2], nesting + 1);
            ++i2;
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getContents().computeSize(-1, -1);
        if (this.textCreated) {
            this.text.dispose();
            this.textCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.text = this.createDropDownText((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }
}

