/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.ui.internal.actions;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationHelper;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.ui.internal.actions.IJ2EEMigrationConstants;
import com.ibm.etools.j2ee.migration.ui.internal.actions.J2EEMigrationWizard;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.common.internal.util.CommonUtil;
import org.eclipse.jst.j2ee.internal.actions.AbstractActionDelegate;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.ui.util.BinaryProjectUIHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class MigrateJ2EEActionDelgate
extends AbstractActionDelegate
implements IJ2EEMigrationConstants {
    private String j2eeVersion = "1.2";
    private boolean validJ2EEVersion = true;

    public MigrateJ2EEActionDelgate() {
        this.setAllowsMultiSelect(true);
    }

    protected boolean isSupportedAction(Object element) {
        return CommonUtil.isDeploymentDescriptorRoot((Object)element, (boolean)true);
    }

    protected void primRun(Shell shell) {
        List projects = this.getProjects();
        if (!this.ensureSingleSelectionNotBinary(shell, projects)) {
            return;
        }
        if (!this.checkNoEditorsOpen(shell)) {
            return;
        }
        if (!this.validateSelection(shell, projects)) {
            return;
        }
        this.openWizard(shell, projects);
    }

    private boolean ensureSingleSelectionNotBinary(Shell shell, List projects) {
        if (projects.size() != 1) {
            if (J2EEProjectUtilities.getJ2EEProjectType((IProject)((IProject)projects.get(0))).equals("jst.ear")) {
                return true;
            }
            return !BinaryProjectUIHelper.displayErrorIfBinaryProject((Shell)shell, (IProject)((IProject)projects.get(0)));
        }
        return true;
    }

    private boolean validateSelection(Shell shell, List projects) {
        boolean validSelection = true;
        this.validJ2EEVersion = true;
        if (!this.isValidSelection(projects)) {
            this.informInvalidSelection(shell);
            validSelection = false;
        } else if (!this.validJ2EEVersion) {
            this.informInvalidVersionSelection(shell);
            validSelection = false;
        }
        return validSelection;
    }

    private void informInvalidVersionSelection(Shell shell) {
        MessageDialog.openInformation((Shell)shell, (String)J2EEMigrationUIResourceHandler.INVALID_SELECTION_TITLE, (String)J2EEMigrationUIResourceHandler.INFORM_INVALID_J2EE_SELECTION);
    }

    private boolean isValidSelection(List projects) {
        boolean isValid = true;
        if (projects.isEmpty()) {
            return false;
        }
        int size = projects.size();
        int i = 0;
        while (i < projects.size()) {
            IProject project = (IProject)projects.get(i);
            this.j2eeVersion = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project);
            if (!J2EEMigrationHelper.isJ2EEComponent((IProject)project)) {
                isValid = false;
            } else {
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                int j2eeVersion = J2EEVersionUtil.convertVersionStringToInt((IVirtualComponent)component);
                if (j2eeVersion == 50) {
                    this.validJ2EEVersion = false;
                }
            }
            if (J2EEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.ear")) {
                isValid = size == 1;
            } else if (J2EEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.connector")) {
                isValid = this.j2eeVersion.equals("1.0") || this.j2eeVersion.equals("1.5");
            }
            ++i;
        }
        return isValid;
    }

    private void informInvalidSelection(Shell shell) {
        MessageDialog.openInformation((Shell)shell, (String)J2EEMigrationUIResourceHandler.INVALID_SELECTION_TITLE, (String)J2EEMigrationUIResourceHandler.INFORM_PROPER_SELECTION);
    }

    protected void openWizard(Shell shell, List projects) {
        J2EEMigrationWizard wizard = new J2EEMigrationWizard();
        J2EEUIPlugin plugin = J2EEUIPlugin.getDefault();
        wizard.init(plugin.getWorkbench(), (IStructuredSelection)this.selection);
        List selectedComponents = this.getSelectedComponents(projects);
        wizard.setDataModel(wizard.createDefaultModel());
        wizard.setComponents(selectedComponents);
        wizard.setDialogSettings(plugin.getDialogSettings());
        wizard.setJ2eeVersion(this.j2eeVersion);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(530, 600);
        dialog.open();
    }

    private List getSelectedComponents(List projects) {
        ArrayList<IVirtualComponent> components = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < projects.size()) {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)((IProject)projects.get(i)));
            components.add(comp);
            ++i;
        }
        return components;
    }

    private boolean checkNoEditorsOpen(Shell shell) {
        if (this.isEditorOpen()) {
            boolean answer = MessageDialog.openQuestion((Shell)shell, (String)J2EEMigrationUIResourceHandler.OPEN_EDITORS_TITLE, (String)J2EEMigrationUIResourceHandler.INFORM_OPEN_EDITORS);
            if (answer) {
                IWorkbenchWindow[] windows = this.getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    int x = 0;
                    while (x < pages.length) {
                        IEditorReference[] editorRefs = pages[x].getEditorReferences();
                        int j = 0;
                        while (j < editorRefs.length) {
                            IEditorReference reference = editorRefs[j];
                            pages[x].closeEditor(reference.getEditor(true), true);
                            ++j;
                        }
                        ++x;
                    }
                    ++i;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean isEditorOpen() {
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] refs = pages[x].getEditorReferences();
                if (refs != null && refs.length > 0) {
                    return true;
                }
                ++x;
            }
            ++i;
        }
        return false;
    }

    private IWorkbenchWindow[] getWorkbenchWindows() {
        IWorkbench workbench = J2EEUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        return windows;
    }
}

