/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.ui.internal.actions;

import com.ibm.etools.j2ee.migration.internal.AbstractJ2EEMigrationOperation;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.ui.internal.actions.IJ2EEMigrationConstants;
import com.ibm.etools.j2ee.migration.ui.internal.actions.MigrationStatusDialog;
import com.ibm.etools.j2ee.migration.ui.internal.plugin.MigrationUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.common.internal.util.CommonUtil;
import org.eclipse.jst.j2ee.internal.actions.AbstractActionDelegate;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;

public abstract class J2EEMigrationActionDelegate
extends AbstractActionDelegate
implements IJ2EEMigrationConstants {
    public static IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = J2EEUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public J2EEMigrationActionDelegate() {
        this.setAllowsMultiSelect(true);
    }

    private boolean checkNoEditorsOpen(Shell shell) {
        if (this.isEditorOpen()) {
            MessageDialog.openError((Shell)shell, (String)J2EEMigrationUIResourceHandler.OPEN_EDITORS_TITLE, (String)J2EEMigrationUIResourceHandler.INFORM_OPEN_EDITORS);
            return false;
        }
        return true;
    }

    protected boolean confirmProceed(Shell shell) {
        return MessageDialog.openConfirm((Shell)shell, (String)J2EEMigrationUIResourceHandler.CONFIRMATION_TITLE, (String)this.getConfirmationMessage());
    }

    protected abstract AbstractJ2EEMigrationOperation createMigrationOperation(List var1);

    protected IRunnableWithProgress createRunnableWithProgress(AbstractJ2EEMigrationOperation op, List projects) {
        return WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)op);
    }

    protected abstract String getConfirmationMessage();

    protected boolean isEditorOpen() {
        IWorkbench workbench = WTPUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] refs = pages[x].getEditorReferences();
                if (refs != null && refs.length > 0) {
                    return true;
                }
                ++x;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSupportedAction(Object element) {
        return CommonUtil.isDeploymentDescriptorRoot((Object)element, (boolean)true);
    }

    protected void primRun(Shell shell) {
        if (!this.checkNoEditorsOpen(shell)) {
            return;
        }
        if (!this.confirmProceed(shell)) {
            return;
        }
        List projects = this.getProjects();
        if (projects == null || projects.isEmpty()) {
            return;
        }
        AbstractJ2EEMigrationOperation operation = this.createMigrationOperation(projects);
        IRunnableWithProgress runnable = this.createRunnableWithProgress(operation, projects);
        ProgressMonitorDialog ctx = new ProgressMonitorDialog(shell);
        try {
            ctx.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            MigrationUIPlugin.logError(e);
        }
        catch (InterruptedException interruptedException) {}
        MigrationStatusDialog.openDialog(shell, null, null, operation.getMigrationStatus());
    }
}

