/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.ui.internal.actions;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public abstract class GeneralModuleMigrationWizardPage
extends DataModelWizardPage
implements ICheckStateListener {
    protected Label j2eeVersionLabel;
    protected Combo j2eeVersionCombo;
    private static final Integer PAGE_OK = new Integer(2);
    protected CheckboxTableViewer checkBoxViewer;
    protected Button selectAll;
    protected Button deselectAll;
    protected IDataModel composedConfig;
    protected Text selectStatus;
    protected int totalModules = 0;
    protected boolean firstVisible = false;

    public GeneralModuleMigrationWizardPage(String pageName, IDataModel config) {
        super(config, pageName);
        this.composedConfig = config;
    }

    protected void addListeners() {
        this.checkBoxViewer.getControl().addListener(13, (Listener)this);
        this.selectAll.addListener(13, (Listener)this);
        this.deselectAll.addListener(13, (Listener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getElement() == null) {
            return;
        }
        ((IDataModel)event.getElement()).setProperty("J2EEMigrationConfig.isSelected", (Object)new Boolean(event.getChecked()));
    }

    protected void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(2));
        this.selectAll = new Button(composite, 0);
        this.selectAll.setLayoutData((Object)new GridData(768));
        this.selectAll.setText(J2EEMigrationUIResourceHandler.Select_All);
        this.deselectAll = new Button(composite, 0);
        this.deselectAll.setLayoutData((Object)new GridData(768));
        this.deselectAll.setText(J2EEMigrationUIResourceHandler.Deselect_All);
    }

    protected void createEARButtons(Composite composite) {
        if (!this.earMigrationSelected()) {
            this.createJ2EEVersionComposite(composite);
        }
    }

    protected void createJ2EEVersionComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        GridData data = new GridData(768);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        this.j2eeVersionLabel = new Label(composite, 0);
        this.j2eeVersionLabel.setText(J2EEMigrationUIResourceHandler.Version_Level);
        this.j2eeVersionCombo = new Combo(composite, 2056);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.j2eeVersionCombo.setLayoutData((Object)data);
        Control[] deps = new Control[]{this.j2eeVersionLabel};
        this.synchHelper.synchCombo(this.j2eeVersionCombo, "J2EEMigrationConfig.J2EE_MIGRATION_VERSION", deps);
    }

    private boolean earMigrationSelected() {
        IVirtualComponent component = (IVirtualComponent)this.composedConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
        return component != null && J2EEProjectUtilities.getJ2EEProjectType((IProject)component.getProject()).equals("jst.ear");
    }

    protected IDataModel getServerTargetDataModel() {
        return this.model.getNestedModel("J2EEMigrationConfig.NESTED_MODEL_SERVER_TARGET");
    }

    protected void createNumberSelected(Composite composite) {
        this.selectStatus = new Text(composite, 72);
        GridData data = new GridData(768);
        this.selectStatus.setLayoutData((Object)data);
        this.updateSelectedStatus();
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1536));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextId());
        this.createViewer(composite);
        this.createButtons(composite);
        this.createNumberSelected(composite);
        this.setSpacer(composite);
        this.createEARButtons(composite);
        this.setSpacer(composite);
        this.setSpacer(composite);
        this.setSpacer(composite);
        this.setSpacer(composite);
        this.setSpacer(composite);
        this.setSpacer(composite);
        return composite;
    }

    protected void createViewer(Composite parent) {
        Label ejbLabel = new Label(parent, 0);
        ejbLabel.setLayoutData((Object)new GridData(768));
        ejbLabel.setText(J2EEMigrationUIResourceHandler.Available_Projects_);
        this.checkBoxViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2592);
        GridData data = new GridData(1808);
        data.heightHint = 90;
        this.checkBoxViewer.getTable().setLayoutData((Object)data);
        this.checkBoxViewer.setLabelProvider((IBaseLabelProvider)new DataModelLabelProvider());
        this.checkBoxViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.checkBoxViewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void enter() {
        List configs = this.getConfigs();
        this.setTotalModules(configs.size());
        this.checkBoxViewer.setInput((Object)configs);
        this.refreshTreeViewer();
        this.updateSelectedStatus();
        super.enter();
        this.validateControls();
    }

    protected String formatNumSelected(String aPattern, int selected, int total) {
        return MessageFormat.format(aPattern, "" + selected, "" + total);
    }

    protected abstract List getConfigs();

    protected abstract String getContextId();

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", "IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID", "IJ2EEProjectServerTargetDataModelProperties.PROJECT_NAME", "IJ2EEProjectServerTargetDataModelProperties.UPDATE_MODULES", "IArtifactEditOperationDataModelProperties.PROJECT_NAME", "IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID", "J2EEMigrationConfig.J2EE_MIGRATION_VERSION"};
    }

    public void handleEvent(Event event) {
        if (event.widget == this.checkBoxViewer.getControl()) {
            this.updateSelectedStatus();
        } else if (event.widget == this.selectAll) {
            this.checkBoxViewer.setAllChecked(true);
            this.setAllChecked(event, true);
            this.updateSelectedStatus();
        } else if (event.widget == this.deselectAll) {
            this.checkBoxViewer.setAllChecked(false);
            this.setAllChecked(event, false);
            this.updateSelectedStatus();
        }
        this.validatePage();
        super.handleEvent(event);
    }

    protected void refreshTreeViewer() {
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel config = (IDataModel)configs.get(i);
            this.checkBoxViewer.setChecked((Object)config, config.getBooleanProperty("J2EEMigrationConfig.isSelected"));
            ++i;
        }
    }

    private void setAllChecked(Event event, boolean b) {
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel config = (IDataModel)configs.get(i);
            config.setBooleanProperty("J2EEMigrationConfig.isSelected", b);
            ++i;
        }
    }

    public void setSpacer(Composite composite) {
        Label space = new Label(composite, 0);
        GridData data = new GridData(768);
        space.setLayoutData((Object)data);
    }

    public void setTotalModules(int aTotalModules) {
        this.totalModules = aTotalModules;
    }

    protected void updateSelectedStatus() {
        int numSelected = Arrays.asList(this.checkBoxViewer.getCheckedElements()).size();
        this.selectStatus.setText(this.formatNumSelected(J2EEMigrationUIResourceHandler.Selected_Projects_, numSelected, this.totalModules));
    }

    protected void validateControls() {
        this.setOKStatus(PAGE_OK);
        if (Arrays.asList(this.checkBoxViewer.getCheckedElements()).size() == 0 && !this.composedConfig.getBooleanProperty("J2EEMigrationConfig.isEARComponent")) {
            this.setErrorStatus(PAGE_OK, J2EEMigrationUIResourceHandler.A_Project_Must_Be_Selected_);
        }
        this.setErrorMessage();
    }

    protected void validatePage(boolean showMessage) {
        super.validatePage(showMessage);
        this.validateControls();
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(true);
    }

    protected class DataModelLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            WorkbenchLabelProvider pr = new WorkbenchLabelProvider();
            return pr.getImage(((IDataModel)element).getProperty("IArtifactEditOperationDataModelProperties.TARGET_PROJECT"));
        }

        public String getText(Object element) {
            return ((IDataModel)element).getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    protected class ProjectContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

