/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.ui.internal.actions;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.ui.internal.actions.GeneralModuleMigrationWizardPage;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EJBModuleMigrationWizardPage
extends GeneralModuleMigrationWizardPage {
    private boolean cmpSelectionCache = false;
    private boolean firstVisit = true;
    private boolean localClientSelectionCache = false;
    protected Button localCmpMigrationButton;
    protected Button localAddLocalClient;
    protected List modules;

    public EJBModuleMigrationWizardPage(String pageName, IDataModel ejbJarConfig) {
        super(pageName, ejbJarConfig);
        this.setTitle(J2EEMigrationUIResourceHandler.EJB_Module_Migration_);
        this.setDescription(J2EEMigrationUIResourceHandler.Select_the_EJB_projects_to_be_migrated_);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.j2ee.ui", (String)"ejbmodule_mig_wiz"));
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.localCmpMigrationButton.addListener(13, (Listener)this);
        this.localAddLocalClient.addListener(13, (Listener)this);
    }

    @Override
    protected void createEARButtons(Composite composite) {
        super.createEARButtons(composite);
        this.localCmpMigrationButton = new Button(composite, 32);
        this.localCmpMigrationButton.setLayoutData((Object)new GridData(768));
        this.localCmpMigrationButton.setText(J2EEMigrationUIResourceHandler.Migrated_CMP_Beans_To_);
        this.localAddLocalClient = new Button(composite, 32);
        this.localAddLocalClient.setLayoutData((Object)new GridData(768));
        this.localAddLocalClient.setText(J2EEMigrationUIResourceHandler.Add_Local_Client_Views_);
        this.localAddLocalClient.setSelection(false);
        this.localAddLocalClient.setEnabled(true);
        this.handleAddLocalClient(false);
    }

    @Override
    protected Composite createTopLevelComposite(Composite parent) {
        return super.createTopLevelComposite(parent);
    }

    @Override
    protected void createViewer(Composite parent) {
        super.createViewer(parent);
    }

    @Override
    public void enter() {
        super.enter();
        if (this.firstVisit) {
            this.initialSetup();
            this.firstVisit = false;
        } else {
            this.handleMigrateProjectSelectionChange(true);
        }
    }

    @Override
    protected List getConfigs() {
        return this.composedConfig == null ? Collections.EMPTY_LIST : (List)this.composedConfig.getProperty("IComposedMigrationConfigProperties.getEJBJarChildren");
    }

    @Override
    protected String getContextId() {
        return "com.ibm.etools.j2ee.migration.ui.migr1100";
    }

    protected boolean doEJBSExistInChildEJBConfigs() {
        boolean beansExist = false;
        int i = 0;
        while (i < this.getConfigs().size()) {
            IDataModel ejbModel = (IDataModel)this.getConfigs().get(i);
            if (!((List)ejbModel.getProperty("EJBJarMigrationConfig.getChildren")).isEmpty()) {
                beansExist = true;
                break;
            }
            ++i;
        }
        return beansExist;
    }

    private void handleAddLocalClient(boolean addClient) {
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel config = (IDataModel)configs.get(i);
            config.setProperty("EJBJarMigrationConfig.selectAllEntries", (Object)new Boolean(addClient));
            config.setProperty("EJBJarMigrationConfig.deselectAllEntries", (Object)new Boolean(!addClient));
            this.localClientSelectionCache = addClient;
            ++i;
        }
    }

    private void handleCMPMigrationButton(boolean migrateCMP) {
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel config = (IDataModel)configs.get(i);
            config.setBooleanProperty("EJBJarMigrationConfig.migrateCMP1xto2x", migrateCMP);
            ++i;
        }
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.selectAll) {
            this.checkBoxViewer.setAllChecked(true);
        } else if (event.widget == this.deselectAll) {
            this.checkBoxViewer.setAllChecked(false);
        }
        if (this.checkBoxViewer.getCheckedElements().length > 0 && this.doEJBSExistInChildEJBConfigs()) {
            if (!this.localCmpMigrationButton.getEnabled()) {
                this.localCmpMigrationButton.setEnabled(true);
            }
            if (!this.localAddLocalClient.getEnabled()) {
                this.localAddLocalClient.setEnabled(true);
            }
        } else {
            this.localAddLocalClient.setSelection(false);
            this.localCmpMigrationButton.setEnabled(false);
            this.localAddLocalClient.setSelection(false);
            this.localAddLocalClient.setEnabled(false);
        }
        if (event.widget == this.localCmpMigrationButton && this.localCmpMigrationButton.getEnabled()) {
            this.cmpSelectionCache = this.localCmpMigrationButton.getSelection();
            this.handleCMPMigrationButton(this.localCmpMigrationButton.getSelection());
            if (this.localCmpMigrationButton.getSelection()) {
                this.localAddLocalClient.setEnabled(true);
                this.localAddLocalClient.setSelection(this.localCmpMigrationButton.getSelection());
                this.localClientSelectionCache = this.localAddLocalClient.getSelection();
                this.handleAddLocalClient(this.localAddLocalClient.getSelection());
            } else {
                this.localAddLocalClient.setSelection(false);
                this.localAddLocalClient.setEnabled(false);
            }
        } else if (event.widget == this.localAddLocalClient && this.localAddLocalClient.getEnabled()) {
            this.handleAddLocalClient(this.localAddLocalClient.getSelection());
        }
        super.handleEvent(event);
    }

    private void handleMigrateProjectSelectionChange(boolean migrateJ2EE) {
        if (migrateJ2EE) {
            this.initialSetup();
        } else {
            this.localClientSelectionCache = this.localAddLocalClient.getSelection();
            this.localAddLocalClient.setEnabled(false);
            this.localAddLocalClient.setSelection(false);
            this.cmpSelectionCache = this.localCmpMigrationButton.getSelection();
            this.localCmpMigrationButton.setEnabled(false);
            this.localCmpMigrationButton.setSelection(false);
        }
        this.handleAddLocalClient(this.localAddLocalClient.getSelection());
        this.handleCMPMigrationButton(this.localCmpMigrationButton.getSelection());
    }

    protected void initialSetup() {
        boolean enable = this.shouldCMPMigrationBeEnabled();
        this.localCmpMigrationButton.setEnabled(enable);
        if (this.firstVisit) {
            this.localAddLocalClient.setSelection(false);
            this.localAddLocalClient.setEnabled(false);
        } else if (this.cmpSelectionCache) {
            this.localAddLocalClient.setEnabled(this.cmpSelectionCache);
            this.localAddLocalClient.setSelection(this.localClientSelectionCache && this.cmpSelectionCache);
        }
    }

    protected boolean shouldCMPMigrationBeEnabled() {
        List ejbHolder = this.getConfigs();
        boolean enable = false;
        if (ejbHolder != null && !ejbHolder.isEmpty()) {
            int i = 0;
            while (i < ejbHolder.size()) {
                IDataModel model = (IDataModel)ejbHolder.get(i);
                if (((List)model.getProperty("EJBJarMigrationConfig.getEntityChildren")).size() > 0 && (enable = true)) break;
                ++i;
            }
        }
        return enable;
    }

    public boolean isAddLocalClientSelected() {
        return this.localAddLocalClient.getSelection();
    }

    public void setLocalClientSelection(boolean selection) {
        this.localAddLocalClient.setSelection(selection);
    }

    @Override
    protected String[] getValidationPropertyNames() {
        return new String[]{"IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", "IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID", "IJ2EEProjectServerTargetDataModelProperties.PROJECT_NAME", "IJ2EEProjectServerTargetDataModelProperties.UPDATE_MODULES", "IArtifactEditOperationDataModelProperties.PROJECT_NAME", "IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID", "J2EEMigrationConfig.J2EE_MIGRATION_VERSION"};
    }
}

