/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.ui.internal.actions;

import com.ibm.etools.j2ee.migration.internal.EJBClientViewMigrationConfig;
import com.ibm.etools.j2ee.migration.internal.EJBJarMigrationConfig;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.ui.internal.actions.BeanContentProvider;
import com.ibm.etools.j2ee.migration.ui.internal.actions.BeanLabelProvider;
import com.ibm.etools.j2ee.migration.ui.internal.actions.EJBModuleMigrationWizardPage;
import com.ibm.etools.j2ee.migration.ui.internal.actions.RequiredBeansDialog;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class EJBBeanMigrationWizardPage
extends DataModelWizardPage
implements ICheckStateListener {
    private static final Integer PAGE_OK = new Integer(0);
    protected CheckboxTreeViewer beanViewer;
    protected IDataModel composedMigrationConfig;
    protected Group compositeLocal;
    protected Button deleteRemoteButton;
    protected Button selectAll;
    protected Button deselectAll;
    protected Button selectAllEntities;
    protected Button selectRequired;
    protected List modules;
    protected int numSelected = 0;
    protected IWizardPage previousPage;
    protected Button reuseDeletedName;
    protected Button specSuffix;
    protected Text selectStatus;
    protected Text suffixName;
    protected Text suffixExample1;
    protected int totalBeans = 0;

    public EJBBeanMigrationWizardPage(String pageName, IDataModel composedConfig) {
        super(composedConfig, pageName);
        this.composedMigrationConfig = composedConfig;
        this.setTitle(J2EEMigrationUIResourceHandler.Add_Local_Client_Views_);
        this.setDescription(J2EEMigrationUIResourceHandler.Select_the_enterprise_beans_that_will_have_);
    }

    protected void addListeners() {
        this.beanViewer.addCheckStateListener((ICheckStateListener)this);
        this.beanViewer.getTree().addListener(13, (Listener)this);
        this.selectAll.addListener(13, (Listener)this);
        this.deselectAll.addListener(13, (Listener)this);
        this.selectAllEntities.addListener(13, (Listener)this);
        this.selectRequired.addListener(13, (Listener)this);
        this.deleteRemoteButton.addListener(13, (Listener)this);
        this.reuseDeletedName.addListener(13, (Listener)this);
        this.specSuffix.addListener(13, (Listener)this);
        this.suffixName.addListener(24, (Listener)this);
    }

    private void beanConfigCheckStateChanged(boolean checked, EJBClientViewMigrationConfig element) {
        element.setIsSelected(checked);
        element.getParentConfig().setProperty("EJBJarMigrationConfig.selectAllEntries", null);
        element.getParentConfig().setProperty("EJBJarMigrationConfig.deselectAllEntries", null);
        this.refreshTreeViewerCheckState(element.getParentConfig());
    }

    protected void changeLocalNamingViewEnablement(boolean selection) {
        this.reuseDeletedName.setEnabled(selection);
        if (!selection) {
            this.reuseDeletedName.setSelection(false);
            this.specSuffix.setSelection(true);
            this.suffixName.setEnabled(true);
            this.handleReuseDeleteName(false);
            this.handleSpecSuffix(true);
            this.suffixExample1.setEnabled(true);
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        boolean checked = event.getChecked();
        Object element = event.getElement();
        if (element instanceof IDataModel) {
            this.jarConfigCheckStateChanged(checked, (IDataModel)element);
        } else if (element instanceof EJBClientViewMigrationConfig) {
            this.beanConfigCheckStateChanged(checked, (EJBClientViewMigrationConfig)element);
        }
        this.updateSelectedStatus();
        this.validateControls();
    }

    public boolean confirmAllRequiredBeansSelected() {
        Map unselected = this.getAllUnselectedRequiredBeans();
        if (unselected.isEmpty()) {
            return true;
        }
        boolean confirmed = RequiredBeansDialog.openConfirm(this.getShell(), unselected);
        if (confirmed) {
            this.selectRequired(unselected);
            if (this.isCurrentPage()) {
                this.refreshTreeViewer();
            }
            return true;
        }
        return false;
    }

    protected void createBeanViewer(Composite composite) {
        Label ejbLabel = new Label(composite, 0);
        GridData data = new GridData(768);
        ejbLabel.setLayoutData((Object)data);
        ejbLabel.setText(J2EEMigrationUIResourceHandler.Enterprise_Beans_Selection_);
        data = new GridData(1808);
        this.beanViewer = new CheckboxTreeViewer(composite, 2080);
        data.heightHint = 120;
        this.beanViewer.getTree().setLayoutData((Object)data);
        this.beanViewer.setLabelProvider((IBaseLabelProvider)new BeanLabelProvider());
        this.beanViewer.setContentProvider((IContentProvider)new BeanContentProvider());
        this.beanViewer.setAutoExpandLevel(2);
    }

    protected void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(2));
        this.selectAll = new Button(composite, 0);
        this.selectAll.setText(J2EEMigrationUIResourceHandler.Select_All);
        this.selectAll.setLayoutData((Object)new GridData(768));
        this.deselectAll = new Button(composite, 0);
        this.deselectAll.setText(J2EEMigrationUIResourceHandler.Deselect_All);
        this.deselectAll.setLayoutData((Object)new GridData(768));
        this.selectAllEntities = new Button(composite, 0);
        this.selectAllEntities.setText(J2EEMigrationUIResourceHandler.Select_All_Entity_Beans_);
        this.selectAllEntities.setLayoutData((Object)new GridData(768));
        this.selectRequired = new Button(composite, 0);
        this.selectRequired.setText(J2EEMigrationUIResourceHandler.Select_Required_Beans_);
        this.selectRequired.setLayoutData((Object)new GridData(768));
        if (this.numSelected == this.totalBeans) {
            this.selectRequired.setEnabled(false);
        }
    }

    protected void createEARButtons(Composite composite) {
        this.deleteRemoteButton = new Button(composite, 32);
        this.deleteRemoteButton.setText(J2EEMigrationUIResourceHandler.Delete_Remote_Client_Views_);
        this.createLocalClientNaming(composite);
    }

    protected void createLocalClientNaming(Composite parent) {
        this.compositeLocal = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.compositeLocal.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalIndent = 17;
        this.compositeLocal.setLayoutData((Object)data);
        this.compositeLocal.setText(J2EEMigrationUIResourceHandler.Local_Client_View_Naming_Scheme_);
        this.reuseDeletedName = new Button((Composite)this.compositeLocal, 16);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.reuseDeletedName.setLayoutData((Object)data);
        this.reuseDeletedName.setText(J2EEMigrationUIResourceHandler.Reuse_The_Deleted_Remote_Client_View_);
        this.reuseDeletedName.setEnabled(false);
        this.specSuffix = new Button((Composite)this.compositeLocal, 16);
        this.specSuffix.setText(J2EEMigrationUIResourceHandler.Specify_Suffix_);
        this.specSuffix.setSelection(true);
        this.suffixName = new Text((Composite)this.compositeLocal, 2048);
        data = new GridData(768);
        data.horizontalSpan = 1;
        data.widthHint = 300;
        this.suffixName.setLayoutData((Object)data);
        Label empty = new Label((Composite)this.compositeLocal, 0);
        data = new GridData(768);
        data.widthHint = 2;
        empty.setLayoutData((Object)data);
        this.suffixExample1 = new Text((Composite)this.compositeLocal, 74);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.horizontalIndent = 17;
        data.heightHint = 50;
        this.suffixExample1.setLayoutData((Object)data);
    }

    protected void createNumberSelected(Composite composite) {
        this.selectStatus = new Text(composite, 72);
        GridData data = new GridData(768);
        this.selectStatus.setLayoutData((Object)data);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.etools.j2ee.migration.ui.migr1500");
        this.createBeanViewer(composite);
        this.createButtons(composite);
        this.createNumberSelected(composite);
        this.setSpacer(composite);
        this.createEARButtons(composite);
        return composite;
    }

    public void enter() {
        super.enter();
        this.beanViewer.setInput((Object)this.getConfigs());
        if (this.getSuffixFromConfig() == null) {
            this.suffixName.setText("");
        } else {
            this.suffixName.setText(this.getSuffixFromConfig());
        }
        this.refreshTreeViewer();
    }

    public void exit() {
        super.exit();
    }

    protected String format(String aPattern, String arg1, String arg2) {
        return MessageFormat.format(aPattern, arg1, arg2);
    }

    protected String formatNumSelected(String aPattern, int selected, int total) {
        return MessageFormat.format(aPattern, "" + selected, "" + total);
    }

    private Map getAllUnselectedRequiredBeans() {
        HashMap<IDataModel, List> result = null;
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel config = (IDataModel)configs.get(i);
            List unselected = (List)config.getProperty("EJBJarMigrationConfig.getChildrenRequiringSelection");
            if (!unselected.isEmpty()) {
                if (result == null) {
                    result = new HashMap<IDataModel, List>();
                }
                result.put(config, unselected);
            }
            ++i;
        }
        return result == null ? Collections.EMPTY_MAP : result;
    }

    protected List getConfigs() {
        if (this.composedMigrationConfig != null) {
            return (List)this.composedMigrationConfig.getProperty("IComposedMigrationConfigProperties.getEJBJarChildren");
        }
        return Collections.EMPTY_LIST;
    }

    private String getSuffixFromConfig() {
        List configs = this.getConfigs();
        if (configs.isEmpty()) {
            return "Local";
        }
        return ((IDataModel)configs.get(0)).getStringProperty("EJBJarMigrationConfig.localClientViewSuffix");
    }

    protected String[] getValidationPropertyNames() {
        return null;
    }

    private void handleDeleteRemoteClientView(boolean deleteRemote) {
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            ((IDataModel)configs.get(i)).setBooleanProperty("EJBJarMigrationConfig.deleteRemoteClientView", deleteRemote);
            ++i;
        }
    }

    public void handleEvent(Event event) {
        if (this.previousPage == null) {
            this.previousPage = this.getWizard().getPreviousPage((IWizardPage)this);
        }
        if (event.widget == this.selectAll) {
            this.setAllSelected(true);
            this.selectRequired.setEnabled(false);
            ((EJBModuleMigrationWizardPage)this.previousPage).setLocalClientSelection(true);
        } else if (event.widget == this.deselectAll) {
            this.setAllSelected(false);
            this.selectRequired.setEnabled(true);
            ((EJBModuleMigrationWizardPage)this.previousPage).setLocalClientSelection(false);
        } else if (event.widget == this.selectAllEntities) {
            this.selectAllEntities();
            this.handleLocalClientUpdate();
            if (this.numSelected == this.totalBeans) {
                this.selectRequired.setEnabled(false);
            } else {
                this.selectRequired.setEnabled(true);
            }
        } else if (event.widget == this.selectRequired) {
            this.selectRequired();
            this.handleLocalClientUpdate();
        } else if (event.widget == this.deleteRemoteButton) {
            this.changeLocalNamingViewEnablement(this.deleteRemoteButton.getSelection());
            if (this.reuseDeletedName.getSelection() && !this.deleteRemoteButton.getSelection()) {
                this.suffixName.setEnabled(false);
            }
            this.handleDeleteRemoteClientView(this.deleteRemoteButton.getSelection());
        } else if (event.widget == this.reuseDeletedName) {
            this.suffixName.setEnabled(false);
            this.suffixExample1.setEnabled(false);
            this.handleReuseDeleteName(this.reuseDeletedName.getSelection());
        } else if (event.widget == this.specSuffix) {
            this.suffixName.setEnabled(true);
            this.suffixExample1.setEnabled(true);
            this.handleSpecSuffix(this.specSuffix.getSelection());
        } else if (event.widget == this.suffixName) {
            this.handleSuffixNameChange();
        } else if (event.widget == this.beanViewer.getTree()) {
            this.handleLocalClientUpdate();
        }
        super.handleEvent(event);
    }

    private void handleLocalClientUpdate() {
        if (this.numSelected == 0) {
            ((EJBModuleMigrationWizardPage)this.previousPage).setLocalClientSelection(false);
            this.selectRequired.setEnabled(true);
        } else {
            ((EJBModuleMigrationWizardPage)this.previousPage).setLocalClientSelection(true);
            if (this.numSelected == this.totalBeans) {
                this.selectRequired.setEnabled(false);
            } else {
                this.selectRequired.setEnabled(true);
            }
        }
    }

    private void handleReuseDeleteName(boolean reuse) {
        if (!reuse) {
            return;
        }
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel dataModel = (IDataModel)configs.get(i);
            dataModel.setBooleanProperty("EJBJarMigrationConfig.reuseRemoteClientViewName", reuse);
            ++i;
        }
    }

    private void handleSpecSuffix(boolean spec) {
        if (!spec) {
            return;
        }
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel dataModel = (IDataModel)configs.get(i);
            dataModel.setBooleanProperty("EJBJarMigrationConfig.reuseRemoteClientViewName", !spec);
            dataModel.setStringProperty("EJBJarMigrationConfig.localClientViewSuffix", this.suffixName.getText());
            ++i;
        }
    }

    private void handleSuffixNameChange() {
        List configs = this.getConfigs();
        String text = this.suffixName.getText().trim();
        int i = 0;
        while (i < configs.size()) {
            IDataModel config = (IDataModel)configs.get(i);
            if (!text.equals(config.getStringProperty("EJBJarMigrationConfig.localClientViewSuffix"))) {
                config.setStringProperty("EJBJarMigrationConfig.localClientViewSuffix", text);
            }
            ++i;
        }
        this.suffixExample1.setText(this.format(J2EEMigrationUIResourceHandler.EJB_Client_View_Example_, text, text));
    }

    protected boolean hasApplicableBeans() {
        return !EJBJarMigrationConfig.filterConfigsWithNoApplicableClientConfigs((List)this.getConfigs()).isEmpty();
    }

    public boolean isPageComplete() {
        return super.isPageComplete() || !this.hasApplicableBeans();
    }

    private void jarConfigCheckStateChanged(boolean checked, IDataModel element) {
        element.setBooleanProperty("EJBJarMigrationConfig.allChildrenSelected", checked);
        this.beanViewer.setGrayed((Object)element, false);
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel config = (IDataModel)configs.get(i);
            config.setProperty("EJBJarMigrationConfig.selectAllEntries", null);
            config.setProperty("EJBJarMigrationConfig.deselectAllEntries", null);
            ++i;
        }
        this.refreshTreeViewerChidren(element);
    }

    private void refreshTreeViewer() {
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel config = (IDataModel)configs.get(i);
            this.refreshTreeViewer(config);
            ++i;
        }
        this.updateSelectedStatus();
    }

    private void refreshTreeViewer(IDataModel config) {
        this.refreshTreeViewerCheckState(config);
        this.refreshTreeViewerChidren(config);
        this.validateControls();
    }

    private void refreshTreeViewerCheckState(IDataModel config) {
        boolean parentChecked = config.getBooleanProperty("EJBJarMigrationConfig.isAnyChildSelected");
        this.beanViewer.setChecked((Object)config, parentChecked);
        this.beanViewer.setGrayed((Object)config, parentChecked && !config.getBooleanProperty("EJBJarMigrationConfig.isAllSelected"));
    }

    private void refreshTreeViewerChidren(IDataModel config) {
        List configs = (List)config.getProperty("EJBJarMigrationConfig.getChildren");
        int i = 0;
        while (i < configs.size()) {
            EJBClientViewMigrationConfig child = (EJBClientViewMigrationConfig)configs.get(i);
            this.beanViewer.setChecked((Object)child, child.isSelected());
            ++i;
        }
    }

    protected void selectAllEntities() {
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel config = (IDataModel)configs.get(i);
            config.setBooleanProperty("EJBJarMigrationConfig.selectAllEntries", true);
            config.setBooleanProperty("EJBJarMigrationConfig.deselectAllEntries", false);
            ++i;
        }
        this.refreshTreeViewer();
    }

    protected void selectRequired() {
        Map unselected = this.getAllUnselectedRequiredBeans();
        this.selectRequired(unselected);
        this.refreshTreeViewer();
    }

    private void selectRequired(Map unselected) {
        for (Map.Entry entry : unselected.entrySet()) {
            IDataModel config = (IDataModel)entry.getKey();
            List aList = (List)entry.getValue();
            this.setChildrenSelected(config, aList, true);
            config.setProperty("EJBJarMigrationConfig.selectAllEntries", null);
            config.setProperty("EJBJarMigrationConfig.deselectAllEntries", null);
        }
    }

    private void setChildrenSelected(IDataModel dataModel, List list, boolean selected) {
        int i = 0;
        while (i < list.size()) {
            EJBClientViewMigrationConfig config = (EJBClientViewMigrationConfig)list.get(i);
            config.setIsSelected(selected);
            ++i;
        }
    }

    protected void setAllSelected(boolean state) {
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel config = (IDataModel)configs.get(i);
            config.setBooleanProperty("EJBJarMigrationConfig.allChildrenSelected", state);
            config.setBooleanProperty("EJBJarMigrationConfig.selectAllEntries", state);
            config.setBooleanProperty("EJBJarMigrationConfig.deselectAllEntries", !state);
            ++i;
        }
        this.refreshTreeViewer();
    }

    private void setSpacer(Composite composite) {
        Label space = new Label(composite, 0);
        GridData data = new GridData(768);
        space.setLayoutData((Object)data);
    }

    protected void updateSelectedStatus() {
        this.numSelected = 0;
        this.totalBeans = 0;
        List configs = this.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            IDataModel config = (IDataModel)configs.get(i);
            this.numSelected += config.getIntProperty("EJBJarMigrationConfig.getSelectedCount");
            this.totalBeans += config.getIntProperty("EJBJarMigrationConfig.getChildCount");
            ++i;
        }
        this.selectStatus.setText(this.formatNumSelected(J2EEMigrationUIResourceHandler.Selected_Beans_Migration_, this.numSelected, this.totalBeans));
    }

    protected void validateControls() {
        this.setOKStatus(PAGE_OK);
        this.updateSelectedStatus();
        if (this.numSelected != 0 && this.specSuffix.getSelection() && this.suffixName.getText().equals("")) {
            this.setErrorStatus(PAGE_OK, J2EEMigrationUIResourceHandler.The_Suffix_Text_Can_Not_Be_);
        }
        super.validatePage();
    }
}

