/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.ui.internal.actions;

import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.ui.internal.actions.J2EEMigrationWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class EARMigrationWizardPage
extends DataModelWizardPage {
    protected Text description;
    protected Label earLabel;
    protected Label j2eeVersionLabel;
    protected Label targetRuntimeLabel;
    protected IDataModel earMigrationConfig;
    protected Button j2eeMigrationButton;
    protected Button moduleMigrationButton;
    protected Button projectStructureButton;
    protected Combo j2eeVersionCombo;
    protected TreeViewer projectViewer;

    public EARMigrationWizardPage(String pageName, IDataModel migrationConfig) {
        super(migrationConfig, pageName);
        this.setTitle(J2EEMigrationUIResourceHandler.Enterprise_Application_);
        this.setDescription(J2EEMigrationUIResourceHandler.The_following_enterprise_application_project_);
        this.loadData();
    }

    protected void addListeners() {
        this.projectViewer.getTree().addListener(13, (Listener)this);
        this.moduleMigrationButton.addListener(13, (Listener)this);
    }

    protected void createEARButtons(Composite composite) {
        this.createJ2EEVersionComposite(composite);
        this.moduleMigrationButton = new Button(composite, 32);
        this.moduleMigrationButton.setLayoutData((Object)new GridData(768));
        this.moduleMigrationButton.setText(J2EEMigrationUIResourceHandler.Migrate_All_Module_Projects_);
        this.moduleMigrationButton.setSelection(true);
        this.synchHelper.synchCheckbox(this.moduleMigrationButton, "J2EEMigrationConfig.isSelected", null);
        Label moduleMigrationDesc = new Label(composite, 64);
        GridData data = new GridData(768);
        data.heightHint = 60;
        data.horizontalIndent = 15;
        data.widthHint = 350;
        moduleMigrationDesc.setLayoutData((Object)data);
        moduleMigrationDesc.setText(J2EEMigrationUIResourceHandler.All_EJB_Web_Application_Client_Modules_Referenced_);
        Label finalInformation = new Label(composite, 64);
        data = new GridData(768);
        data.heightHint = 50;
        data.widthHint = 400;
        finalInformation.setLayoutData((Object)data);
        finalInformation.setText(J2EEMigrationUIResourceHandler.Select_The_Finish_Button_To_Accept_The_Default_);
    }

    private void createJ2EEVersionComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        GridData data = new GridData(768);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        this.j2eeVersionLabel = new Label(composite, 0);
        this.j2eeVersionLabel.setText(J2EEMigrationUIResourceHandler.Version_Level);
        this.j2eeVersionCombo = new Combo(composite, 2056);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.j2eeVersionCombo.setLayoutData((Object)data);
        Control[] deps = new Control[]{this.j2eeVersionLabel};
        this.synchHelper.synchCombo(this.j2eeVersionCombo, "J2EEMigrationConfig.J2EE_MIGRATION_VERSION", deps);
    }

    protected IDataModel getServerTargetDataModel() {
        return this.model.getNestedModel("J2EEMigrationConfig.NESTED_MODEL_SERVER_TARGET");
    }

    protected void createEARLabel(Composite composite) {
        this.earLabel = new Label(composite, 0);
        GridData data = new GridData(768);
        this.earLabel.setLayoutData((Object)data);
    }

    protected void createEARViewer(Composite composite) {
        GridData data = new GridData(1808);
        this.projectViewer = new TreeViewer(composite, 2048);
        data.heightHint = 100;
        this.projectViewer.getTree().setLayoutData((Object)data);
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectViewer.setContentProvider((IContentProvider)new ModulesContentProvider());
        this.projectViewer.setAutoExpandLevel(2);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.etools.j2ee.migration.ui.migr1000");
        this.createEARLabel(composite);
        this.createEARViewer(composite);
        this.setSpacer(composite);
        this.createEARButtons(composite);
        this.addListeners();
        return composite;
    }

    public void enter() {
        super.enter();
        this.earMigrationConfig = ((J2EEMigrationWizard)this.getWizard()).getMigrationConfig();
        if (this.earMigrationConfig != null) {
            this.earLabel.setText(String.valueOf(J2EEMigrationUIResourceHandler.Enterprise_Application_Project_) + " " + this.earMigrationConfig.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME"));
            IVirtualComponent component = (IVirtualComponent)this.earMigrationConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
            this.projectViewer.setInput(Collections.singletonList(component));
        }
    }

    public void exit() {
        super.exit();
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", "IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID", "IJ2EEProjectServerTargetDataModelProperties.PROJECT_NAME", "IJ2EEProjectServerTargetDataModelProperties.UPDATE_MODULES", "IArtifactEditOperationDataModelProperties.PROJECT_NAME", "IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID", "J2EEMigrationConfig.J2EE_MIGRATION_VERSION"};
    }

    public void handleEvent(Event event) {
        if (event.widget != this.projectViewer.getTree()) {
            if (event.widget == this.j2eeMigrationButton) {
                this.earMigrationConfig.setBooleanProperty("IComposedMigrationConfigProperties.migrateVersionForAll", this.j2eeMigrationButton.getSelection());
            } else if (event.widget == this.moduleMigrationButton) {
                this.earMigrationConfig.setBooleanProperty("IComposedMigrationConfigProperties.allAreSelected", this.moduleMigrationButton.getSelection());
                this.validatePage();
            }
        }
        super.handleEvent(event);
    }

    private void loadData() {
    }

    private void setSpacer(Composite composite) {
        Label space = new Label(composite, 0);
        GridData data = new GridData(768);
        space.setLayoutData((Object)data);
    }

    protected void validateControls() {
        this.setErrorMessage();
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(true);
    }

    protected class ModulesContentProvider
    implements ITreeContentProvider {
        private IVirtualComponent earComponent = null;

        protected ModulesContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                List comps = (List)parentElement;
                Object[] projects = new IProject[comps.size()];
                int i = 0;
                while (i < comps.size()) {
                    IVirtualComponent comp = (IVirtualComponent)comps.get(i);
                    IProject project = comp.getProject();
                    if (J2EEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.ear") && this.earComponent == null) {
                        this.earComponent = comp;
                    }
                    projects[i] = ((IVirtualComponent)comps.get(i)).getProject();
                    ++i;
                }
                return projects;
            }
            if (parentElement instanceof IProject && this.earComponent != null) {
                return this.getChildrenForEAR(this.earComponent);
            }
            return null;
        }

        private IProject[] getChildrenForEAR(IVirtualComponent earComponent) {
            EARArtifactEdit earEdit = null;
            earEdit = EARArtifactEdit.getEARArtifactEditForRead((IVirtualComponent)earComponent);
            try {
                if (earEdit != null) {
                    IVirtualReference[] moduleComponentsRefs = earEdit.getJ2EEModuleReferences();
                    ArrayList<IProject> projectsList = new ArrayList<IProject>();
                    IVirtualComponent component = null;
                    int i = 0;
                    while (i < moduleComponentsRefs.length) {
                        component = moduleComponentsRefs[i].getReferencedComponent();
                        if (!component.isBinary()) {
                            projectsList.add(component.getProject());
                        }
                        ++i;
                    }
                    IProject[] iProjectArray = projectsList.toArray(new IProject[projectsList.size()]);
                    return iProjectArray;
                }
            }
            finally {
                if (earEdit != null) {
                    earEdit.dispose();
                }
                earEdit = null;
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof List || element instanceof IVirtualComponent && J2EEProjectUtilities.getJ2EEProjectType((IProject)((IVirtualComponent)element).getProject()).equals("jst.ear");
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

