/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.classpath;

import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.j2ee.migration.classpath.Messages;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainerUtils;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.operations.ValidatorSubsetOperation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class J2EEClasspathValidator
implements IValidatorJob {
    protected IReporter _reporter;

    public static void runValidator(IProject project, boolean async) {
        String validatorID = "com.ibm.etools.j2ee.migration.classpath.J2EEClasspathValidator";
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorID);
        class SingleValidatorOperation
        extends ValidatorSubsetOperation {
            public SingleValidatorOperation(IProject project, ValidatorMetaData vmd, boolean async) {
                super(project, true, async);
                HashSet<ValidatorMetaData> set = new HashSet<ValidatorMetaData>();
                set.add(vmd);
                this.setEnabledValidators(set);
            }
        }
        SingleValidatorOperation op = new SingleValidatorOperation(project, vmd, async);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public void cleanup(IReporter reporter) {
        this._reporter = null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        this._reporter = reporter;
        this._reporter.removeAllMessages((IValidator)this);
        IProject project = (IProject)helper.loadModel("GET_PROJECT", null);
        try {
            this.inspectClasspath(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    public void inspectClasspath(IProject project) throws CoreException {
        List classpathMessages;
        Message referenceMessage;
        if (!(project != null && project.isAccessible() && project.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") && project.hasNature("org.eclipse.jdt.core.javanature"))) {
            return;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component.isBinary() || J2EEProjectUtilities.isEARComponent((IVirtualComponent)component) || !(component instanceof J2EEModuleVirtualComponent)) {
            return;
        }
        String[] oldNatures = null;
        if (J2EEProjectUtilities.isApplicationClientComponent((IVirtualComponent)component)) {
            oldNatures = new String[]{"com.ibm.etools.j2ee.ApplicationClientNature", "com.ibm.etools.j2ee.ApplicationClient_J2EE13_Nature", "com.ibm.wtp.j2ee.ApplicationClientNature"};
        } else if (J2EEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component)) {
            oldNatures = new String[]{"com.ibm.etools.j2ee.WebNature", "com.ibm.wtp.web.WebNature"};
        } else if (J2EEProjectUtilities.isEJBComponent((IVirtualComponent)component)) {
            oldNatures = new String[]{"com.ibm.etools.j2ee.EJBNature", "com.ibm.etools.j2ee.EJB2_0Nature", "com.ibm.wtp.ejb.EJBNature"};
        } else if (J2EEProjectUtilities.isJCAComponent((IVirtualComponent)component)) {
            oldNatures = new String[]{"com.ibm.etools.j2ee.ConnectorNature", "com.ibm.wtp.jca.ConnectorNature"};
        }
        boolean hasOldNatures = false;
        int i = 0;
        while (oldNatures != null && i < oldNatures.length && !hasOldNatures) {
            if (project.hasNature(oldNatures[i])) {
                hasOldNatures = true;
                if (J2EEClasspathValidator.isUsingContainers(component)) {
                    return;
                }
            }
            ++i;
        }
        IVirtualComponent[] earComponents = J2EEProjectUtilities.getReferencingEARComponents((IVirtualComponent)component);
        if (earComponents.length == 0) {
            if (!J2EEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component)) {
                return;
            }
        } else {
            oldNatures = new String[]{"com.ibm.etools.j2ee.EARNature", "com.ibm.etools.j2ee.EAR13Nature", "com.ibm.wtp.j2ee.EARNature"};
            IProject earProject = earComponents[0].getProject();
            int i2 = 0;
            while (i2 < oldNatures.length && !hasOldNatures) {
                if (earProject.hasNature(oldNatures[i2])) {
                    hasOldNatures = true;
                    if (J2EEClasspathValidator.isUsingContainers(component)) {
                        return;
                    }
                }
                ++i2;
            }
        }
        if ((referenceMessage = J2EEClasspathValidator.checkReferences(component, null)) != null) {
            this._reporter.addMessage((IValidator)this, (IMessage)referenceMessage);
        }
        if ((classpathMessages = J2EEClasspathValidator.checkClasspaths(component, null, hasOldNatures)) != null) {
            int i3 = 0;
            while (i3 < classpathMessages.size()) {
                Message message = (Message)classpathMessages.get(i3);
                this._reporter.addMessage((IValidator)this, (IMessage)message);
                ++i3;
            }
        }
    }

    private static boolean isUsingContainers(IVirtualComponent component) {
        boolean useEARLibraries;
        boolean bl = useEARLibraries = J2EEComponentClasspathContainerUtils.getInstalledEARLibrariesContainer((IProject)component.getProject()) != null;
        if (useEARLibraries) {
            if (J2EEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component)) {
                boolean useWebLibraries;
                boolean bl2 = useWebLibraries = J2EEComponentClasspathContainerUtils.getInstalledWebAppLibrariesContainer((IProject)component.getProject()) != null;
                if (useWebLibraries) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static Message checkReferences(IVirtualComponent component, String cleanupType) {
        boolean performCleanup = false;
        if (cleanupType != null) {
            if (cleanupType.equals("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerDuplicateComponent")) {
                performCleanup = true;
            } else {
                return null;
            }
        }
        IVirtualReference[] staticReferences = ((J2EEModuleVirtualComponent)component).getNonManifestReferences();
        ArrayList<IVirtualReference> newEntries = null;
        if (performCleanup) {
            newEntries = new ArrayList<IVirtualReference>();
        }
        if (staticReferences.length > 0) {
            List dynamicReferencesList = J2EEModuleVirtualComponent.getManifestReferences((IVirtualComponent)component, (IVirtualReference[])new IVirtualReference[0]);
            if (dynamicReferencesList == null) {
                return null;
            }
            IVirtualComponent ejbClientComponent = null;
            if (J2EEProjectUtilities.isEJBComponent((IVirtualComponent)component)) {
                EJBArtifactEdit edit = null;
                try {
                    edit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
                    ejbClientComponent = edit.getEJBClientJarModule();
                }
                finally {
                    if (edit != null) {
                        edit.dispose();
                    }
                }
            }
            int i = 0;
            while (i < staticReferences.length) {
                IPath staticReferencePath = staticReferences[i].getRuntimePath();
                if (staticReferencePath != null) {
                    IVirtualComponent staticComponent = staticReferences[i].getReferencedComponent();
                    if (ejbClientComponent == null || !ejbClientComponent.equals(staticComponent)) {
                        boolean shouldInclude = true;
                        int j = 0;
                        while (j < dynamicReferencesList.size() && shouldInclude) {
                            IVirtualComponent dynamicComponent;
                            IVirtualReference dynamicReference = (IVirtualReference)dynamicReferencesList.get(j);
                            IPath dynamicReferencePath = dynamicReference.getRuntimePath();
                            if (staticReferencePath.equals((Object)dynamicReferencePath) && staticComponent.equals(dynamicComponent = dynamicReference.getReferencedComponent())) {
                                if (performCleanup) {
                                    shouldInclude = false;
                                } else {
                                    return J2EEClasspathValidator.getComponentDuplicateMessage(component.getProject(), staticComponent.getProject(), 2);
                                }
                            }
                            ++j;
                        }
                        if (performCleanup && shouldInclude && newEntries != null) {
                            newEntries.add(staticReferences[i]);
                        }
                    }
                }
                ++i;
            }
            if (performCleanup && newEntries != null && newEntries.size() < staticReferences.length) {
                IVirtualReference[] refs = new IVirtualReference[newEntries.size()];
                newEntries.toArray(refs);
                component.setReferences(refs);
            }
        }
        return null;
    }

    public static Message getManifestDuplicateMessage(IProject sourceProject, IProject referencedProject, int severity) {
        LocalizedMessage message = new LocalizedMessage(severity, Messages.bind((String)Messages.J2EEClasspathValidator_0, (Object[])new Object[]{referencedProject.getName()}), (IResource)sourceProject);
        message.setMarkerId("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerDuplicateManifest");
        return message;
    }

    public static Message getWebLibDuplicateMessage(IProject sourceProject, IProject referencedProject, int severity) {
        LocalizedMessage message = new LocalizedMessage(severity, Messages.bind((String)Messages.J2EEClasspathValidator_1, (Object[])new Object[]{referencedProject.getName()}), (IResource)sourceProject);
        message.setMarkerId("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerDuplicateWebLib");
        return message;
    }

    public static Message getManifestMissingMessage(IProject sourceProject, IProject referencedProject, int severity) {
        LocalizedMessage message = new LocalizedMessage(severity, Messages.bind((String)Messages.J2EEClasspathValidator_2, (Object[])new Object[]{referencedProject.getName()}), (IResource)sourceProject);
        message.setMarkerId("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerMissingManifest");
        return message;
    }

    public static Message getManifestMissingMessage(IProject sourceProject, IProject referencedProject, IPath projectRelativePath, int severity) {
        LocalizedMessage message = new LocalizedMessage(severity, Messages.bind((String)Messages.J2EEClasspathValidator_5, (Object[])new Object[]{projectRelativePath.removeFirstSegments(1).toString(), referencedProject.getName()}), (IResource)sourceProject);
        message.setMarkerId("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerMissingManifest");
        return message;
    }

    public static Message getManifestMissingMessage(IProject sourceProject, IPath absoluteDiskPath, int severity) {
        LocalizedMessage message = new LocalizedMessage(severity, Messages.bind((String)Messages.J2EEClasspathValidator_6, (Object[])new Object[]{absoluteDiskPath.toOSString()}), (IResource)sourceProject);
        message.setMarkerId("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerMissingManifest");
        return message;
    }

    public static Message getWebLibMissingMessage(IProject sourceProject, IProject referencedProject, int severity) {
        LocalizedMessage message = new LocalizedMessage(severity, Messages.bind((String)Messages.J2EEClasspathValidator_3, (Object[])new Object[]{referencedProject.getName()}), (IResource)sourceProject);
        message.setMarkerId("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerMissingWebLib");
        return message;
    }

    public static Message getWebLibMissingMessage(IProject sourceProject, IProject referencedProject, IPath projectRelativePath, int severity) {
        LocalizedMessage message = new LocalizedMessage(severity, Messages.bind((String)Messages.J2EEClasspathValidator_7, (Object[])new Object[]{projectRelativePath.removeFirstSegments(1).toString(), referencedProject.getName()}), (IResource)sourceProject);
        message.setMarkerId("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerMissingWebLib");
        return message;
    }

    public static Message getWebLibMissingMessage(IProject sourceProject, IPath absoluteDiskPath, int severity) {
        LocalizedMessage message = new LocalizedMessage(severity, Messages.bind((String)Messages.J2EEClasspathValidator_8, (Object[])new Object[]{absoluteDiskPath.toOSString()}), (IResource)sourceProject);
        message.setMarkerId("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerMissingWebLib");
        return message;
    }

    public static Message getComponentDuplicateMessage(IProject sourceProject, IProject referencedProject, int severity) {
        LocalizedMessage message = new LocalizedMessage(severity, Messages.bind((String)Messages.J2EEClasspathValidator_4, (Object[])new Object[]{referencedProject.getName()}), (IResource)sourceProject);
        message.setMarkerId("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerDuplicateComponent");
        return message;
    }

    public static List checkClasspaths(IVirtualComponent component, String cleanupType) throws CoreException {
        String[] oldNatures = null;
        if (J2EEProjectUtilities.isApplicationClientComponent((IVirtualComponent)component)) {
            oldNatures = new String[]{"com.ibm.etools.j2ee.ApplicationClientNature", "com.ibm.etools.j2ee.ApplicationClient_J2EE13_Nature", "com.ibm.wtp.j2ee.ApplicationClientNature"};
        } else if (J2EEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component)) {
            oldNatures = new String[]{"com.ibm.etools.j2ee.WebNature", "com.ibm.wtp.web.WebNature"};
        } else if (J2EEProjectUtilities.isEJBComponent((IVirtualComponent)component)) {
            oldNatures = new String[]{"com.ibm.etools.j2ee.EJBNature", "com.ibm.etools.j2ee.EJB2_0Nature", "com.ibm.wtp.ejb.EJBNature"};
        } else if (J2EEProjectUtilities.isJCAComponent((IVirtualComponent)component)) {
            oldNatures = new String[]{"com.ibm.etools.j2ee.ConnectorNature", "com.ibm.wtp.jca.ConnectorNature"};
        }
        boolean hasOldNatures = false;
        IProject project = component.getProject();
        int i = 0;
        while (oldNatures != null && i < oldNatures.length && !hasOldNatures) {
            if (project.hasNature(oldNatures[i])) {
                hasOldNatures = true;
            }
            ++i;
        }
        IVirtualComponent[] earComponents = J2EEProjectUtilities.getReferencingEARComponents((IVirtualComponent)component);
        if (earComponents.length != 0) {
            oldNatures = new String[]{"com.ibm.etools.j2ee.EARNature", "com.ibm.etools.j2ee.EAR13Nature", "com.ibm.wtp.j2ee.EARNature"};
            IProject earProject = earComponents[0].getProject();
            int i2 = 0;
            while (i2 < oldNatures.length && !hasOldNatures) {
                if (earProject.hasNature(oldNatures[i2])) {
                    hasOldNatures = true;
                }
                ++i2;
            }
        }
        return J2EEClasspathValidator.checkClasspaths(component, cleanupType, hasOldNatures);
    }

    public static List checkClasspaths(IVirtualComponent component, String cleanupType, boolean hasOldNatures) throws CoreException {
        int j;
        Object[] obj;
        int i;
        int compilerSetting;
        IVirtualReference[] webLibs;
        boolean performCleanup = cleanupType != null;
        ArrayList<Message> messages = new ArrayList<Message>();
        IJavaProject javaProject = JavaCore.create((IProject)component.getProject());
        IClasspathEntry[] rawEntries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> entriesToAdd = null;
        ArrayList<IClasspathEntry> entriesToRemove = null;
        if (cleanupType != null) {
            entriesToAdd = new ArrayList<IClasspathEntry>();
            entriesToRemove = new ArrayList<IClasspathEntry>();
        }
        List manifestRefs = J2EEModuleVirtualComponent.getManifestReferences((IVirtualComponent)component, (IVirtualReference[])new IVirtualReference[0]);
        ArrayList<IVirtualReference> webLibRefs = null;
        if (J2EEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component) && (webLibs = WebUtilities.getLibModules((IProject)component.getProject())) != null && webLibs.length > 0) {
            webLibRefs = new ArrayList<IVirtualReference>();
            int j2 = 0;
            while (j2 < webLibs.length) {
                webLibRefs.add(webLibs[j2]);
                ++j2;
            }
        }
        if (manifestRefs != null) {
            boolean useEARLibraries;
            boolean bl = useEARLibraries = J2EEComponentClasspathContainerUtils.getInstalledEARLibrariesContainer((IProject)component.getProject()) != null;
            if (useEARLibraries) {
                if (!(hasOldNatures || (compilerSetting = J2EEClasspathValidator.getSeverityForCompilerSetting("com.ibm.etools.j2ee.preferences.duplicateManifestClasspath")) != 1 && compilerSetting != 2 || performCleanup && (cleanupType == null || !cleanupType.equals("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerDuplicateManifest")))) {
                    i = 0;
                    while (i < rawEntries.length) {
                        if (rawEntries[i].getEntryKind() == 2 && ((Boolean)(obj = J2EEClasspathValidator.isEntryInRefs(rawEntries[i], manifestRefs))[0]).booleanValue()) {
                            if (performCleanup) {
                                if (entriesToRemove != null) {
                                    entriesToRemove.add(rawEntries[i]);
                                }
                            } else {
                                messages.add(J2EEClasspathValidator.getManifestDuplicateMessage(component.getProject(), (IProject)obj[1], compilerSetting));
                            }
                        }
                        ++i;
                    }
                }
            } else {
                compilerSetting = J2EEClasspathValidator.getSeverityForCompilerSetting("com.ibm.etools.j2ee.preferences.missingManifestClasspath");
                if ((compilerSetting == 1 || compilerSetting == 2) && (!performCleanup || cleanupType != null && cleanupType.equals("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerMissingManifest"))) {
                    j = 0;
                    while (j < manifestRefs.size()) {
                        IVirtualReference ref = (IVirtualReference)manifestRefs.get(j);
                        IVirtualComponent refComp = ref.getReferencedComponent();
                        IProject refProject = refComp.getProject();
                        if (refComp.isBinary()) {
                            VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)refComp;
                            if (!archiveComp.getArchiveType().equals("var")) {
                                IFile iFile;
                                boolean isExternal = true;
                                File diskFile = archiveComp.getUnderlyingDiskFile();
                                Path filePath = null;
                                if (diskFile.exists()) {
                                    filePath = new Path(diskFile.getAbsolutePath());
                                }
                                if ((iFile = archiveComp.getUnderlyingWorkbenchFile()) != null && iFile.exists()) {
                                    filePath = iFile.getFullPath();
                                    isExternal = false;
                                }
                                if (!J2EEClasspathValidator.isAlreadyOnClasspath(rawEntries, (IPath)filePath)) {
                                    if (performCleanup) {
                                        if (entriesToAdd != null) {
                                            entriesToAdd.add(JavaCore.newLibraryEntry((IPath)filePath, null, null, (boolean)false));
                                        }
                                    } else if (isExternal) {
                                        messages.add(J2EEClasspathValidator.getManifestMissingMessage(component.getProject(), (IPath)filePath, compilerSetting));
                                    } else {
                                        messages.add(J2EEClasspathValidator.getManifestMissingMessage(component.getProject(), refProject, (IPath)filePath, compilerSetting));
                                    }
                                }
                            }
                        } else if (!J2EEClasspathValidator.isProjectOnClasspath(refProject, rawEntries)) {
                            if (performCleanup) {
                                if (entriesToAdd != null) {
                                    IClasspathEntry entry = JavaCore.newProjectEntry((IPath)refProject.getFullPath());
                                    entriesToAdd.add(entry);
                                }
                            } else {
                                messages.add(J2EEClasspathValidator.getManifestMissingMessage(component.getProject(), refProject, compilerSetting));
                            }
                        }
                        ++j;
                    }
                }
            }
        }
        if (webLibRefs != null) {
            boolean useWebLibraries;
            boolean bl = useWebLibraries = J2EEComponentClasspathContainerUtils.getInstalledWebAppLibrariesContainer((IProject)component.getProject()) != null;
            if (useWebLibraries) {
                if (!(hasOldNatures || (compilerSetting = J2EEClasspathValidator.getSeverityForCompilerSetting("com.ibm.etools.j2ee.preferences.duplicateWebLibClasspath")) != 1 && compilerSetting != 2 || performCleanup && (cleanupType == null || !cleanupType.equals("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerDuplicateWebLib")))) {
                    i = 0;
                    while (i < rawEntries.length) {
                        if (rawEntries[i].getEntryKind() == 2 && ((Boolean)(obj = J2EEClasspathValidator.isEntryInRefs(rawEntries[i], webLibRefs))[0]).booleanValue()) {
                            if (performCleanup) {
                                if (entriesToRemove != null) {
                                    entriesToRemove.add(rawEntries[i]);
                                }
                            } else {
                                messages.add(J2EEClasspathValidator.getWebLibDuplicateMessage(component.getProject(), (IProject)obj[1], compilerSetting));
                            }
                        }
                        ++i;
                    }
                }
            } else {
                compilerSetting = J2EEClasspathValidator.getSeverityForCompilerSetting("com.ibm.etools.j2ee.preferences.missingWebLibClasspath");
                if ((compilerSetting == 1 || compilerSetting == 2) && (!performCleanup || cleanupType != null && cleanupType.equals("com.ibm.etools.j2ee.migration.ui.J2EEClasspathValidatorMarkerMissingWebLib"))) {
                    j = 0;
                    while (j < webLibRefs.size()) {
                        IVirtualComponent referencedComponent = ((IVirtualReference)webLibRefs.get(j)).getReferencedComponent();
                        if (referencedComponent.isBinary()) {
                            VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)referencedComponent;
                            if (!archiveComp.getArchiveType().equals("var")) {
                                IFile iFile;
                                boolean isExternal = true;
                                File diskFile = archiveComp.getUnderlyingDiskFile();
                                Path filePath = null;
                                if (diskFile.exists()) {
                                    filePath = new Path(diskFile.getAbsolutePath());
                                }
                                if ((iFile = archiveComp.getUnderlyingWorkbenchFile()) != null && iFile.exists()) {
                                    filePath = iFile.getFullPath();
                                    isExternal = false;
                                }
                                if (!J2EEClasspathValidator.isAlreadyOnClasspath(rawEntries, (IPath)filePath)) {
                                    if (performCleanup) {
                                        if (entriesToAdd != null) {
                                            entriesToAdd.add(JavaCore.newLibraryEntry((IPath)filePath, null, null, (boolean)false));
                                        }
                                    } else if (isExternal) {
                                        messages.add(J2EEClasspathValidator.getWebLibMissingMessage(component.getProject(), (IPath)filePath, compilerSetting));
                                    } else {
                                        messages.add(J2EEClasspathValidator.getWebLibMissingMessage(component.getProject(), referencedComponent.getProject(), (IPath)filePath, compilerSetting));
                                    }
                                }
                            }
                        } else {
                            IProject referencedProject = referencedComponent.getProject();
                            if (!J2EEClasspathValidator.isProjectOnClasspath(referencedProject, rawEntries)) {
                                if (performCleanup) {
                                    if (entriesToAdd != null) {
                                        IClasspathEntry entry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                                        entriesToAdd.add(entry);
                                    }
                                } else {
                                    messages.add(J2EEClasspathValidator.getWebLibMissingMessage(component.getProject(), referencedProject, compilerSetting));
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
        }
        if (!(!performCleanup || entriesToAdd == null || entriesToRemove == null || entriesToAdd.isEmpty() && entriesToRemove.isEmpty())) {
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            int i2 = 0;
            while (i2 < rawEntries.length) {
                if (rawEntries[i2].getEntryKind() == 2) {
                    if (!entriesToRemove.contains(rawEntries[i2])) {
                        newEntries.add(rawEntries[i2]);
                    }
                } else {
                    newEntries.add(rawEntries[i2]);
                }
                ++i2;
            }
            newEntries.addAll(entriesToAdd);
            IClasspathEntry[] newRawEntries = new IClasspathEntry[newEntries.size()];
            newEntries.toArray(newRawEntries);
            javaProject.setRawClasspath(newRawEntries, null);
        }
        return messages;
    }

    private static int getSeverityForCompilerSetting(String propertyName) {
        J2EEUIPreferences preferences = J2EEUIPlugin.getDefault().getJ2EEUIPreferences();
        String propertyValue = preferences.getSetting(propertyName);
        if (propertyValue.equals("error")) {
            return 1;
        }
        if (propertyValue.equals("warning")) {
            return 2;
        }
        if (propertyValue.equals("ignore")) {
            return -1;
        }
        return 2;
    }

    private static boolean isProjectOnClasspath(IProject project, IClasspathEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 2 && J2EEClasspathValidator.isProjectEntry(entries[i], project)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Object[] isEntryInRefs(IClasspathEntry entry, List virtualRefs) {
        int i = 0;
        while (i < virtualRefs.size()) {
            IProject referencedProject = ((IVirtualReference)virtualRefs.get(i)).getReferencedComponent().getProject();
            if (J2EEClasspathValidator.isProjectEntry(entry, referencedProject)) {
                return new Object[]{Boolean.TRUE, referencedProject};
            }
            ++i;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = Boolean.FALSE;
        return objectArray;
    }

    public static boolean isProjectEntry(IClasspathEntry entry, IProject project) {
        IPath projectPath = project.getFullPath();
        IPath entryPath = entry.getPath();
        if (entryPath.equals((Object)projectPath)) {
            return true;
        }
        return entryPath.isPrefixOf(projectPath) && !Util.isExcluded((IPath)projectPath, (char[][])((ClasspathEntry)entry).fullInclusionPatternChars(), (char[][])((ClasspathEntry)entry).fullExclusionPatternChars(), (boolean)false);
    }

    private static boolean isAlreadyOnClasspath(IClasspathEntry[] entries, IPath newPath) {
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            IPath entryPath = entry.getPath();
            if (entryPath.equals((Object)newPath)) {
                return true;
            }
            if (entryPath.isPrefixOf(newPath) && !Util.isExcluded((IPath)newPath, (char[][])((ClasspathEntry)entry).fullInclusionPatternChars(), (char[][])((ClasspathEntry)entry).fullExclusionPatternChars(), (boolean)false)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

