/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee13.commands;

import com.ibm.etools.j2ee.commands.CommandExecutionFailure;
import com.ibm.etools.j2ee13.commands.MessageDrivenCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.ejb.AcknowledgeMode;
import org.eclipse.jst.j2ee.ejb.ActivationConfig;
import org.eclipse.jst.j2ee.ejb.ActivationConfigProperty;
import org.eclipse.jst.j2ee.ejb.DestinationType;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.MessageDrivenDestination;
import org.eclipse.jst.j2ee.ejb.SubscriptionDurabilityKind;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;

public class CreateMessageDrivenCommand
extends MessageDrivenCommand {
    public CreateMessageDrivenCommand(String aName, EJBArtifactEdit anArtifactEdit) {
        super(aName, anArtifactEdit);
    }

    @Override
    public String getTaskName() {
        return this.getCreatingTaskName();
    }

    @Override
    public boolean isCreateCommand() {
        return true;
    }

    @Override
    public boolean shouldGenerateJava() {
        return this.shouldGenerateJavaForModify();
    }

    @Override
    protected void executeForMetadataGeneration() throws CommandExecutionFailure {
        JavaHelpers helpers;
        super.executeForMetadataGeneration();
        MessageDriven mdb = this.getMessageDrivenBean();
        mdb.setTransactionType(this.getTransactionType());
        if (!this.isContainerManaged && this.getAcknowledgeMode() != null) {
            mdb.setAcknowledgeMode((AcknowledgeMode)this.getAcknowledgeMode().getInstance());
        }
        if (this.getMessageSelector() != null && this.getMessageSelector().length() > 0) {
            mdb.setMessageSelector(this.getMessageSelector());
        }
        if (this.getDestinationType() != null || this.getSubscriptionDurability() != null) {
            if (mdb.getVersionID() == 21) {
                this.create14Destination();
            } else {
                this.createDestination();
            }
        }
        if (mdb.getVersionID() == 21) {
            this.createDestinationLink();
        }
        if (this.getListenerPortName() != null) {
            this.listenerPortName.length();
        }
        if (this.getMessagingType() != null && this.getMessagingType().length() > 0 && (helpers = JavaRefFactory.eINSTANCE.reflectType(this.getMessagingType(), (EObject)mdb)) != null) {
            mdb.setMessagingType((JavaClass)helpers);
        }
        if (mdb.getVersionID() == 21) {
            this.createActivationConfigElements();
        }
    }

    private void createDestinationLink() {
        if (this.getDestinationLink() != null && this.getDestinationLink().length() > 0) {
            this.getMessageDrivenBean().setLink(this.getDestinationLink());
        }
    }

    private void create14Destination() {
        JavaHelpers helper;
        EEnumLiteral destinationType = this.getDestinationType();
        DestinationType type = DestinationType.get((int)destinationType.getValue());
        String typeString = null;
        if (type != null) {
            switch (type.getValue()) {
                case 0: {
                    typeString = "javax.jms.Queue";
                    break;
                }
                case 1: {
                    typeString = "javax.jms.Topic";
                }
            }
        }
        if ((helper = JavaRefFactory.eINSTANCE.reflectType(typeString, this.getMessageDrivenBean().eContainer())) != null) {
            this.getMessageDrivenBean().setMessageDestination(helper.getWrapper());
        }
    }

    protected void createActivationConfigElements() {
        ActivationConfig config = this.getEJBFactory().createActivationConfig();
        if (this.getActivationConfig() != null && !this.getActivationConfig().getConfigProperties().isEmpty()) {
            this.getMessageDrivenBean().setActivationConfig(config);
            EList configProperties = this.getActivationConfig().getConfigProperties();
            int i = 0;
            while (i < configProperties.size()) {
                ActivationConfigProperty modelProperty = (ActivationConfigProperty)configProperties.get(i);
                ActivationConfigProperty property = this.getEJBFactory().createActivationConfigProperty();
                property.setName(modelProperty.getName());
                property.setValue(modelProperty.getValue());
                this.getMessageDrivenBean().getActivationConfig().getConfigProperties().add((Object)property);
                ++i;
            }
        }
    }

    protected void createDestination() throws CommandExecutionFailure {
        MessageDrivenDestination dest = this.getEJBFactory().createMessageDrivenDestination();
        if (this.getDestinationType() != null) {
            dest.setType((DestinationType)this.getDestinationType().getInstance());
        }
        if (this.getSubscriptionDurability() != null) {
            dest.setSubscriptionDurability((SubscriptionDurabilityKind)this.getSubscriptionDurability().getInstance());
        }
        this.getMessageDrivenBean().setDestination(dest);
    }
}

