/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ejb.creation.operations;

import com.ibm.etools.j2ee.ejb.EjbPlugin;
import com.ibm.etools.j2ee.ejb.creation.operations.ClientViewModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBCreationResourceHandler;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class ClientViewSEIDataModel
extends ClientViewModel {
    private static final String SERVICE = "Service";
    public static final String SHOULD_CREATE_NEW_SEI_INTERFACE = "ClientViewSEIDataModel.SHOULD_CREATE_NEW_SEI_INTERFACE";
    public static final String SHOULD_COPY_SEI_INTERFACE = "ClientViewSEIDataModel.SHOULD_COPY_SEI_INTERFACE";
    public static final String IS_SEI_SELECTED = "ClientViewSEIDataModel.IS_SEI_SELECTED";
    public static final String SEI_INTERFACE_EXISTING = "ClientViewSEIDataModel.SEI_INTERFACE_EXISTING";
    public static final String SEI_EXISTING_NAME = "ClientViewSEIDataModel.SEI_EXISTING_NAME";
    public static final String SEI_METHOD_COLLECTION = "ClientViewSEIDataModel.SEI_METHOD_COLLECTION";
    public static final String SHOULD_DELETE_SEI = "ClientViewSEIDataModel.SHOULD_DELETE_SEI";
    public static final String SHOULD_COPY_REMOTE_METHODS_TO_NEW = "ClientViewSEIDataModel.SHOULD_COPY_REMOTE_METHODS_TO_NEW";
    public static final String SHOULD_COPY_LOCAL_METHODS_TO_NEW = "ClientViewSEIDataModel.SHOULD_COPY_LOCAL_METHODS_TO_NEW";
    public static final String SHOULD_COPY_SEI_METHODS_TO_NEW = "ClientViewSEIDataModel.SHOULD_COPY_SEI_METHODS_TO_NEW";
    private static final String SEI_INTERFACE_TYPE = "java.rmi.Remote";

    public ClientViewSEIDataModel() {
        this.setProperty(SEI_METHOD_COLLECTION, new ArrayList());
    }

    public ClientViewSEIDataModel(EnterpriseBean ejbBean) {
        super(ejbBean);
        this.setProperty(SEI_METHOD_COLLECTION, new ArrayList());
    }

    @Override
    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(SHOULD_CREATE_NEW_SEI_INTERFACE);
        this.addValidBaseProperty(SHOULD_COPY_SEI_INTERFACE);
        this.addValidBaseProperty(IS_SEI_SELECTED);
        this.addValidBaseProperty(SEI_INTERFACE_EXISTING);
        this.addValidBaseProperty(SEI_EXISTING_NAME);
        this.addValidBaseProperty(SEI_METHOD_COLLECTION);
        this.addValidBaseProperty(SHOULD_COPY_SEI_METHODS_TO_NEW);
        this.addValidBaseProperty(SHOULD_DELETE_SEI);
        this.addValidBaseProperty(SHOULD_COPY_REMOTE_METHODS_TO_NEW);
        this.addValidBaseProperty(SHOULD_COPY_LOCAL_METHODS_TO_NEW);
    }

    public void setSEISelected(boolean selection) {
        this.setBooleanProperty(IS_SEI_SELECTED, selection);
    }

    public boolean isSEISelected() {
        return this.getBooleanProperty(IS_SEI_SELECTED);
    }

    public String getSEIExistingName() {
        if (this.getProperty(SEI_EXISTING_NAME) == null) {
            StringBuffer b = new StringBuffer();
            b.append(this.getPackageName()).append(".").append(this.getEjbBean().getName()).append(SERVICE);
            this.setProperty(SEI_EXISTING_NAME, b.toString());
        }
        return (String)this.getProperty(SEI_EXISTING_NAME);
    }

    public void setSEIExistingName(String seiExistingName) {
        this.setProperty(SEI_EXISTING_NAME, seiExistingName);
    }

    public List getSEIMethodCollection() {
        return (List)this.getProperty(SEI_METHOD_COLLECTION);
    }

    public void setSEIMethodCollection(List seiMethodCollection) {
        this.setProperty(SEI_METHOD_COLLECTION, seiMethodCollection);
    }

    public void setSEIExisting(JavaClass seiExisting) {
        this.setProperty(SEI_INTERFACE_EXISTING, seiExisting);
    }

    public JavaClass getSEIExisting() {
        return (JavaClass)this.getProperty(SEI_INTERFACE_EXISTING);
    }

    public boolean shouldCreateSEICommand() {
        return this.getBooleanProperty(SHOULD_CREATE_NEW_SEI_INTERFACE);
    }

    public void setShouldCreateSEICommand(boolean shouldCreateSEI) {
        this.setBooleanProperty(SHOULD_CREATE_NEW_SEI_INTERFACE, shouldCreateSEI);
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals("ClientViewDataModel.SHOULD_DELETE_INTERFACE") || propertyName.equals("ClientViewDataModel.SHOULD_REMOVE_INTERFACE")) {
            return this.validateInterfaceDelete(this.getBooleanProperty(propertyName));
        }
        if (propertyName.equals("ClientViewDataModel.SHOULD_DELETE_LOCAL") || propertyName.equals("ClientViewDataModel.SHOULD_DELETE_REMOTE") || propertyName.equals(SHOULD_DELETE_SEI)) {
            return this.validateDelete(this.getBooleanProperty(propertyName));
        }
        if (propertyName.equals("ClientViewDataModel.SHOULD_CREATE_LOCAL_COMMAND") || propertyName.equals("ClientViewDataModel.SHOULD_CREATE_REMOTE_COMMAND") || propertyName.equals(SHOULD_CREATE_NEW_SEI_INTERFACE)) {
            return this.validateCreate(this.getBooleanProperty(propertyName));
        }
        if (propertyName.equals("ClientViewDataModel.HOME_EXISTING_NAME")) {
            return this.validateHomeExistingName(this.getStringProperty("ClientViewDataModel.HOME_EXISTING_NAME"));
        }
        if (propertyName.equals("ClientViewDataModel.REMOTE_EXISTING_NAME")) {
            return this.validateRemoteExistingName(this.getStringProperty("ClientViewDataModel.REMOTE_EXISTING_NAME"));
        }
        if (propertyName.equals("ClientViewDataModel.LOCAL_HOME_EXISTING_NAME")) {
            return this.validateLocalHomeExistingName(this.getStringProperty("ClientViewDataModel.LOCAL_HOME_EXISTING_NAME"));
        }
        if (propertyName.equals("ClientViewDataModel.LOCAL_EXISTING_NAME")) {
            return this.validateLocalExistingName(this.getStringProperty("ClientViewDataModel.LOCAL_EXISTING_NAME"));
        }
        if (propertyName.equals(SEI_EXISTING_NAME)) {
            return this.validateSEIExistingName(this.getStringProperty(SEI_EXISTING_NAME));
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateDelete(boolean value) {
        if (this.getBooleanProperty("ClientViewDataModel.SHOULD_DELETE_LOCAL") && this.getBooleanProperty("ClientViewDataModel.SHOULD_DELETE_REMOTE") || this.getBooleanProperty("ClientViewDataModel.SHOULD_DELETE_LOCAL") && !this.hasRemoteInterfaces() || this.getBooleanProperty("ClientViewDataModel.SHOULD_DELETE_REMOTE") && !this.hasLocalInterfaces()) {
            return WTPCommonPlugin.createErrorStatus((String)EJBCreationResourceHandler.CANNOT_REMOVE_BOTH_LOCAL_AND_REMOTE);
        }
        if (!(this.getBooleanProperty("ClientViewDataModel.SHOULD_DELETE_LOCAL") || this.getBooleanProperty("ClientViewDataModel.SHOULD_DELETE_REMOTE") || this.getBooleanProperty(SHOULD_DELETE_SEI))) {
            return WTPCommonPlugin.createErrorStatus((String)EJBCreationResourceHandler.SELECT_ONE_OR_MORE_VIEWS);
        }
        if (this.hasEjbSubTypes()) {
            return WTPCommonPlugin.createErrorStatus((String)EJBCreationResourceHandler.CLIENT_VIEW_ERR_DELETE_SUPERCLASS);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateCreate(boolean b) {
        if (!(this.getBooleanProperty("ClientViewDataModel.SHOULD_CREATE_LOCAL_COMMAND") || this.getBooleanProperty("ClientViewDataModel.SHOULD_CREATE_REMOTE_COMMAND") || this.getBooleanProperty(SHOULD_CREATE_NEW_SEI_INTERFACE))) {
            return WTPCommonPlugin.createErrorStatus((String)EJBCreationResourceHandler.AN_OPERATION_MUST_BE_SELECTED);
        }
        if (this.getBooleanProperty("ClientViewDataModel.SHOULD_CREATE_LOCAL_COMMAND") && this.getBooleanProperty(SHOULD_CREATE_NEW_SEI_INTERFACE) || this.getBooleanProperty("ClientViewDataModel.SHOULD_CREATE_REMOTE_COMMAND") && this.getBooleanProperty(SHOULD_CREATE_NEW_SEI_INTERFACE)) {
            return WTPCommonPlugin.createErrorStatus((String)EJBCreationResourceHandler.ONLY_ONE_VIEW_CREATE);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    @Override
    public List getMethodCollection() {
        Session sessionBean;
        ArrayList methodList = new ArrayList();
        if (this.shouldCopyLocal() && this.getEjbBean().getLocalInterface() != null && this.getEjbBean().getLocalInterface().getMethods() != null) {
            methodList.addAll(this.getEjbBean().getLocalInterface().getMethods());
        }
        if (this.shouldCopyRemote() && this.getEjbBean().getRemoteInterface() != null && this.getEjbBean().getRemoteInterface().getMethods() != null) {
            methodList.addAll(this.getEjbBean().getRemoteInterface().getMethods());
        }
        if (this.shouldCopySEI() && (sessionBean = (Session)this.getEjbBean()).getServiceEndpoint() != null && sessionBean.getServiceEndpoint().getMethods() != null) {
            methodList.addAll(sessionBean.getServiceEndpoint().getMethods());
        }
        return methodList;
    }

    @Override
    public List getHomeMethodCollection() {
        ArrayList homeMethodList = new ArrayList();
        if (this.shouldCopyLocal() && this.getEjbBean().getLocalHomeInterface() != null && this.getEjbBean().getLocalHomeInterface().getMethods() != null) {
            homeMethodList.addAll(this.getEjbBean().getLocalHomeInterface().getMethods());
        }
        if (this.shouldCopyRemote() && this.getEjbBean().getHomeInterface() != null && this.getEjbBean().getHomeInterface().getMethods() != null) {
            homeMethodList.addAll(this.getEjbBean().getHomeInterface().getMethods());
        }
        return homeMethodList;
    }

    public void setShouldDeleteSEI(boolean b) {
        this.setBooleanProperty(SHOULD_DELETE_SEI, b);
    }

    public boolean shouldDeleteSEI() {
        return this.getBooleanProperty(SHOULD_DELETE_SEI);
    }

    public void setShouldCopyRemote(boolean b) {
        this.setLocalFromRemote(b);
        this.setBooleanProperty(SHOULD_COPY_REMOTE_METHODS_TO_NEW, b);
    }

    public boolean shouldCopyRemote() {
        return this.getBooleanProperty(SHOULD_COPY_REMOTE_METHODS_TO_NEW);
    }

    public void setShouldCopyLocal(boolean b) {
        this.setRemoteFromLocal(b);
        this.setBooleanProperty(SHOULD_COPY_LOCAL_METHODS_TO_NEW, b);
    }

    public boolean shouldCopyLocal() {
        return this.getBooleanProperty(SHOULD_COPY_LOCAL_METHODS_TO_NEW);
    }

    public void setShouldCopySEI(boolean b) {
        this.setBooleanProperty(SHOULD_COPY_SEI_METHODS_TO_NEW, b);
    }

    public boolean shouldCopySEI() {
        return this.getBooleanProperty(SHOULD_COPY_SEI_METHODS_TO_NEW);
    }

    protected IStatus validateSEIExistingName(String serviceEndpointInterface) {
        if (!this.getBooleanProperty(SHOULD_CREATE_NEW_SEI_INTERFACE)) {
            return OK_STATUS;
        }
        if (serviceEndpointInterface == null || serviceEndpointInterface.length() < 1) {
            return EjbPlugin.createStatus(4, EJBCreationResourceHandler.Enter_service_endpoint_name_UI_, null);
        }
        String pkg = this.getPackageName(serviceEndpointInterface);
        if (pkg == null || pkg.trim().length() == 0) {
            return EjbPlugin.createStatus(4, EJBCreationResourceHandler.ServiceEndpoint_interface_cannot_be_UI_, null);
        }
        IStatus status = this.validateJavaTypeName(serviceEndpointInterface, "Service_endpoint_interface_UI_");
        if (!status.isOK()) {
            return status;
        }
        status = this.validateNoCollisions(serviceEndpointInterface, this.getCollisionList(SEI_EXISTING_NAME));
        if (!status.isOK()) {
            return status;
        }
        return this.validateInterfaceType(serviceEndpointInterface, SEI_INTERFACE_TYPE);
    }

    @Override
    protected String[] getCollisionList(String type) {
        String[] collisionList = null;
        if (type != null) {
            if (type.equals("ClientViewDataModel.HOME_EXISTING_NAME")) {
                collisionList = new String[]{"ClientViewDataModel.BEAN_EXISTING_NAME", "ClientViewDataModel.LOCAL_EXISTING_NAME", "ClientViewDataModel.REMOTE_EXISTING_NAME", "ClientViewDataModel.LOCAL_HOME_EXISTING_NAME", SEI_EXISTING_NAME};
            } else if (type.equals("ClientViewDataModel.REMOTE_EXISTING_NAME")) {
                collisionList = new String[]{"ClientViewDataModel.BEAN_EXISTING_NAME", "ClientViewDataModel.LOCAL_EXISTING_NAME", "ClientViewDataModel.HOME_EXISTING_NAME", "ClientViewDataModel.LOCAL_HOME_EXISTING_NAME", SEI_EXISTING_NAME};
            } else if (type.equals("ClientViewDataModel.LOCAL_EXISTING_NAME")) {
                collisionList = new String[]{"ClientViewDataModel.BEAN_EXISTING_NAME", "ClientViewDataModel.HOME_EXISTING_NAME", "ClientViewDataModel.REMOTE_EXISTING_NAME", "ClientViewDataModel.LOCAL_HOME_EXISTING_NAME", SEI_EXISTING_NAME};
            } else if (type.equals("ClientViewDataModel.LOCAL_HOME_EXISTING_NAME")) {
                collisionList = new String[]{"ClientViewDataModel.BEAN_EXISTING_NAME", "ClientViewDataModel.HOME_EXISTING_NAME", "ClientViewDataModel.REMOTE_EXISTING_NAME", "ClientViewDataModel.LOCAL_EXISTING_NAME", SEI_EXISTING_NAME};
            } else if (type.equals(SEI_EXISTING_NAME)) {
                collisionList = new String[]{"ClientViewDataModel.BEAN_EXISTING_NAME", "ClientViewDataModel.HOME_EXISTING_NAME", "ClientViewDataModel.REMOTE_EXISTING_NAME", "ClientViewDataModel.LOCAL_EXISTING_NAME", "ClientViewDataModel.LOCAL_HOME_EXISTING_NAME"};
            }
        }
        return collisionList;
    }
}

