/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ejb;

import com.ibm.etools.j2ee.ejb.EJBNatureRuntime;
import com.ibm.etools.j2ee.ejb.EjbPlugin;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;

public class EJBFileCacheUtil {
    private static final IContainer[] NO_CONTAINERS = new IContainer[0];

    public static boolean endsIn(IPath relPath, IPath fullPath) {
        if (relPath == null || fullPath == null || relPath == Path.EMPTY || fullPath == Path.EMPTY) {
            return false;
        }
        String[] fullSeg = fullPath.segments();
        String[] relSeg = relPath.segments();
        if (relSeg.length > fullSeg.length) {
            return false;
        }
        int fullIdx = fullSeg.length - 1;
        int relIdx = relSeg.length - 1;
        while (fullIdx >= 0 && relIdx >= 0) {
            if (!fullSeg[fullIdx].equals(relSeg[relIdx])) {
                return false;
            }
            --fullIdx;
            --relIdx;
        }
        return true;
    }

    public static IResource getAbsoluteChild(IPath relPath, IContainer container) {
        Vector children = new Vector();
        EJBFileCacheUtil.getAllChildren((IResource)container, children);
        int c = 0;
        while (c < children.size()) {
            IResource child = (IResource)children.elementAt(c);
            if (EJBFileCacheUtil.endsIn(relPath, child.getFullPath())) {
                return child;
            }
            ++c;
        }
        return null;
    }

    public static void getAllChildren(IResource resource, Vector allChildren) {
        if (!resource.exists()) {
            return;
        }
        allChildren.addElement(resource);
        if (resource instanceof IContainer) {
            try {
                IResource[] children = ((IContainer)resource).members();
                int i = 0;
                while (i < children.length) {
                    EJBFileCacheUtil.getAllChildren(children[i], allChildren);
                    ++i;
                }
            }
            catch (CoreException exc) {
                EjbPlugin.logWarning(exc.getMessage());
            }
        }
    }

    private static IPath getContainerRelativePath(IPath path, IContainer container) {
        IPath containerPath;
        int matchingSegments;
        if (path == null || container == null) {
            return null;
        }
        if (path.isAbsolute() && (matchingSegments = (containerPath = container.getFullPath()).matchingFirstSegments(path)) == containerPath.segmentCount()) {
            return path.removeFirstSegments(matchingSegments);
        }
        return null;
    }

    public static IJavaProject getJavaProject(IProject project) {
        EJBNatureRuntime ejbNature;
        block5: {
            ejbNature = null;
            if (project == null) {
                return null;
            }
            try {
                if (project.hasNature("org.eclipse.jst.j2ee.ejb.EJBNature")) break block5;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        ejbNature = EJBNatureRuntime.getRuntime(project);
        if (ejbNature == null) {
            return null;
        }
        return JemProjectUtilities.getJavaProject((IProject)project);
    }

    public static IContainer[] getProjectOutputContainers(IProject project) {
        if (project == null) {
            return NO_CONTAINERS;
        }
        IJavaProject jp = EJBFileCacheUtil.getJavaProject(project);
        if (jp == null) {
            return NO_CONTAINERS;
        }
        return EJBFileCacheUtil.getProjectOutputContainers(jp);
    }

    public static IContainer[] getProjectOutputContainers(IJavaProject javaProject) {
        if (javaProject == null) {
            return NO_CONTAINERS;
        }
        IProject project = javaProject.getProject();
        IPath outputPath = null;
        try {
            outputPath = javaProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            return NO_CONTAINERS;
        }
        if (outputPath == null) {
            return NO_CONTAINERS;
        }
        IPath relOutputPath = EJBFileCacheUtil.getContainerRelativePath(outputPath, (IContainer)project);
        if (relOutputPath == null) {
            return NO_CONTAINERS;
        }
        IResource outputResource = project.findMember(relOutputPath);
        if (!(outputResource instanceof IContainer)) {
            return NO_CONTAINERS;
        }
        return new IContainer[]{(IContainer)outputResource};
    }

    public static IContainer[] getProjectSourceContainers(IProject project) {
        if (project == null) {
            return NO_CONTAINERS;
        }
        IJavaProject jp = EJBFileCacheUtil.getJavaProject(project);
        if (jp == null) {
            return NO_CONTAINERS;
        }
        return EJBFileCacheUtil.getProjectSourceContainers(jp);
    }

    public static IContainer[] getProjectSourceContainers(IJavaProject javaProject) {
        if (javaProject == null) {
            return NO_CONTAINERS;
        }
        IProject project = javaProject.getProject();
        IClasspathEntry[] classpath = null;
        try {
            classpath = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            return NO_CONTAINERS;
        }
        if (classpath == null) {
            return NO_CONTAINERS;
        }
        Vector<IResource> icontainers = new Vector<IResource>();
        int i = 0;
        while (i < classpath.length) {
            IResource outputResource;
            IPath entryPath;
            IPath relEntryPath;
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 3 && (relEntryPath = EJBFileCacheUtil.getContainerRelativePath(entryPath = entry.getPath(), (IContainer)project)) != null && (outputResource = project.findMember(relEntryPath)) != null && outputResource instanceof IContainer) {
                icontainers.addElement(outputResource);
            }
            ++i;
        }
        IContainer[] containers = new IContainer[icontainers.size()];
        int c = 0;
        while (c < icontainers.size()) {
            containers[c] = (IContainer)icontainers.get(c);
            ++c;
        }
        return containers;
    }
}

