/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commands;

import com.ibm.etools.ejb.codegen.helpers.EJBCodegenHandlerExtensionReader;
import com.ibm.etools.ejb.codegen.helpers.IEJBCodegenHandler;
import com.ibm.etools.j2ee.commands.EJBCommandCopyGroup;
import com.ibm.etools.j2ee.commands.EJBCopyGroup;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBRelation;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Relationships;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBJarResourceFactory;
import org.eclipse.wst.common.internal.emf.utilities.CopyGroup;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class EJBCommandCopier {
    protected static final Adapter CODEGEN_COPY_ADAPTER = new AdapterImpl();
    protected EtoolsCopyUtility copyUtility;
    protected ResourceSet copyResourceSet;
    protected EJBArtifactEdit artifactEdit;
    protected EJBJar originalEjbJar;

    public static boolean isCodegenCopy(Notifier anObject) {
        if (anObject != null) {
            return anObject.eAdapters().contains((Object)CODEGEN_COPY_ADAPTER);
        }
        return false;
    }

    public static void flagAsCodegenCopy(Notifier anObject) {
        anObject.eAdapters().add((Object)CODEGEN_COPY_ADAPTER);
    }

    public EJBCommandCopier(EJBArtifactEdit anArtifactEdit) {
        this.artifactEdit = anArtifactEdit;
        this.initialize();
    }

    protected void initialize() {
        this.copyUtility = new EtoolsCopyUtility();
        this.copyUtility.setPreserveIds(true);
    }

    void reset() {
        this.initialize();
    }

    protected ResourceSet getCopyResourceSet() {
        if (this.copyResourceSet == null) {
            this.copyResourceSet = new ResourceSetImpl();
            this.copyResourceSet.setResourceFactoryRegistry(this.createResourceFactoryRegistry());
        }
        return this.copyResourceSet;
    }

    private Resource.Factory.Registry createResourceFactoryRegistry() {
        J2EEResourceFactoryRegistry reg = new J2EEResourceFactoryRegistry();
        reg.registerLastFileSegment("ejb-jar.xml", EJBJarResourceFactory.getRegisteredFactory());
        return reg;
    }

    protected EjbFactory getEjbFactory() {
        return ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory();
    }

    protected EObject getCopy(EObject original) {
        return this.copyUtility.getCopy(original);
    }

    public void copy(EnterpriseBean ejb) {
        if (ejb == null || ejb.getEjbJar() == null) {
            return;
        }
        int before = this.getNumberOfCopied20Relationships();
        this.doCopy(ejb);
        int after = this.getNumberOfCopied20Relationships();
        if (before != after) {
            this.order20Relationships();
        }
    }

    private int getNumberOfCopied20Relationships() {
        Relationships rel;
        if (this.originalEjbJar != null && this.originalEjbJar.getVersionID() >= 20 && (rel = (Relationships)this.copyUtility.getCopy((EObject)this.originalEjbJar.getRelationshipList())) != null) {
            return rel.getEjbRelations().size();
        }
        return 0;
    }

    protected void doCopy(EnterpriseBean ejb) {
        if (ejb == null) {
            return;
        }
        EJBCommandCopyGroup baseCopyGrp = new EJBCommandCopyGroup(ejb, this.artifactEdit);
        if (baseCopyGrp.shouldAddCopiedResources()) {
            baseCopyGrp.setCopyContext(this.getCopyResourceSet());
        }
        this.doCopy(baseCopyGrp);
    }

    protected void doCopy(List aListOfEJBs) {
        if (aListOfEJBs == null) {
            return;
        }
        EJBCopyGroup baseCopyGrp = new EJBCopyGroup(aListOfEJBs, this.artifactEdit);
        this.doCopy(baseCopyGrp);
    }

    protected void doCopy(EJBCopyGroup baseCopyGrp) {
        CopyGroup extCopy;
        boolean addCopyResources = baseCopyGrp.shouldAddCopiedResources();
        if (baseCopyGrp != null) {
            this.copyUtility.copy((CopyGroup)baseCopyGrp);
        }
        if (addCopyResources && (extCopy = this.createExtensionCopyGroup(baseCopyGrp)) != null) {
            extCopy.setCopyContext(this.getCopyResourceSet());
            this.copyUtility.copy(extCopy);
        }
    }

    private void order20Relationships() {
        Relationships originalRel;
        if (this.originalEjbJar != null && this.originalEjbJar.getVersionID() >= 20 && (originalRel = this.originalEjbJar.getRelationshipList()) != null) {
            Relationships copyRel = (Relationships)this.copyUtility.getCopy((EObject)originalRel);
            EList copyRelations = copyRel.getEjbRelations();
            if (copyRelations.isEmpty() || copyRelations.size() == 1) {
                return;
            }
            EList originalRelations = originalRel.getEjbRelations();
            int origSize = originalRelations.size();
            int copySize = copyRelations.size();
            ArrayList<EJBRelation> ordered = new ArrayList<EJBRelation>(copySize);
            int i = 0;
            while (i < origSize && ordered.size() != copySize) {
                EJBRelation original = (EJBRelation)originalRelations.get(i);
                EJBRelation copy = (EJBRelation)this.copyUtility.getCopy((EObject)original);
                if (copy != null && copyRelations.contains(copy)) {
                    ordered.add(copy);
                }
                ++i;
            }
            copyRel.eSetDeliver(false);
            try {
                copyRelations.clear();
                copyRelations.addAll(ordered);
            }
            finally {
                copyRel.eSetDeliver(true);
            }
        }
    }

    public void copy(List aListOfEJBs) {
        int before = this.getNumberOfCopied20Relationships();
        this.doCopy(aListOfEJBs);
        int after = this.getNumberOfCopied20Relationships();
        if (before != after) {
            this.order20Relationships();
        }
    }

    protected CopyGroup createExtensionCopyGroup(EJBCopyGroup ejbCopyGrp) {
        IEJBCodegenHandler handler = this.getCodegenHandler();
        if (handler != null) {
            return handler.getEJBExtensionCopyGroup(ejbCopyGrp, this.artifactEdit);
        }
        return null;
    }

    protected IEJBCodegenHandler getCodegenHandler() {
        if (this.artifactEdit != null) {
            return EJBCodegenHandlerExtensionReader.getInstance().getEJBExtHandler(ProjectUtilities.getProject((EObject)this.artifactEdit.getContentModelRoot()));
        }
        return EJBCodegenHandlerExtensionReader.getInstance().getEJBExtHandler(null);
    }

    public EtoolsCopyUtility getCopyUtility() {
        return this.copyUtility;
    }

    public void dispose() {
        this.copyUtility = null;
    }
}

