/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commands;

import com.ibm.etools.ejb.codegen.helpers.EJBGenerationHelper;
import com.ibm.etools.ejb.codegen.helpers.PrimaryKeyHelper;
import com.ibm.etools.j2ee.commands.CommandExecutionFailure;
import com.ibm.etools.j2ee.commands.EJBClassReferenceCommand;
import com.ibm.etools.j2ee.commands.IRootCommand;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.internal.util.CMPKeySynchronizationAdapter;
import org.eclipse.jst.j2ee.internal.common.CMPJavaChangeSynchronizationAdapter;

public class CreatePrimaryKeyClassCommand
extends EJBClassReferenceCommand {
    private Adapter keyAdapter = null;
    private Adapter javaKeyAdapter = null;

    public CreatePrimaryKeyClassCommand(IRootCommand parent, JavaClass aJavaClass) {
        super(parent, aJavaClass);
    }

    public CreatePrimaryKeyClassCommand(IRootCommand parent, JavaClass aJavaClass, boolean shouldGenJava) {
        super(parent, aJavaClass, shouldGenJava);
    }

    public CreatePrimaryKeyClassCommand(IRootCommand parent, JavaClass aJavaClass, boolean shouldGenJava, boolean shouldGenMetadata) {
        super(parent, aJavaClass, shouldGenJava, shouldGenMetadata);
    }

    public CreatePrimaryKeyClassCommand(IRootCommand parent, String aJavaClassName, String aPackageName) {
        super(parent, aJavaClassName, aPackageName);
    }

    public CreatePrimaryKeyClassCommand(IRootCommand parent, String aJavaClassName, String aPackageName, boolean shouldGenJava) {
        super(parent, aJavaClassName, aPackageName, shouldGenJava);
    }

    public CreatePrimaryKeyClassCommand(IRootCommand parent, String aJavaClassName, String aPackageName, boolean shouldGenJava, boolean shouldGenMetadata) {
        super(parent, aJavaClassName, aPackageName, shouldGenJava, shouldGenMetadata);
    }

    @Override
    protected EJBGenerationHelper createCodegenHelper() {
        return new PrimaryKeyHelper((EObject)this.getJavaClass());
    }

    @Override
    protected EJBGenerationHelper createInverseCodegenHelper() {
        return new PrimaryKeyHelper((EObject)this.getOriginalJavaClass());
    }

    @Override
    protected void executeForMetadataGeneration() {
        super.executeForMetadataGeneration();
        if (this.getEjb() == null) {
            this.failedSettingClass();
            return;
        }
        JavaClass pkClass = this.getJavaClass();
        try {
            if (pkClass == null) {
                this.disableCMPChangeSynchronizationAdapters(true);
                this.getEntity().setPrimaryKeyName(this.getQualifiedName());
                this.setJavaClass(this.getEntity().getPrimaryKey());
            } else {
                this.disableCMPChangeSynchronizationAdapters(false);
                this.getEntity().setPrimaryKey(pkClass);
                this.updatePrimKeyField(pkClass);
            }
        }
        finally {
            this.enableCMPChangeSynchronizationAdapters();
        }
    }

    private void disableCMPChangeSynchronizationAdapters(boolean disableKeySynchronizer) {
        EList adapters = this.getEntity().eAdapters();
        if (!adapters.isEmpty()) {
            Iterator synchAdaptersIt = adapters.iterator();
            while (synchAdaptersIt.hasNext()) {
                Adapter next = (Adapter)synchAdaptersIt.next();
                if (disableKeySynchronizer && next instanceof CMPKeySynchronizationAdapter) {
                    this.keyAdapter = next;
                    synchAdaptersIt.remove();
                    continue;
                }
                if (!(next instanceof CMPJavaChangeSynchronizationAdapter)) continue;
                this.javaKeyAdapter = next;
                synchAdaptersIt.remove();
            }
        }
    }

    private void enableCMPChangeSynchronizationAdapters() {
        EList adapters = this.getEntity().eAdapters();
        if (this.keyAdapter != null) {
            adapters.add(this.keyAdapter);
            this.keyAdapter = null;
        }
        if (this.javaKeyAdapter != null) {
            adapters.add(this.javaKeyAdapter);
            this.javaKeyAdapter = null;
        }
    }

    private void updatePrimKeyField(JavaClass primaryKeyClass) {
        if (this.getEntity().isContainerManagedEntity()) {
            CMPAttribute key;
            CMPAttribute primKeyField = null;
            ContainerManagedEntity cmp = (ContainerManagedEntity)this.getEntity();
            if (cmp.getKeyAttributes().size() == 1 && primaryKeyClass == (key = (CMPAttribute)cmp.getKeyAttributes().get(0)).getType()) {
                primKeyField = key;
            }
            cmp.setPrimKeyField(primKeyField);
        }
    }

    @Override
    public EObject findOriginalSourceMetaType() {
        Entity ejb = (Entity)this.getOriginalEjb();
        if (ejb != null) {
            return ejb.getPrimaryKey();
        }
        return null;
    }

    protected Entity getEntity() {
        return (Entity)this.getEjb();
    }

    @Override
    protected void setupHelper() {
        super.setupHelper();
        this.getHelper().setCreate();
    }

    @Override
    protected void setupInverseHelper() {
        super.setupInverseHelper();
        this.getInverseHelper().setDelete();
    }

    @Override
    protected void undoMetadataGeneration() {
        if (this.getEntity() != null) {
            this.getEntity().setPrimaryKey(this.getOriginalJavaClass());
        }
        super.undoMetadataGeneration();
    }

    @Override
    protected void executeForCodeGeneration() throws CommandExecutionFailure {
        if (!this.generateJava) {
            return;
        }
        super.executeForCodeGeneration();
        if (this.getEjb() instanceof ContainerManagedEntity) {
            ((ContainerManagedEntity)this.getEjb()).setPrimKeyField(null);
        }
    }

    @Override
    public void execute() {
        if (this.getEjb() instanceof ContainerManagedEntity) {
            CMPJavaChangeSynchronizationAdapter.disable((ContainerManagedEntity)((ContainerManagedEntity)this.getEjb()));
        }
        super.execute();
    }
}

