/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.creation;

import com.ibm.etools.ejb.codegen.helpers.EJBCodeGenResourceHandler;
import com.ibm.etools.ejb.codegen.helpers.RoleHelper;
import com.ibm.etools.ejb.creation.AbstractClientViewOperation;
import com.ibm.etools.j2ee.commands.AddHomeInterfaceCommand;
import com.ibm.etools.j2ee.commands.AddRemoteInterfaceCommand;
import com.ibm.etools.j2ee.commands.CreateHomeInterfaceCommand;
import com.ibm.etools.j2ee.commands.CreateRemoteInterfaceCommand;
import com.ibm.etools.j2ee.commands.EnterpriseBeanCommand;
import com.ibm.etools.j2ee.commands.IRootCommand;
import com.ibm.etools.j2ee.ejb.EjbPlugin;
import com.ibm.etools.j2ee13.commands.AddLocalHomeInterfaceCommand;
import com.ibm.etools.j2ee13.commands.AddLocalInterfaceCommand;
import com.ibm.etools.j2ee13.commands.CreateLocalHomeInterfaceCommand;
import com.ibm.etools.j2ee13.commands.CreateLocalInterfaceCommand;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class CreateClientViewOperation
extends AbstractClientViewOperation {
    public CreateClientViewOperation(IDataModel dataModel) {
        super(dataModel);
    }

    @Override
    protected void createHomeCommand(EnterpriseBeanCommand ejbCommand) {
        JavaClass homeInterface = this.getClientViewModel().getEjbBean().getHomeInterface();
        if (homeInterface != null) {
            new AddHomeInterfaceCommand((IRootCommand)ejbCommand, homeInterface);
        } else {
            String homeName = this.getClientViewModel().getHomeExistingName();
            if (homeName != null && homeName.length() > 0) {
                CreateHomeInterfaceCommand homeInterfaceCmd = new CreateHomeInterfaceCommand((IRootCommand)ejbCommand, this.getSimpleName(homeName), this.getPackageName(homeName));
                homeInterfaceCmd.setMethodCollection(this.getClientViewModel().getHomeMethodCollection());
            }
        }
    }

    @Override
    protected void createRemoteCommand(EnterpriseBeanCommand ejbCommand) {
        JavaClass remoteInterface = this.getClientViewModel().getEjbBean().getRemoteInterface();
        if (remoteInterface != null) {
            new AddRemoteInterfaceCommand((IRootCommand)ejbCommand, remoteInterface);
        } else {
            String remoteName = this.getClientViewModel().getRemoteExistingName();
            if (remoteName != null && remoteName.length() > 0) {
                List roleMethods;
                CreateRemoteInterfaceCommand remoteInterfaceCmd = new CreateRemoteInterfaceCommand((IRootCommand)ejbCommand, this.getSimpleName(remoteName), this.getPackageName(remoteName));
                List methods = this.getClientViewModel().getMethodCollection();
                EnterpriseBean ejb = this.getEjbBean();
                if (ejb.isContainerManagedEntity() && ejb.getVersionID() >= 20 && !(roleMethods = this.getRelationshipMethodNames((ContainerManagedEntity)ejb)).isEmpty()) {
                    methods = this.filterOutRelationshipMethods(methods, roleMethods);
                }
                if (!methods.isEmpty()) {
                    remoteInterfaceCmd.setMethodCollection(methods);
                }
            }
        }
    }

    private List getRelationshipMethodNames(ContainerManagedEntity entity) {
        ArrayList<String> roleMethodNames = new ArrayList<String>();
        List roles = entity.getRoles();
        if (roles != null && !roles.isEmpty()) {
            int s = 0;
            while (s < roles.size()) {
                CommonRelationshipRole role = (CommonRelationshipRole)roles.get(s);
                roleMethodNames.add(RoleHelper.getSetterName(role));
                roleMethodNames.add(RoleHelper.getGetterName(role));
                ++s;
            }
        }
        return roleMethodNames;
    }

    private List filterOutRelationshipMethods(List methods, List roleMethNames) {
        ArrayList<Method> methodsToAdd = new ArrayList<Method>();
        int i = 0;
        while (i < methods.size()) {
            Method method = (Method)methods.get(i);
            String methodName = method.getName();
            if (!roleMethNames.contains(methodName)) {
                methodsToAdd.add(method);
            }
            ++i;
        }
        return methodsToAdd;
    }

    @Override
    protected void createLocalHomeCommand(EnterpriseBeanCommand ejbCommand) {
        JavaClass localHomeInterface = this.getClientViewModel().getEjbBean().getLocalHomeInterface();
        if (localHomeInterface != null) {
            new AddLocalHomeInterfaceCommand((IRootCommand)ejbCommand, localHomeInterface);
        } else {
            String localHomeName = this.getClientViewModel().getLocalHomeExistingName();
            if (localHomeName != null && localHomeName.length() > 0) {
                CreateLocalHomeInterfaceCommand localHomeInterfaceCmd = new CreateLocalHomeInterfaceCommand((IRootCommand)ejbCommand, this.getSimpleName(localHomeName), this.getPackageName(localHomeName));
                localHomeInterfaceCmd.setMethodCollection(this.getClientViewModel().getHomeMethodCollection());
            }
        }
    }

    @Override
    protected void createLocalCommand(EnterpriseBeanCommand ejbCommand) {
        JavaClass localInterface = this.getClientViewModel().getEjbBean().getLocalInterface();
        if (localInterface != null) {
            new AddLocalInterfaceCommand((IRootCommand)ejbCommand, localInterface);
        } else {
            String localName = this.getClientViewModel().getLocalExistingName();
            if (localName != null && localName.length() > 0) {
                CreateLocalInterfaceCommand localInterfaceCommand = new CreateLocalInterfaceCommand((IRootCommand)ejbCommand, this.getSimpleName(localName), this.getPackageName(localName));
                localInterfaceCommand.setMethodCollection(this.getClientViewModel().getMethodCollection());
            }
        }
    }

    @Override
    protected String errorMessage() {
        return EJBCodeGenResourceHandler.Error_in_Client_View_Creation_1;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            super.doExecute(monitor);
        }
        catch (InvocationTargetException e) {
            EjbPlugin.logError(e);
        }
        catch (InterruptedException e) {
            EjbPlugin.logError(e);
        }
        catch (CoreException e) {
            EjbPlugin.logError(e);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

