/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.codegen.helpers;

import com.ibm.etools.ejb.codegen.EJBGenHelpers;
import com.ibm.etools.ejb.codegen.helpers.AttributeHelper;
import com.ibm.etools.ejb.codegen.helpers.AttributeHistory;
import com.ibm.etools.ejb.codegen.helpers.FeatureHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaPackage;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.CommonRelationship;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;

public class RoleHelper
extends FeatureHelper {
    static final String LINK_CLASS_TYPE_PATTERN = "{0}To{1}Link";
    static final String LINK_GETTER_NAME_PATTERN = "get{0}Link";
    static final String KEY_GETTER_NAME_PATTERN = "get{0}Key";
    static final String KEY_SETTER_NAME_PATTERN = "privateSet{0}Key";
    static final String HOME_FINDER_PATTERN = "find{0}By{1}";
    static final String SECONDARY_SETTER_NAME_PREFIX = "secondarySet";
    static final String SECONDARY_ADD_NAME_PREFIX = "secondaryAdd";
    static final String SECONDARY_REMOVE_NAME_PREFIX = "secondaryRemove";
    static final String SETTER_NAME_PREFIX = "set";
    static final String GETTER_NAME_PREFIX = "get";
    static final String ADD_NAME_PREFIX = "add";
    static final String REMOVE_NAME_PREFIX = "remove";
    static final String PARAMETER_NAME_PREFIX = "arg";
    static final String LINK_IVAR_SUFFIX = "Link";
    protected List attributeHelpers;
    protected List oldAttributeHelpers;
    protected List cmp20KeyAttributeHelpers;

    public RoleHelper(EObject aMetaObject) {
        super(aMetaObject);
    }

    public static void collectRoleMethodNames(CommonRelationshipRole aRole, List aList) {
        if (aRole == null || aList == null) {
            return;
        }
        aList.add(RoleHelper.getLinkGetterName(aRole));
        if (aRole.isForward()) {
            aList.add(RoleHelper.getKeyGetterName(aRole));
            aList.add(RoleHelper.getKeySetterName(aRole));
        }
        if (aRole.isNavigable()) {
            aList.add(RoleHelper.getGetterName(aRole));
        }
        if (!RoleHelper.isMany(aRole)) {
            if (!aRole.getOppositeAsCommonRole().isKey()) {
                aList.add(RoleHelper.getSetterName(aRole));
            }
            if (!aRole.isKey()) {
                aList.add(RoleHelper.getSecondarySetterName(aRole));
            }
        } else {
            aList.add(RoleHelper.getSecondaryAddName(aRole));
            aList.add(RoleHelper.getSecondaryRemoveName(aRole));
            if (aRole.isNavigable()) {
                if (!aRole.getOppositeAsCommonRole().isKey()) {
                    aList.add(RoleHelper.getAddName(aRole));
                }
                if (aRole.getOppositeAsCommonRole() != null && !aRole.getOppositeAsCommonRole().isRequired()) {
                    aList.add(RoleHelper.getRemoveName(aRole));
                }
            }
        }
    }

    protected AttributeHelper createAttributeHelper(CMPAttribute attribute) {
        AttributeHelper helper = new AttributeHelper((EObject)attribute);
        helper.setParent(this);
        return helper;
    }

    protected List createAttributeHelpers(List attributes) {
        ArrayList<AttributeHelper> helpers = new ArrayList<AttributeHelper>(attributes.size());
        EList oldAttributes = null;
        if (this.isUpdate() && this.getOldRole() != null) {
            oldAttributes = this.getOldRole().getAttributes();
        }
        int i = 0;
        while (i < attributes.size()) {
            CMPAttribute attribute = (CMPAttribute)attributes.get(i);
            AttributeHelper helper = this.isCreate() ? this.createNewAttributeHelper(attribute) : (this.isDelete() ? this.createDeleteAttributeHelper(attribute) : this.createUpdateAttributeHelper(attribute, (List)oldAttributes, i));
            helpers.add(helper);
            ++i;
        }
        return helpers;
    }

    protected List createCMP20KeyAttributeHelpers(List attributes) {
        int type = 1;
        if (!this.isDelete() && this.getRole().isKey()) {
            type = 2;
        }
        return this.createCMP20KeyAttributeHelpers(attributes, type);
    }

    protected List createCMP20KeyAttributeHelpers(List attributes, int type) {
        if (attributes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AttributeHelper> helpers = new ArrayList<AttributeHelper>(attributes.size());
        AttributeHelper helper = null;
        int i = 0;
        while (i < attributes.size()) {
            CMPAttribute attribute = (CMPAttribute)attributes.get(i);
            helper = this.createCMP20KeyAttributeHelper(attribute, type);
            if (helper != null) {
                helpers.add(helper);
            }
            ++i;
        }
        return helpers;
    }

    protected List createCMP20UpdateKeyAttributeHelpers() {
        EList oldAtts = this.getOldRole().getAttributes();
        EList newAtts = this.getRole().getAttributes();
        boolean oldKey = this.getOldRole().isKey();
        boolean newKey = this.getRole().isKey();
        if (oldKey && !newKey) {
            return this.createCMP20KeyAttributeHelpers((List)oldAtts, 1);
        }
        if (!oldKey && newKey) {
            return this.createCMP20KeyAttributeHelpers((List)newAtts, 2);
        }
        if (oldKey && newKey) {
            return this.createCMP20UpdateKeyAttributeHelpers((List)oldAtts, (List)newAtts);
        }
        return Collections.EMPTY_LIST;
    }

    protected List createCMP20UpdateKeyAttributeHelpers(List oldAtts, List newAtts) {
        ArrayList helpers = new ArrayList();
        List missingNew = this.findMissing(newAtts, oldAtts);
        List missingOld = this.findMissing(oldAtts, newAtts);
        this.collectCMP20CreateDeleteKeyAttributeHelpers(missingNew, missingOld, helpers);
        ArrayList newUpdate = new ArrayList(newAtts);
        newUpdate.removeAll(missingNew);
        ArrayList oldUpdate = new ArrayList(oldAtts);
        oldUpdate.removeAll(missingOld);
        this.collectCMP20UpdateKeyAttributeHelpers(newUpdate, oldUpdate, helpers);
        return helpers;
    }

    protected void collectCMP20CreateDeleteKeyAttributeHelpers(List newAtts, List oldAtts, List helpers) {
        helpers.addAll(this.createCMP20KeyAttributeHelpers(newAtts, 2));
        helpers.addAll(this.createCMP20KeyAttributeHelpers(oldAtts, 1));
    }

    protected void collectCMP20UpdateKeyAttributeHelpers(List newAtts, List oldAtts, List helpers) {
        int i = 0;
        while (i < newAtts.size()) {
            CMPAttribute newAtt = (CMPAttribute)newAtts.get(i);
            int j = 0;
            while (j < oldAtts.size()) {
                CMPAttribute oldAtt = (CMPAttribute)oldAtts.get(j);
                if (oldAtt.getName().equals(newAtt.getName())) {
                    AttributeHelper helper = this.createUpdateAttributeHelper(newAtt, oldAtt);
                    helpers.add(helper);
                }
                ++j;
            }
            ++i;
        }
    }

    protected List findMissing(List list1, List list2) {
        int l1Size = list1.size();
        int l2Size = list2.size();
        boolean found2 = false;
        ArrayList<CMPAttribute> result = null;
        int i = 0;
        while (i < l1Size) {
            found2 = false;
            CMPAttribute l1Att = (CMPAttribute)list1.get(i);
            int j = 0;
            while (j < l2Size) {
                CMPAttribute l2Att = (CMPAttribute)list2.get(j);
                if (l2Att.getName().equals(l1Att.getName())) {
                    found2 = true;
                    break;
                }
                ++j;
            }
            if (!found2) {
                if (result == null) {
                    result = new ArrayList<CMPAttribute>();
                }
                result.add(l1Att);
            }
            ++i;
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    protected AttributeHelper createCMP20KeyAttributeHelper(CMPAttribute attribute, int type) {
        AttributeHelper helper = null;
        switch (type) {
            case 1: {
                helper = this.createDeleteAttributeHelper(attribute);
                break;
            }
            case 2: {
                helper = this.createNewAttributeHelper(attribute);
            }
        }
        if (helper != null) {
            helper.setGenerateAccessors(true);
        }
        return helper;
    }

    protected AttributeHelper createDeleteAttributeHelper(CMPAttribute attribute) {
        AttributeHelper helper = this.createAttributeHelper(attribute);
        helper.setDelete();
        return helper;
    }

    protected AttributeHelper createNewAttributeHelper(CMPAttribute attribute) {
        AttributeHelper helper = this.createAttributeHelper(attribute);
        helper.setCreate();
        return helper;
    }

    protected AttributeHelper createUpdateAttributeHelper(CMPAttribute attribute, List oldAttributes, int index) {
        CMPAttribute old = index < oldAttributes.size() ? (CMPAttribute)oldAttributes.get(index) : null;
        return this.createUpdateAttributeHelper(attribute, old);
    }

    protected AttributeHelper createUpdateAttributeHelper(CMPAttribute attribute, CMPAttribute oldAttribute) {
        AttributeHelper helper = this.createAttributeHelper(attribute);
        if (oldAttribute != null) {
            AttributeHistory history = new AttributeHistory();
            history.storeHistory(oldAttribute);
            helper.setMetadataHistory(history);
        }
        helper.setUpdate();
        return helper;
    }

    protected static String firstAsUppercase(String aString) {
        if (aString == null) {
            return null;
        }
        return EJBGenHelpers.firstAsUppercase(aString);
    }

    public static String getAddName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return ADD_NAME_PREFIX + arg;
    }

    public static String getAssociationTableName(CommonRelationshipRole aRole) {
        StringBuffer out = new StringBuffer(20);
        CommonRelationship rel = aRole.getCommonRelationship();
        out.append(RoleHelper.firstAsUppercase(rel.getFirstCommonRole().getName()));
        out.append("_");
        out.append(RoleHelper.firstAsUppercase(rel.getSecondCommonRole().getName()));
        return out.toString();
    }

    public List getAttributeHelpers() {
        if (this.isDelete()) {
            return this.getOldAttributeHelpers();
        }
        if (this.attributeHelpers == null) {
            this.initializeAttributeHelpers();
        }
        return this.attributeHelpers;
    }

    public List getCMP20KeyAttributeHelpers() {
        if (this.cmp20KeyAttributeHelpers == null) {
            this.initializeCMP20KeyAttributeHelpers();
        }
        return this.cmp20KeyAttributeHelpers;
    }

    public String getEJBLinkClassPackageName() {
        return this.getEjb().getEjbClass().getJavaPackage().getName();
    }

    public static String getGetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return GETTER_NAME_PREFIX + arg;
    }

    public static String getHomeFinderName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg1 = RoleHelper.firstAsUppercase(aRole.getOppositeAsCommonRole().getName());
        String arg2 = RoleHelper.firstAsUppercase(aRole.getName());
        return RoleHelper.format(HOME_FINDER_PATTERN, new String[]{arg1, arg2});
    }

    public static String getKeyGetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return RoleHelper.format(KEY_GETTER_NAME_PATTERN, new String[]{arg});
    }

    public static String getKeySetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return RoleHelper.format(KEY_SETTER_NAME_PATTERN, new String[]{arg});
    }

    public static String getLinkFieldName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        return String.valueOf(aRole.getName()) + LINK_IVAR_SUFFIX;
    }

    public static String getLinkGetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return RoleHelper.format(LINK_GETTER_NAME_PATTERN, new String[]{arg});
    }

    public static String getLinkInterfaceTypeName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        if (aRole.isMany()) {
            return "com.ibm.ivj.ejb.associations.interfaces.ManyLink";
        }
        return "com.ibm.ivj.ejb.associations.interfaces.SingleLink";
    }

    @Override
    public String getName() {
        if (this.fName == null && this.getRole() != null) {
            this.fName = this.getRole().getName();
        }
        return this.fName;
    }

    public List getOldAttributeHelpers() {
        if (this.oldAttributeHelpers == null) {
            this.initializeOldAttributeHelpers();
        }
        return this.oldAttributeHelpers;
    }

    public CommonRelationshipRole getOldOppositeRole() {
        return this.getOldRole() != null ? this.getOldRole().getOppositeAsCommonRole() : null;
    }

    public EnterpriseBean getOldOppositeRoleType() {
        return RoleHelper.getRoleType(this.getOldOppositeRole());
    }

    public String getOldOppositeRoleTypeName() {
        EnterpriseBean ejb = this.getOldOppositeRoleType();
        return ejb == null ? null : ejb.getName();
    }

    public String getOldPackageName() {
        if (this.getOldRole() != null) {
            return RoleHelper.getPackageName(this.getOldRole());
        }
        return RoleHelper.getPackageName(this.getRole());
    }

    public CommonRelationshipRole getOldRole() {
        return (CommonRelationshipRole)this.getMetadataHistory().getOldMetadata();
    }

    public CommonRelationshipRole getOppositeRole() {
        return this.getRole().getOppositeAsCommonRole();
    }

    public ContainerManagedEntity getOppositeRoleType() {
        return RoleHelper.getRoleType(this.getOppositeRole());
    }

    public String getOppositeRoleTypeName() {
        ContainerManagedEntity ejb = this.getOppositeRoleType();
        return ejb == null ? null : ejb.getName();
    }

    public static String getPackageName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        ContainerManagedEntity ejb = aRole.getSourceEntity();
        JavaClass ejbClass = ejb == null ? null : ejb.getEjbClass();
        JavaPackage pack = ejbClass == null ? null : ejbClass.getJavaPackage();
        return pack == null ? null : pack.getName();
    }

    public static String getParameterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return PARAMETER_NAME_PREFIX + arg;
    }

    public static String getRemoveName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return REMOVE_NAME_PREFIX + arg;
    }

    public CommonRelationshipRole getRole() {
        if (this.isDelete()) {
            return (CommonRelationshipRole)this.getMetadataHistory().getOldMetadata();
        }
        return (CommonRelationshipRole)this.getMetaObject();
    }

    public static ContainerManagedEntity getRoleDeclaringBean(CommonRelationshipRole aRole) {
        if (aRole != null) {
            return aRole.getSourceEntity();
        }
        return null;
    }

    public ContainerManagedEntity getRoleType() {
        return RoleHelper.getRoleType(this.getRole());
    }

    public static ContainerManagedEntity getRoleType(CommonRelationshipRole aRole) {
        if (aRole != null) {
            return aRole.getTypeEntity();
        }
        return null;
    }

    public static String getRoleTypePrimaryKeyName(CommonRelationshipRole aRole) {
        ContainerManagedEntity cmp = RoleHelper.getRoleType(aRole);
        return cmp == null ? null : cmp.getPrimaryKeyName();
    }

    public static String getRoleTypeRemoteInterfaceName(CommonRelationshipRole aRole) {
        ContainerManagedEntity cmp = RoleHelper.getRoleType(aRole);
        return cmp == null ? null : cmp.getRemoteInterfaceName();
    }

    public static String getSecondaryAddName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return SECONDARY_ADD_NAME_PREFIX + arg;
    }

    public static String getSecondaryRemoveName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return SECONDARY_REMOVE_NAME_PREFIX + arg;
    }

    public static String getSecondarySetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return SECONDARY_SETTER_NAME_PREFIX + arg;
    }

    public static String getSetterName(CommonRelationshipRole aRole) {
        if (aRole == null) {
            return null;
        }
        String arg = RoleHelper.firstAsUppercase(aRole.getName());
        return SETTER_NAME_PREFIX + arg;
    }

    protected void initializeAttributeHelpers() {
        this.attributeHelpers = this.createAttributeHelpers((List)this.getRole().getAttributes());
    }

    protected void initializeOldAttributeHelpers() {
        this.oldAttributeHelpers = this.getOldRole() == null ? new ArrayList() : this.createAttributeHelpers((List)this.getOldRole().getAttributes());
    }

    protected void initializeCMP20KeyAttributeHelpers() {
        this.cmp20KeyAttributeHelpers = this.isDelete() || this.isCreate() ? this.createCMP20KeyAttributeHelpers((List)this.getRole().getAttributes()) : this.createCMP20UpdateKeyAttributeHelpers();
    }

    public boolean isKeyPropagationHelper() {
        return false;
    }

    public static boolean isMany(CommonRelationshipRole aRole) {
        return aRole != null && aRole.isMany();
    }

    @Override
    public boolean isRoleHelper() {
        return true;
    }

    public boolean isUpdateForwardChange() {
        return this.isUpdate() && this.getOldRole() != null && this.getOldRole().isForward() && !this.getRole().isForward();
    }

    public CommonRelationshipRole primGetRole() {
        return (CommonRelationshipRole)this.getMetaObject();
    }

    public boolean isOrWasKey() {
        if (this.isKey()) {
            return true;
        }
        if (this.getOldRole() != null) {
            return this.getOldRole().isKey();
        }
        return false;
    }
}

