/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.codegen;

import com.ibm.etools.ejb.codegen.EJBGenHelpers;
import com.ibm.etools.ejb.codegen.helpers.EntityHelper;
import com.ibm.etools.j2ee.internal.codegen.GenerationException;
import com.ibm.etools.j2ee.internal.codegen.IGenerationBuffer;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMethodGenerator;
import com.ibm.etools.j2ee.internal.java.codegen.JavaParameterDescriptor;
import org.eclipse.jst.j2ee.ejb.Entity;

public class EntityKeyHashCode
extends JavaMethodGenerator {
    protected void getBody(IGenerationBuffer bodyBuf) throws GenerationException {
        EntityHelper topHelper;
        Entity entity = (Entity)this.getSourceElement();
        JavaParameterDescriptor[] parmDescs = EJBGenHelpers.getEntityKeyFieldsAsFlatParms(entity, topHelper = (EntityHelper)this.getTopLevelHelper(), this.getSourceContext().getNavigator());
        if (this.hasArrayType(parmDescs)) {
            this.getBodyWithArrayTypes(bodyBuf, parmDescs);
        } else {
            this.getBodyWithSimpleTypes(bodyBuf, parmDescs);
        }
    }

    protected void getBodyWithArrayTypes(IGenerationBuffer bodyBuf, JavaParameterDescriptor[] parmDescs) {
        bodyBuf.indent();
        bodyBuf.appendWithMargin("int code = 0;\n");
        bodyBuf.appendWithMargin("int i;\n");
        int i = 0;
        while (i < parmDescs.length) {
            if (EJBGenHelpers.isArray(parmDescs[i].getType())) {
                this.addArrayForLoop(bodyBuf, parmDescs[i]);
            } else {
                this.addArrayHashCodeAddition(bodyBuf, parmDescs[i]);
            }
            ++i;
        }
        bodyBuf.appendWithMargin("return code;\r\n");
        bodyBuf.unindent();
    }

    protected void addArrayForLoop(IGenerationBuffer bodyBuf, JavaParameterDescriptor parmDesc) {
        bodyBuf.formatWithMargin("for (i=0; i<%0.length; i++)\n", new String[]{parmDesc.getName()});
        bodyBuf.indent();
        int index = parmDesc.getType().indexOf(91);
        String rootType = parmDesc.getType().substring(0, index);
        this.addArrayHashCodeAddition(bodyBuf, parmDesc.getName(), rootType, true);
        bodyBuf.unindent();
    }

    protected void addArrayHashCodeAddition(IGenerationBuffer bodyBuf, JavaParameterDescriptor parmDesc) {
        this.addArrayHashCodeAddition(bodyBuf, parmDesc.getName(), parmDesc.getType(), false);
    }

    protected void addArrayHashCodeAddition(IGenerationBuffer bodyBuf, String name, String type, boolean isRootArrayType) {
        String[] parms = new String[]{name, EJBGenHelpers.getPrimitiveWrapper(type)};
        String template = this.getTemplateFor(type, isRootArrayType);
        bodyBuf.appendWithMargin("code += ");
        bodyBuf.format(template, parms);
        bodyBuf.append(";\r\n");
    }

    protected boolean hasArrayType(JavaParameterDescriptor[] parmDescs) {
        if (parmDescs != null && parmDescs.length > 0) {
            int i = 0;
            while (i < parmDescs.length) {
                if (EJBGenHelpers.isArray(parmDescs[i].getType())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void getBodyWithSimpleTypes(IGenerationBuffer bodyBuf, JavaParameterDescriptor[] parmDescs) {
        bodyBuf.indent();
        bodyBuf.appendWithMargin("return (");
        if (parmDescs != null && parmDescs.length > 0) {
            String[] parmName = new String[2];
            String template = null;
            bodyBuf.indent();
            int i = 0;
            while (i < parmDescs.length) {
                parmName[0] = parmDescs[i].getName();
                parmName[1] = EJBGenHelpers.getPrimitiveWrapper(parmDescs[i].getType());
                template = this.getTemplateFor(parmDescs[i].getType());
                if (i > 0) {
                    bodyBuf.appendWithMargin("+ ");
                }
                bodyBuf.format(template, parmName);
                if (i < parmDescs.length - 1) {
                    bodyBuf.append("\n");
                }
                ++i;
            }
            bodyBuf.unindent();
        } else {
            bodyBuf.append("super.hashCode()");
        }
        bodyBuf.append(");\n");
        bodyBuf.unindent();
    }

    protected String getComment() throws GenerationException {
        return "Returns the hash code for the key.\n";
    }

    protected String getName() throws GenerationException {
        return "hashCode";
    }

    protected String getReturnType() throws GenerationException {
        return "int";
    }

    protected String getTemplateFor(String type) {
        return this.getTemplateFor(type, false);
    }

    protected String getTemplateFor(String type, boolean isRootArrayType) {
        if (EJBGenHelpers.isPrimitive(type)) {
            if (isRootArrayType) {
                return "(new %1(%0[i]).hashCode())";
            }
            return "(new %1(%0).hashCode())";
        }
        if (isRootArrayType) {
            return "%0[i].hashCode()";
        }
        return "%0.hashCode()";
    }
}

