/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ant.extras;

import com.ibm.etools.ant.extras.common.ResourceHandler;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class HeadlessWorkspaceSettingsHelper {
    private IWorkspace workspace = ResourcesPlugin.getWorkspace();
    private IWorkspaceDescription wd = this.workspace.getDescription();
    private boolean isAutoBuildEnabled = true;
    private long maxFileStateSize = 1000000L;
    private static final String name = "HeadlessWorkspaceSettings: ";

    public HeadlessWorkspaceSettingsHelper() {
        this.saveWorkspaceSetings();
    }

    public void saveWorkspaceSetings() {
        this.maxFileStateSize = this.wd.getMaxFileStateSize();
        this.isAutoBuildEnabled = this.wd.isAutoBuilding();
        System.out.println(ResourceHandler.getString("HeadlessWorkspaceSettings.initial", new String[]{name, Boolean.toString(this.wd.isAutoBuilding()), String.valueOf(this.wd.getMaxFileStateSize())}));
        try {
            if (this.isAutoBuildEnabled) {
                this.wd.setAutoBuilding(false);
            }
            if (this.maxFileStateSize >= 0L) {
                this.wd.setMaxFileStateSize(-1L);
            }
            if (this.isAutoBuildEnabled || this.maxFileStateSize > 0L) {
                this.workspace.setDescription(this.wd);
            }
            System.out.println(ResourceHandler.getString("HeadlessWorkspaceSettings.temp", new String[]{name, Boolean.toString(this.wd.isAutoBuilding()), String.valueOf(this.wd.getMaxFileStateSize())}));
        }
        catch (CoreException exc) {
            System.out.println(ResourceHandler.getString("HeadlessWorkspaceSettings.saveFailed", new String[]{name, exc.getMessage()}));
            this.wd = null;
        }
    }

    public void restore() {
        if (this.wd == null) {
            System.out.println(ResourceHandler.getString("HeadlessWorkspaceSettings.previousFailedInit", name));
            return;
        }
        try {
            if (this.isAutoBuildEnabled) {
                this.wd.setAutoBuilding(this.isAutoBuildEnabled);
            }
            if (this.maxFileStateSize >= 0L) {
                this.wd.setMaxFileStateSize(this.maxFileStateSize);
            }
            if (this.isAutoBuildEnabled || this.maxFileStateSize >= 0L) {
                this.workspace.setDescription(this.wd);
            }
            System.out.println(ResourceHandler.getString("HeadlessWorkspaceSettings.restoredAutoBuild", new String[]{name, Boolean.toString(this.wd.isAutoBuilding()), String.valueOf(this.wd.getMaxFileStateSize())}));
        }
        catch (CoreException exc) {
            System.out.println(ResourceHandler.getString("HeadlessWorkspaceSettings.restoreFailed", new String[]{name, exc.getMessage()}));
        }
    }
}

