/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.tools;

import com.ibm.etools.diagram.ui.internal.celleditor.TextEditPartDialogCellEditor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TextCellEditorLocator
implements CellEditorLocator {
    private final ILabelDelegate label;

    public TextCellEditorLocator(ILabelDelegate delegate) {
        this.label = delegate;
    }

    public ILabelDelegate getWrapLabel() {
        return this.label;
    }

    public void relocate(CellEditor celleditor) {
        Rectangle newRect;
        Composite composite = (Composite)celleditor.getControl();
        Text text = ((TextEditPartDialogCellEditor)celleditor).getText();
        Button btn = ((TextEditPartDialogCellEditor)celleditor).getButton();
        org.eclipse.draw2d.geometry.Rectangle rect = this.label.getTextBounds().getCopy();
        if (this.label.getText().length() <= 0) {
            rect.setSize(new Dimension(text.computeSize(-1, -1)));
            if (this.label.isTextWrapOn()) {
                if (this.label.getTextJustification() == 4) {
                    rect.translate(-rect.width, 0);
                } else if (this.label.getTextJustification() == 2) {
                    rect.translate(-rect.width / 2, 0);
                }
            }
        }
        if (this.label.isTextWrapOn()) {
            int charHeight = FigureUtilities.getFontMetrics((Font)text.getFont()).getHeight();
            rect.resize(0, charHeight / 2);
        } else {
            rect.setSize(new Dimension(text.computeSize(-1, -1)));
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
        }
        rect.width += 8;
        if (btn != null) {
            rect.width += btn.computeSize((int)-1, (int)-1).x;
        }
        if (!(newRect = composite.computeTrim(rect.x, rect.y, rect.width, rect.height)).equals((Object)composite.getBounds())) {
            composite.setBounds(newRect.x, newRect.y, newRect.width, newRect.height);
        }
    }
}

