/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.tools;

import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.ui.internal.DiagramPlugin;
import com.ibm.etools.diagram.ui.internal.adapters.ResourceSelectionDialogAdapter;
import com.ibm.etools.diagram.ui.internal.celleditor.TextDialogCellEditor;
import com.ibm.etools.diagram.ui.internal.celleditor.TextEditPartDialogCellEditor;
import com.ibm.etools.diagram.ui.internal.tools.ITextAwareEditPartWithLabel;
import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TextCompartmentEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.statushandlers.StatusManager;

public final class CustomDirectEditManager
extends DirectEditManager {
    private final ITextAwareEditPartWithLabel textEditPart;
    private boolean committing;
    private StringBuffer initialString = new StringBuffer();
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;

    public CustomDirectEditManager(ITextAwareEditPartWithLabel part, GraphicalEditPart source, Class<TextEditPartDialogCellEditor> type, CellEditorLocator locator) {
        super((org.eclipse.gef.GraphicalEditPart)source, type, locator);
        this.textEditPart = part;
    }

    protected void bringDown() {
        TextEditPartDialogCellEditor editor = (TextEditPartDialogCellEditor)this.getCellEditor();
        if (editor != null) {
            editor.setIgnoreDeactivate(true);
        }
        super.bringDown();
        this.initialString = new StringBuffer();
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
    }

    protected void commit() {
        if (this.committing) {
            return;
        }
        this.committing = true;
        try {
            this.eraseFeedback();
            if (this.isDirty()) {
                CommandStack stack = this.getEditPart().getViewer().getEditDomain().getCommandStack();
                if (this.getCellEditor() != null) {
                    this.getCellEditor().deactivate();
                }
                DirectEditRequest request = this.getDirectEditRequest();
                HashMap<String, Boolean> params = new HashMap<String, Boolean>();
                TextDialogCellEditor cellEditor = (TextDialogCellEditor)this.getCellEditor();
                if (cellEditor.shouldCreate()) {
                    params.put("Create Resource", Boolean.TRUE);
                } else {
                    params.put("Create Resource", Boolean.FALSE);
                }
                request.setExtendedData(params);
                stack.execute(this.getEditPart().getCommand((Request)request));
            }
        }
        finally {
            this.bringDown();
            this.committing = false;
        }
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        EObject object = ViewUtil.resolveSemanticElement((View)((View)this.textEditPart.getModel()));
        IPropertyHolder propertyHolder = null;
        ResourceSelectionDialogAdapter adapter = null;
        MNode adaptable = null;
        if (object instanceof Compartment) {
            propertyHolder = ((Compartment)object).getParent();
            adaptable = ((Compartment)object).getParent();
        } else {
            propertyHolder = (IPropertyHolder)object;
            if (propertyHolder instanceof IAdaptable) {
                adaptable = (IAdaptable)propertyHolder;
            }
        }
        if (adaptable != null) {
            adapter = (ResourceSelectionDialogAdapter)adaptable.getAdapter(ResourceSelectionDialogAdapter.class);
        }
        return new TextEditPartDialogCellEditor(composite, propertyHolder, adapter);
    }

    protected Font getScaledFont(WrappingLabel label) {
        Font scaledFont = label.getFont();
        return scaledFont;
    }

    protected void initCellEditor() {
        final String[] errorHolder = new String[1];
        final TextEditPartDialogCellEditor editor = (TextEditPartDialogCellEditor)this.getCellEditor();
        editor.setOriginalValue(this.textEditPart.getEditText());
        editor.setValidator(((TextCompartmentEditPart)this.getEditPart()).getEditTextValidator());
        WrappingLabel label = null;
        label = this.textEditPart.getWrappingLabel();
        editor.setFont(this.getScaledFont(label));
        ICellEditorListener cellEditorListener = new ICellEditorListener(){

            public void applyEditorValue() {
                IStatusLineManager statusLine = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars().getStatusLineManager();
                if (statusLine != null) {
                    statusLine.setErrorMessage(null);
                }
            }

            public void cancelEditor() {
                IStatusLineManager statusLine;
                if (errorHolder[0] != null && !editor.isValueValid()) {
                    String escaped = errorHolder[0].replace("&", "&&");
                    Status status = new Status(4, DiagramPlugin.getPluginId(), 4, escaped, null);
                    StatusManager.getManager().handle((IStatus)status, 4);
                }
                if ((statusLine = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars().getStatusLineManager()) != null) {
                    statusLine.setErrorMessage(null);
                }
            }

            public void editorValueChanged(boolean old, boolean newState) {
                errorHolder[0] = CustomDirectEditManager.this.getCellEditor().getErrorMessage();
                IStatusLineManager statusLine = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars().getStatusLineManager();
                if (statusLine != null) {
                    if (errorHolder[0] == null) {
                        statusLine.setErrorMessage(null);
                    } else {
                        String escaped = errorHolder[0].replace("&", "&&");
                        statusLine.setErrorMessage(JFaceResources.getImage((String)"dialog_message_error_image"), escaped);
                    }
                }
            }
        };
        editor.addListener(cellEditorListener);
        this.actionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
    }

    private void restoreSavedActions(IActionBars _actionBars) {
        _actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        _actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        _actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        _actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        _actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        _actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        _actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        _actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }

    private void saveCurrentActions(IActionBars _actionBars) {
        this.copy = _actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = _actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = _actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = _actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = _actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = _actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = _actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = _actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    public void setEditText(String toEdit) {
        TextEditPartDialogCellEditor cellEditor = (TextEditPartDialogCellEditor)this.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        ITextAwareEditPart textEP = (ITextAwareEditPart)this.getEditPart();
        Text textControl = cellEditor.getText();
        textEP.setLabelText(toEdit);
        cellEditor.setValue(toEdit);
        textControl.setSelection(toEdit.length());
    }

    public void show() {
        super.show();
    }

    public void show(char initialChar) {
        this.initialString = this.initialString.append(initialChar);
        this.show();
        if (SWT.getPlatform() != "carbon") {
            this.setEditText(this.initialString.toString());
        }
    }
}

