/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.services;

import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.operations.GetProvidersOperation;
import com.ibm.etools.diagram.model.internal.services.configuration.ObjectDescriptorProviderConfiguration;
import com.ibm.etools.diagram.ui.internal.DiagramPlugin;
import com.ibm.etools.diagram.ui.internal.services.IPropertyDisplayProvider;
import com.ibm.etools.model2.base.DelegatingSafeRunnable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;

public class PropertyDisplayService
extends Service {
    private static PropertyDisplayService service = null;

    public PropertyDisplayService() {
    }

    public PropertyDisplayService(boolean optimized) {
        super(optimized);
    }

    public PropertyDisplayService(boolean optimized, boolean optimistic) {
        super(optimized, optimistic);
    }

    public static PropertyDisplayService getInstance() {
        if (service == null) {
            service = new PropertyDisplayService(true, true);
            service.configureProviders(DiagramPlugin.getPluginId(), "PropertyDisplayProvider");
        }
        return service;
    }

    public String getEditString(final Property hint) {
        if (hint == null) {
            return null;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, (IOperation)new GetProvidersOperation((Object)hint));
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        final String[] resultHolder = new String[1];
        for (final IPropertyDisplayProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    resultHolder[0] = provider.getEditString(hint);
                }
            });
            if (resultHolder[0] != null) break;
        }
        return resultHolder[0];
    }

    public int getFontColor(final Property hint) {
        if (hint == null) {
            return -1;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, (IOperation)new GetProvidersOperation((Object)hint));
        if (providers == null || providers.isEmpty()) {
            return -1;
        }
        final int[] resultHolder = new int[]{-1};
        for (final IPropertyDisplayProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    resultHolder[0] = provider.getFontColor(hint);
                }
            });
            if (resultHolder[0] != -1) break;
        }
        return resultHolder[0];
    }

    public String getFontName(final Property hint) {
        if (hint == null) {
            return null;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, (IOperation)new GetProvidersOperation((Object)hint));
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        final String[] resultHolder = new String[1];
        for (final IPropertyDisplayProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    resultHolder[0] = provider.getFontName(hint);
                }
            });
            if (resultHolder[0] != null) break;
        }
        return resultHolder[0];
    }

    public String getPrintString(final Property hint) {
        if (hint == null) {
            return null;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, (IOperation)new GetProvidersOperation((Object)hint));
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        final String[] resultHolder = new String[1];
        for (final IPropertyDisplayProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    resultHolder[0] = provider.getPrintString(hint);
                }
            });
            if (resultHolder[0] != null) break;
        }
        return resultHolder[0];
    }

    public String getTooltip(final Property hint) {
        if (hint == null) {
            return null;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, (IOperation)new GetProvidersOperation((Object)hint));
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        final String[] resultHolder = new String[1];
        for (final IPropertyDisplayProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    resultHolder[0] = provider.getTooltip(hint);
                }
            });
            if (resultHolder[0] != null) break;
        }
        return resultHolder[0];
    }

    public boolean hasHandles(final Property hint) {
        if (hint == null) {
            return false;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, (IOperation)new GetProvidersOperation((Object)hint));
        if (providers == null || providers.isEmpty()) {
            return false;
        }
        final Boolean[] resultHolder = new Boolean[]{Boolean.TRUE};
        for (final IPropertyDisplayProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    resultHolder[0] = new Boolean(provider.hasHandles(hint));
                }
            });
            if (resultHolder[0] != null) break;
        }
        return resultHolder[0];
    }

    public boolean isFontBold(final Property hint) {
        if (hint == null) {
            return false;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, (IOperation)new GetProvidersOperation((Object)hint));
        if (providers == null || providers.isEmpty()) {
            return false;
        }
        final Boolean[] resultHolder = new Boolean[]{Boolean.FALSE};
        for (final IPropertyDisplayProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    resultHolder[0] = new Boolean(provider.isFontBold(hint));
                }
            });
            if (resultHolder[0] != null) break;
        }
        return resultHolder[0];
    }

    public boolean isFontItalic(final Property hint) {
        if (hint == null) {
            return false;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, (IOperation)new GetProvidersOperation((Object)hint));
        if (providers == null || providers.isEmpty()) {
            return false;
        }
        final Boolean[] resultHolder = new Boolean[]{Boolean.FALSE};
        for (final IPropertyDisplayProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    resultHolder[0] = new Boolean(provider.isFontItalic(hint));
                }
            });
            if (resultHolder[0] != null) break;
        }
        return resultHolder[0];
    }

    public IStatus isValid(final Property hint, final String userString) {
        if (hint == null) {
            return null;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, (IOperation)new GetProvidersOperation((Object)hint));
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        final IStatus[] resultHolder = new IStatus[1];
        for (final IPropertyDisplayProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    resultHolder[0] = provider.isValid(hint, userString);
                }
            });
            if (resultHolder[0] != null) break;
        }
        return resultHolder[0];
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    public String parseEditedString(final Property hint, final String stringToParse) {
        if (hint == null) {
            return null;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, (IOperation)new GetProvidersOperation((Object)hint));
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        final String[] resultHolder = new String[1];
        for (final IPropertyDisplayProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    resultHolder[0] = provider.parseEditedString(hint, stringToParse);
                }
            });
            if (resultHolder[0] != null) break;
        }
        return resultHolder[0];
    }

    private static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private final ObjectDescriptorProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = ObjectDescriptorProviderConfiguration.parse((IConfigurationElement)element);
            assert (this.providerConfiguration != null);
        }

        private boolean isSupportedInExtention(IOperation operation) {
            if (operation instanceof GetProvidersOperation) {
                GetProvidersOperation getConfigOp = (GetProvidersOperation)operation;
                return this.providerConfiguration.supports(getConfigOp.getElement());
            }
            return false;
        }

        public boolean provides(IOperation operation) {
            return this.isSupportedInExtention(operation);
        }
    }
}

