/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.requests;

import com.ibm.etools.diagram.model.internal.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.util.INotationType;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;

public class DefferedCreateUnspecifiedTypeConnectionRequest
extends CreateUnspecifiedTypeConnectionRequest {
    private List<Object> relationshipTypes;
    private final Map<IElementType, CreateConnectionRequest> requests = new HashMap<IElementType, CreateConnectionRequest>();
    private final boolean useModelingAssistantService;
    private boolean directionReversed = false;

    public DefferedCreateUnspecifiedTypeConnectionRequest(PreferencesHint preferencesHint) {
        super(Collections.EMPTY_LIST, true, preferencesHint);
        this.useModelingAssistantService = true;
    }

    private static CreateConnectionViewRequest getCreateConnectionRequest(IElementType type, PreferencesHint preferencesHint) {
        if (type instanceof INotationType) {
            CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)type, ((INotationType)type).getSemanticHint(), preferencesHint);
            return new CreateConnectionViewRequest(viewDescriptor);
        }
        if (type instanceof IHintedType) {
            return new CreateConnectionViewAndElementRequest(type, ((IHintedType)type).getSemanticHint(), preferencesHint);
        }
        return new CreateConnectionViewAndElementRequest(type, preferencesHint);
    }

    private void createRequests() {
        for (IElementType iElementType : this.relationshipTypes) {
            CreateConnectionViewRequest request = DefferedCreateUnspecifiedTypeConnectionRequest.getCreateConnectionRequest(iElementType, this.getPreferencesHint());
            request.setType(this.getType());
            request.setLocation(this.getLocation());
            request.setTargetEditPart(this.getTargetEditPart());
            this.requests.put(iElementType, (CreateConnectionRequest)request);
        }
    }

    public List<Object> getAllRequests() {
        if (this.requests != null) {
            return new ArrayList<CreateConnectionRequest>(this.requests.values());
        }
        return Collections.EMPTY_LIST;
    }

    public List<Object> getElementTypes() {
        return this.relationshipTypes;
    }

    public CreateRequest getRequestForType(IElementType relationshipType) {
        if (this.requests != null) {
            return (CreateRequest)this.requests.get(relationshipType);
        }
        return null;
    }

    public boolean isDirectionReversed() {
        return this.directionReversed;
    }

    public void setDirectionReversed(boolean directionReversed) {
        this.directionReversed = directionReversed;
    }

    public void setExtendedData(Map map) {
        super.setExtendedData(map);
        List<Object> list = this.getAllRequests();
        for (Request request : list) {
            request.setExtendedData(map);
        }
    }

    public void setLocation(Point location) {
        if (this.requests != null) {
            for (CreateConnectionRequest request : this.requests.values()) {
                request.setLocation(location);
            }
        }
        super.setLocation(location);
    }

    public void setSourceEditPart(EditPart part) {
        if (part != null) {
            this.relationshipTypes = ModelingAssistantService.getInstance().getRelTypesOnSource((IAdaptable)part);
            this.createRequests();
        }
        if (this.requests != null) {
            for (CreateConnectionRequest request : this.requests.values()) {
                request.setSourceEditPart(part);
            }
        }
        super.setSourceEditPart(part);
    }

    public void setTargetEditPart(EditPart part) {
        if (this.requests != null && this.requests.size() > 0) {
            Debug.println((String)("Target edit part = " + part), (String)Debug.DiagramTraceOptions.TRACE_NOTATION, null);
            for (CreateConnectionRequest request : this.requests.values()) {
                request.setTargetEditPart(part);
            }
        }
        super.setTargetEditPart(part);
    }

    public void setType(Object type) {
        if (this.requests != null) {
            for (CreateConnectionRequest request : this.requests.values()) {
                request.setType(type);
            }
        }
        super.setType(type);
    }

    public boolean useModelingAssistantService() {
        return this.useModelingAssistantService;
    }
}

