/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.providers;

import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.EdgeResolverService;
import com.ibm.etools.diagram.model.internal.services.NodeItemService;
import com.ibm.etools.diagram.model.util.ModelUpdateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantProvider;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.SelectExistingElementForSourceOperation;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.SelectExistingElementForTargetOperation;

public class DiagramProviderModelingAssistantProvider
extends ModelingAssistantProvider {
    public List<Object> getRelTypesForSREOnSource(IAdaptable source) {
        return Collections.EMPTY_LIST;
    }

    public List<Object> getRelTypesForSREOnTarget(IAdaptable target) {
        return Collections.EMPTY_LIST;
    }

    public List<IElementType> getRelTypesOnSource(IAdaptable source) {
        MNode sourceNode = (MNode)source.getAdapter(MNode.class);
        if (sourceNode != null) {
            List ids = EdgeGeneratorService.getInstance().getGenerableEdgeTypes(sourceNode);
            return ModelUpdateUtils.convertIdsToElements((List)ids);
        }
        sourceNode = (Item)source.getAdapter(Item.class);
        if (sourceNode != null) {
            return EdgeGeneratorService.getInstance().getGenerableEdgeTypes((Item)sourceNode);
        }
        return Collections.EMPTY_LIST;
    }

    public List<IElementType> getRelTypesOnSourceAndTarget(IAdaptable source, IAdaptable target) {
        List ids = Collections.emptyList();
        if (source == null || target == null) {
            return ids;
        }
        MNode targetNode = (MNode)target.getAdapter(MNode.class);
        if (targetNode == null) {
            return ids;
        }
        List<IElementType> sourceTypes = this.getRelTypesOnSource(source);
        if (sourceTypes.size() == 0) {
            return ids;
        }
        IElementType targetType = targetNode.getElementType();
        ids = EdgeResolverService.getInstance().getResolvableEdgeTypes(sourceTypes, targetType);
        return ids;
    }

    public List<IElementType> getRelTypesOnTarget(IAdaptable target) {
        List ids = Collections.emptyList();
        MNode targetNode = (MNode)target.getAdapter(MNode.class);
        if (targetNode == null) {
            return ids;
        }
        IElementType targetType = targetNode.getElementType();
        if (targetType == null) {
            return ids;
        }
        ids = EdgeResolverService.getInstance().getResolvableEdgeTypes(targetType);
        return ids;
    }

    public List<IElementType> getTypesForPopupBar(IAdaptable host) {
        Compartment compartment = (Compartment)host.getAdapter(Compartment.class);
        if (compartment != null) {
            ArrayList<IElementType> ids = new ArrayList<IElementType>();
            List items = NodeItemService.getInstance().getValidNodeItemsTypes(compartment);
            List itemsTypes = ModelUpdateUtils.convertIdsToElements((List)items);
            for (IElementType nodeItem : itemsTypes) {
                if (nodeItem instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
                    if (((DiagramModelElementTypeFactory.DiagramModelSpecializationType)nodeItem).isPopupBarVisibility()) {
                        ids.add(nodeItem);
                    }
                } else {
                    ids.add(nodeItem);
                }
                List subItems = NodeItemService.getInstance().getValidSubItemsTypes(compartment, nodeItem.getId());
                List subItemsTypes = ModelUpdateUtils.convertIdsToElements((List)subItems);
                for (IElementType subItem : subItemsTypes) {
                    if (subItem instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
                        if (!((DiagramModelElementTypeFactory.DiagramModelSpecializationType)subItem).isPopupBarVisibility()) continue;
                        ids.add(subItem);
                        continue;
                    }
                    ids.add(subItem);
                }
            }
            return ids;
        }
        MNode node = (MNode)host.getAdapter(MNode.class);
        if (node != null) {
            ArrayList<IElementType> ids = new ArrayList<IElementType>();
            EList compartments = node.getCompartments();
            for (Compartment c : compartments) {
                List items = NodeItemService.getInstance().getValidNodeItemsTypes(c);
                List itemsTypes = ModelUpdateUtils.convertIdsToElements((List)items);
                for (IElementType nodeItem : itemsTypes) {
                    if (nodeItem instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
                        if (((DiagramModelElementTypeFactory.DiagramModelSpecializationType)nodeItem).isPopupBarVisibility()) {
                            ids.add(nodeItem);
                        }
                    } else {
                        ids.add(nodeItem);
                    }
                    List subItems = NodeItemService.getInstance().getValidSubItemsTypes(c, nodeItem.getId());
                    List subItemsTypes = ModelUpdateUtils.convertIdsToElements((List)subItems);
                    for (IElementType subItem : subItemsTypes) {
                        if (subItem instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
                            if (!((DiagramModelElementTypeFactory.DiagramModelSpecializationType)subItem).isPopupBarVisibility()) continue;
                            ids.add(subItem);
                            continue;
                        }
                        ids.add(subItem);
                    }
                }
            }
            return ids;
        }
        return super.getTypesForPopupBar(host);
    }

    public List<Object> getTypesForSource(IAdaptable target, IElementType relationshipType) {
        return Collections.EMPTY_LIST;
    }

    public List<Object> getTypesForTarget(IAdaptable source, IElementType relationshipType) {
        MNode sourceNode = (MNode)source.getAdapter(MNode.class);
        if (sourceNode != null) {
            assert (EdgeGeneratorService.getInstance().getGenerableEdgeTypes(sourceNode).contains(relationshipType.getId()));
            IElementType[] allNodeTypes = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)sourceNode);
            ArrayList<Object> ids = new ArrayList<Object>();
            int i = 0;
            while (i < allNodeTypes.length) {
                IElementType targetNode = allNodeTypes[i];
                if (EdgeResolverService.getInstance().isEdgeTypeValid(relationshipType, targetNode)) {
                    ids.add(targetNode);
                }
                ++i;
            }
            return ids;
        }
        sourceNode = (Item)source.getAdapter(Item.class);
        if (sourceNode != null) {
            IElementType[] allNodeTypes = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)((Item)sourceNode).getNode());
            ArrayList<Object> ids = new ArrayList<Object>();
            int i = 0;
            while (i < allNodeTypes.length) {
                IElementType targetNode = allNodeTypes[i];
                if (EdgeResolverService.getInstance().isEdgeTypeValid(relationshipType, targetNode)) {
                    ids.add(targetNode);
                }
                ++i;
            }
            return ids;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof SelectExistingElementForTargetOperation) {
            return false;
        }
        if (operation instanceof SelectExistingElementForSourceOperation) {
            return false;
        }
        return super.provides(operation);
    }

    public EObject selectExistingElementForSource(IAdaptable target, IElementType relationshipType) {
        return this.selectExistingElementForTarget(target, relationshipType);
    }

    public EObject selectExistingElementForTarget(IAdaptable source, IElementType relationshipType) {
        return null;
    }
}

