/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.providers;

import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.ui.services.icon.GetIconOperation;
import org.eclipse.gmf.runtime.common.ui.services.icon.IIconProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractIconProvider
extends AbstractProvider
implements IIconProvider {
    protected ImageRegistry registry;
    private Map<Integer, Map> idCache = new HashMap<Integer, Map>();

    public AbstractIconProvider() {
        this.registry = new ImageRegistry(Display.getDefault());
    }

    protected abstract Map getElementIdToIconURL(int var1);

    protected URL getGrabbyURL(IAdaptable hint) {
        return null;
    }

    public Image getIcon(IAdaptable hint, int flags) {
        URL iconPath;
        URL iconPath2;
        URL iconPath3;
        URL iconPath4;
        if (this.isGrabby(flags)) {
            URL iconPath5 = this.getGrabbyURL(hint);
            if (iconPath5 != null) {
                return this.getImage(iconPath5);
            }
            return null;
        }
        ResourceDescriptor descriptor = (ResourceDescriptor)hint.getAdapter(ResourceDescriptor.class);
        if (descriptor != null) {
            return this.getIconForResourceDescriptor(descriptor);
        }
        IElementType type = (IElementType)hint.getAdapter(IElementType.class);
        if (type != null && (iconPath4 = (URL)this.getIdToIconMap(flags).get(type.getId())) != null) {
            return this.getImage(iconPath4);
        }
        CommonElement element = (CommonElement)hint.getAdapter(CommonElement.class);
        if (element != null && (iconPath3 = (URL)this.getIdToIconMap(flags).get(element.getType())) != null) {
            return this.getImage(iconPath3);
        }
        Compartment compartment = (Compartment)hint.getAdapter(Compartment.class);
        if (compartment != null && (iconPath2 = (URL)this.getIdToIconMap(flags).get(compartment.getType())) != null) {
            return this.getImage(iconPath2);
        }
        View view = (View)hint.getAdapter(View.class);
        if (view != null && (iconPath = (URL)this.getIdToIconMap(flags).get(view.getType())) != null) {
            return this.getImage(iconPath);
        }
        return null;
    }

    public Image getIconForResourceDescriptor(ResourceDescriptor descriptor) {
        return null;
    }

    private Map getIdToIconMap(int flags) {
        Integer key = new Integer(flags);
        Map elementMap = this.idCache.get(key);
        if (elementMap == null) {
            elementMap = this.getElementIdToIconURL(flags);
            this.idCache.put(key, elementMap);
        }
        return elementMap;
    }

    protected final Image getImage(URL iconPath) {
        String key = iconPath.toString();
        Image image = this.registry.get(key);
        if (image == null) {
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)iconPath);
            this.registry.put(key, desc);
        }
        return this.registry.get(key);
    }

    protected final boolean is10x10(int flags) {
        return (flags & 8) == 8;
    }

    protected final boolean is16x16(int flags) {
        return (flags & 0x10) == 16;
    }

    protected final boolean is24x24(int flags) {
        return (flags & 0x20) == 32;
    }

    protected final boolean isGrabby(int flags) {
        return (flags & 0x40) == 64;
    }

    protected final boolean isRealized(int flags) {
        return (flags & 2) == 2;
    }

    protected final boolean isUnrealized(int flags) {
        return (flags & 4) == 4;
    }

    public boolean provides(IOperation operation) {
        GetIconOperation op;
        return operation instanceof GetIconOperation && (op = (GetIconOperation)operation).execute((IProvider)this) != null;
    }
}

